/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class CheckBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private boolean allowNullValue;
    private int column = -1;
    private Grids grids = null;
    private ArrayList itemListenerList = null;
    private CheckLabel label;
    private Object negativeValue = null;
    private Object positiveValue = null;
    private boolean required;
    private int row = -1;
    private Boolean selected = Boolean.FALSE;

    public CheckBoxCellEditor(Grids grids, boolean required, ArrayList itemListenerList, boolean allowNullValue, Object positiveValue, Object negativeValue) {
        this.label = new CheckLabel();
        this.grids = grids;
        this.required = required;
        this.itemListenerList = itemListenerList;
        this.allowNullValue = allowNullValue;
        this.positiveValue = positiveValue;
        this.negativeValue = negativeValue;
        this.label.setFocusable(true);
        this.label.addMouseListener(new MouseAdapter(){

            static /* synthetic */ CheckBoxCellEditor access$000(1 x0) {
                return x0.CheckBoxCellEditor.this;
            }

            public void mouseClicked(MouseEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (!CheckBoxCellEditor.access$100(1.access$000(this.this$1)).getGrid().hasFocus()) {
                            CheckBoxCellEditor.access$100(1.access$000(this.this$1)).getGrid().requestFocus();
                        }
                        1.access$000(this.this$1).changeSelectedValue();
                        Object value = null;
                        value = CheckBoxCellEditor.access$200(1.access$000(this.this$1)) == null && CheckBoxCellEditor.access$300(1.access$000(this.this$1)) ? null : (CheckBoxCellEditor.access$200(1.access$000(this.this$1)) == null && !CheckBoxCellEditor.access$300(1.access$000(this.this$1)) ? CheckBoxCellEditor.access$400(1.access$000(this.this$1)) : (CheckBoxCellEditor.access$200(1.access$000(this.this$1)) != false ? CheckBoxCellEditor.access$500(1.access$000(this.this$1)) : CheckBoxCellEditor.access$400(1.access$000(this.this$1))));
                        CheckBoxCellEditor.access$100(1.access$000(this.this$1)).getGrid().setValueAt(value, CheckBoxCellEditor.access$100(1.access$000(this.this$1)).getGrid().getSelectedRow(), CheckBoxCellEditor.access$100(1.access$000(this.this$1)).getGrid().convertColumnIndexToView(CheckBoxCellEditor.access$600(1.access$000(this.this$1))));
                        CheckBoxCellEditor.access$100(1.access$000(this.this$1)).getGrid().editCellAt(CheckBoxCellEditor.access$100(1.access$000(this.this$1)).getGrid().getSelectedRow(), CheckBoxCellEditor.access$100(1.access$000(this.this$1)).getGrid().convertColumnIndexToView(CheckBoxCellEditor.access$600(1.access$000(this.this$1))));
                        int i = 0;
                        while (i < CheckBoxCellEditor.access$700(1.access$000(this.this$1)).size()) {
                            ((ItemListener)CheckBoxCellEditor.access$700(1.access$000(this.this$1)).get(i)).itemStateChanged(new ItemEvent(new JCheckBox(), CheckBoxCellEditor.access$600(1.access$000(this.this$1)), 1.access$000(this.this$1), -1));
                            ++i;
                        }
                        CheckBoxCellEditor.access$100(1.access$000(this.this$1)).getGrid().repaint();
                    }
                });
            }
        });
    }

    private final Component _prepareEditor(Object value) {
        this.selected = value == null ? (this.allowNullValue ? null : Boolean.FALSE) : (this.positiveValue.equals(value) ? Boolean.TRUE : Boolean.FALSE);
        if (this.column != -1 && this.grids.isEnableInReadOnlyMode(this.column) && this.grids.getMode() == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (CheckBoxCellEditor.this.grids.getSelectedRow() != CheckBoxCellEditor.this.row) {
                        CheckBoxCellEditor.this.grids.setRowSelectionInterval(CheckBoxCellEditor.this.row, CheckBoxCellEditor.this.row);
                        CheckBoxCellEditor.this.changeSelectedValue();
                    }
                }
            });
        }
        this.label.repaint();
        return this.label;
    }

    public final void changeSelectedValue() {
        this.selected = this.allowNullValue ? (this.selected == null ? Boolean.TRUE : (Boolean.FALSE.equals(this.selected) ? null : Boolean.FALSE)) : (this.selected != null && Boolean.TRUE.equals(this.selected) ? Boolean.FALSE : Boolean.TRUE);
        if (this.grids.getMode() != 0 || this.grids.isEnableInReadOnlyMode(this.column) && this.grids.getMode() == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object value = null;
                    value = CheckBoxCellEditor.this.selected == null && CheckBoxCellEditor.this.allowNullValue ? null : (CheckBoxCellEditor.this.selected == null && !CheckBoxCellEditor.this.allowNullValue ? CheckBoxCellEditor.this.negativeValue : (CheckBoxCellEditor.this.selected != false ? CheckBoxCellEditor.this.positiveValue : CheckBoxCellEditor.this.negativeValue));
                    CheckBoxCellEditor.this.grids.getGrid().setValueAt(value, CheckBoxCellEditor.this.grids.getGrid().getSelectedRow(), CheckBoxCellEditor.this.grids.getGrid().convertColumnIndexToView(CheckBoxCellEditor.this.column));
                    CheckBoxCellEditor.this.grids.getGrid().editCellAt(CheckBoxCellEditor.this.grids.getGrid().getSelectedRow(), CheckBoxCellEditor.this.grids.getGrid().convertColumnIndexToView(CheckBoxCellEditor.this.column));
                    int i = 0;
                    while (i < CheckBoxCellEditor.this.itemListenerList.size()) {
                        ((ItemListener)CheckBoxCellEditor.this.itemListenerList.get(i)).itemStateChanged(new ItemEvent(new JCheckBox(), CheckBoxCellEditor.this.column, CheckBoxCellEditor.this, -1));
                        ++i;
                    }
                    CheckBoxCellEditor.this.grids.getGrid().repaint();
                }
            });
        }
    }

    public final void finalize() {
        this.grids = null;
        this.itemListenerList.clear();
    }

    public final Object getCellEditorValue() {
        Object value = null;
        value = this.selected == null && this.allowNullValue ? null : (this.selected == null && !this.allowNullValue ? this.negativeValue : (this.selected != false ? this.positiveValue : this.negativeValue));
        return value;
    }

    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.column = table.convertColumnIndexToModel(column);
        this.label.setPreferredSize(new Dimension(table.getColumnModel().getColumn(column).getWidth(), table.getHeight()));
        this.label.setOpaque(false);
        return this._prepareEditor(value);
    }

    public final boolean stopCellEditing() {
        return this.validate();
    }

    private final boolean validate() {
        this.fireEditingStopped();
        return true;
    }

    class CheckLabel
    extends JPanel {
        CheckLabel() {
        }

        static /* synthetic */ CheckBoxCellEditor access$1000(CheckLabel x0) {
            return x0.CheckBoxCellEditor.this;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (CheckBoxCellEditor.this.required) {
                g.setColor(ClientSettings.GRID_REQUIRED_CELL_BORDER);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            } else {
                g.setColor(Color.gray);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            g.translate(this.getWidth() / 2 - 6, this.getHeight() / 2 - 5);
            BasicGraphicsUtils.drawLoweredBezel(g, 0, 0, 12, 12, Color.darkGray, Color.black, Color.white, Color.gray);
            if (CheckBoxCellEditor.this.allowNullValue && CheckBoxCellEditor.this.selected == null) {
                g.setColor(Color.lightGray);
                g.fillRect(1, 1, 10, 10);
            }
            if (Boolean.TRUE.equals(CheckBoxCellEditor.this.selected)) {
                g.setColor(Color.black);
                g.drawLine(3, 5, 5, 7);
                g.drawLine(3, 6, 5, 8);
                g.drawLine(3, 7, 5, 9);
                g.drawLine(6, 6, 9, 3);
                g.drawLine(6, 7, 9, 4);
                g.drawLine(6, 8, 9, 5);
            }
        }

        public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (e.getSource() != null && (e.getSource() instanceof Grid || e.getSource().equals(this)) && e.getKeyChar() == ' ' && pressed) {
                try {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ CheckLabel this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            if (!CheckBoxCellEditor.access$100(CheckLabel.access$1000(this.this$1)).getGrid().hasFocus()) {
                                CheckBoxCellEditor.access$100(CheckLabel.access$1000(this.this$1)).getGrid().requestFocus();
                            }
                            CheckLabel.access$1000(this.this$1).changeSelectedValue();
                        }
                    });
                }
                catch (Exception ex) {
                }
            }
            return true;
        }
    }
}

