/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.client.CurrencyControl;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.columns.client.CurrencyColumnSettings;
import org.openswing.swing.table.columns.client.DecimalColumnSettings;
import org.openswing.swing.table.columns.client.IntegerColumnSettings;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class CurrencyCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    static /* synthetic */ Class class$java$lang$Number;
    private int col = -1;
    private IntegerColumnSettings dynamicSettings = null;
    protected CurrencyControl field;
    private boolean required;
    private int row = -1;
    private boolean selectDataOnEdit = ClientSettings.SELECT_DATA_IN_EDITABLE_GRID;
    private JTable table = null;

    public CurrencyCellEditor(int colType, int decimals, boolean required, boolean currencySymbolOnLeft, double minValue, double maxValue, String currencySymbol, IntegerColumnSettings dynamicSettings, boolean selectDataOnEdit) {
        this.field = new CurrencyControl(){

            public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getSource() != null && e.getSource() instanceof Grid) {
                    CurrencyCellEditor.this.field.processKeyEvent(e);
                } else if (e.getKeyChar() == '\t' || e.getKeyChar() == '\n') {
                    CurrencyCellEditor.this.stopCellEditing();
                }
                return true;
            }
        };
        this.field.setCurrencySymbol(currencySymbol);
        this.field.setCurrencySymbolOnLeft(currencySymbolOnLeft);
        this.field.setDecimals(decimals);
        this.required = required;
        this.dynamicSettings = dynamicSettings;
        this.selectDataOnEdit = selectDataOnEdit;
        this.field.setMinValue(minValue);
        this.field.setMaxValue(maxValue);
        this.field.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    CurrencyCellEditor.this.stopCellEditing();
                    CurrencyCellEditor.this.table.requestFocus();
                    try {
                        CurrencyCellEditor.this.table.setColumnSelectionInterval(CurrencyCellEditor.this.col + 1, CurrencyCellEditor.this.col + 1);
                    }
                    catch (Exception ex) {
                    }
                }
            }
        });
    }

    private Component _prepareEditor(Object value) {
        if (this.row != -1 && this.dynamicSettings != null) {
            if (this.dynamicSettings instanceof DecimalColumnSettings) {
                this.field.setDecimals(((DecimalColumnSettings)this.dynamicSettings).getDecimals(this.row));
            }
            this.field.setMinValue(this.dynamicSettings.getMinValue(this.row));
            this.field.setMaxValue(this.dynamicSettings.getMaxValue(this.row));
            if (this.dynamicSettings instanceof CurrencyColumnSettings) {
                this.field.setCurrencySymbol(((CurrencyColumnSettings)this.dynamicSettings).getCurrencySymbol(this.row));
            }
        }
        if (value != null && value.getClass().getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = CurrencyCellEditor.class$("java.lang.Number")) : class$java$lang$Number)) {
            this.field.setText(((Number)value).toString());
            if (this.selectDataOnEdit) {
                this.field.select(0, this.field.getText().length());
            }
        } else {
            this.field.setText(null);
        }
        return this.field;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final void finalize() {
        this.dynamicSettings = null;
        this.table = null;
        this.field = null;
    }

    public Object getCellEditorValue() {
        if (this.field.getText() == null || this.field.getText().length() == 0) {
            return null;
        }
        return this.field.getValue();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        this.col = column;
        JComponent c = (JComponent)this._prepareEditor(value);
        if (this.required) {
            c.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_REQUIRED_CELL_BORDER));
        }
        return c;
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.row = row;
        return this._prepareEditor(value);
    }

    public final boolean stopCellEditing() {
        return this.validate();
    }

    private boolean validate() {
        boolean ok = true;
        if (ok) {
            this.fireEditingStopped();
        }
        return ok;
    }
}

