/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.domains.java.DomainPair;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class DomainCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private ComponentOrientation compOrientation;
    private Domain domain = null;
    private JComboBox field = this.getComboBox();
    private ArrayList itemListeners = null;
    private JPanel p = new JPanel();
    private DomainPair[] pairs = null;
    private boolean required;
    private int selIndex = -1;
    private JTable table = null;
    private boolean translateItemDescriptions;

    public DomainCellEditor(Domain domain, boolean translateItemDescriptions, boolean required, ComponentOrientation orientation, ArrayList itemListeners) {
        this.domain = domain;
        this.translateItemDescriptions = translateItemDescriptions;
        this.required = required;
        this.itemListeners = itemListeners;
        this.pairs = domain.getDomainPairList();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        int i = 0;
        while (i < this.pairs.length) {
            if (translateItemDescriptions) {
                model.addElement(ClientSettings.getInstance().getResources().getResource(this.pairs[i].getDescription()));
            } else {
                model.addElement(this.pairs[i].getDescription());
            }
            ++i;
        }
        this.compOrientation = orientation;
        if (orientation != null) {
            this.field.setComponentOrientation(orientation);
        }
        this.field.setModel(model);
        int i2 = 0;
        while (i2 < itemListeners.size()) {
            this.field.addItemListener((ItemListener)itemListeners.get(i2));
            ++i2;
        }
        this.p.setOpaque(true);
        this.p.setLayout(new GridBagLayout());
        this.p.add((Component)this.field, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private final Component _prepareEditor(Object value) {
        DomainPair pair = this.domain.getDomainPair(value);
        if (pair != null) {
            int i = 0;
            while (i < this.pairs.length) {
                if (pair.getDescription().equals(this.pairs[i].getDescription())) {
                    this.field.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        } else {
            this.field.setSelectedIndex(-1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!DomainCellEditor.this.field.hasFocus()) {
                    DomainCellEditor.this.field.requestFocus();
                }
            }
        });
        return this.field;
    }

    public final void finalize() {
        this.table = null;
        this.field = null;
    }

    public final Object getCellEditorValue() {
        if (this.selIndex == -1) {
            this.selIndex = this.field.getSelectedIndex();
        }
        if (this.selIndex == -1) {
            return null;
        }
        return this.pairs[this.selIndex].getCode();
    }

    public JComboBox getComboBox() {
        return new JComboBox(){
            private KeyEvent oldEv = null;

            public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getSource() != null && e.getSource() instanceof Grid) {
                    try {
                        if (this.oldEv == null || !e.equals(this.oldEv)) {
                            this.oldEv = e;
                            DomainCellEditor.this.field.processKeyEvent(e);
                            this.oldEv = null;
                        }
                    }
                    catch (Exception ex) {
                    }
                } else if (e.getKeyChar() == '\t' || e.getKeyChar() == '\n') {
                    DomainCellEditor.this.stopCellEditing();
                    try {
                        if (!DomainCellEditor.this.table.hasFocus()) {
                            DomainCellEditor.this.table.requestFocus();
                        }
                        if (DomainCellEditor.this.table.getSelectedRow() != -1) {
                            DomainCellEditor.this.table.setRowSelectionInterval(DomainCellEditor.this.table.getSelectedRow(), DomainCellEditor.this.table.getSelectedRow());
                        }
                        DomainCellEditor.this.table.setColumnSelectionInterval(DomainCellEditor.this.table.getSelectedColumn() + 1, DomainCellEditor.this.table.getSelectedColumn() + 1);
                    }
                    catch (Exception ex) {
                    }
                }
                return true;
            }

            public void setSelectedIndex(int i) {
                super.setSelectedIndex(i);
                DomainCellEditor.this.selIndex = i;
            }
        };
    }

    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        if (this.required) {
            this.field.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_REQUIRED_CELL_BORDER));
        }
        this._prepareEditor(value);
        return this.p;
    }

    public final void setDomain(Domain domain) {
        this.domain = domain;
        this.pairs = domain.getDomainPairList();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        int i = 0;
        while (i < this.pairs.length) {
            if (this.translateItemDescriptions) {
                model.addElement(ClientSettings.getInstance().getResources().getResource(this.pairs[i].getDescription()));
            } else {
                model.addElement(this.pairs[i].getDescription());
            }
            ++i;
        }
        this.field = this.getComboBox();
        if (this.compOrientation != null) {
            this.field.setComponentOrientation(this.compOrientation);
        }
        this.field.setModel(model);
        int i2 = 0;
        while (i2 < this.itemListeners.size()) {
            this.field.addItemListener((ItemListener)this.itemListeners.get(i2));
            ++i2;
        }
        this.p = new JPanel();
        this.p.setOpaque(true);
        this.p.setLayout(new GridBagLayout());
        this.p.add((Component)this.field, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public final boolean stopCellEditing() {
        return this.validate();
    }

    private final boolean validate() {
        this.fireEditingStopped();
        return true;
    }
}

