/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class FileCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private String attributeName = null;
    private JPanel cell = new JPanel();
    private byte[] cellContent = null;
    private int col = -1;
    private JButton download;
    private JLabel fileName = new JLabel();
    private String fileNameAttributeName = null;
    private GridController gridController = null;
    private int row = -1;
    private boolean showDownloadButton = true;
    private boolean showUploadButton = true;
    private JTable table = null;
    private JButton upload = new JButton(ClientSettings.getInstance().getResources().getResource("upload file"));

    public FileCellEditor(GridController gridController, final FileFilter fileFilter, boolean showUploadButton, boolean showDownloadButton, String attributeName, String fileNameAttributeName) {
        this.download = new JButton(ClientSettings.getInstance().getResources().getResource("download file"));
        this.gridController = gridController;
        this.showUploadButton = showUploadButton;
        this.showDownloadButton = showDownloadButton;
        this.attributeName = attributeName;
        this.fileNameAttributeName = fileNameAttributeName;
        this.cell.setLayout(new GridBagLayout());
        if (fileNameAttributeName != null && !fileNameAttributeName.equals("")) {
            this.cell.add((Component)this.fileName, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (showUploadButton) {
            this.cell.add((Component)this.upload, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (showDownloadButton) {
            this.cell.add((Component)this.download, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.cell.setFocusable(true);
        this.download.setFocusable(true);
        this.upload.setFocusable(true);
        this.download.setPreferredSize(new Dimension(21, 20));
        this.download.setMinimumSize(new Dimension(100, 20));
        this.download.setMaximumSize(new Dimension(100, 20));
        this.upload.setPreferredSize(new Dimension(100, 20));
        this.upload.setMinimumSize(new Dimension(100, 20));
        this.upload.setMaximumSize(new Dimension(100, 20));
        this.upload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser f = new JFileChooser();
                f.setDialogTitle(ClientSettings.getInstance().getResources().getResource("upload file"));
                f.setDialogType(0);
                f.setApproveButtonText(ClientSettings.getInstance().getResources().getResource("upload file"));
                f.setFileSelectionMode(0);
                if (fileFilter != null) {
                    f.setFileFilter(fileFilter);
                }
                int res = f.showOpenDialog(ClientUtils.getParentFrame(FileCellEditor.this.table));
                if (res == 0 && FileCellEditor.this.table != null && FileCellEditor.this.table instanceof Grid) {
                    try {
                        if (FileCellEditor.this.fileNameAttributeName != null && !FileCellEditor.this.fileNameAttributeName.equals("")) {
                            ((Grid)FileCellEditor.this.table).getVOListTableModel().setField(FileCellEditor.this.row, FileCellEditor.this.fileNameAttributeName, f.getSelectedFile().getName());
                            FileCellEditor.this.fileName.setText(f.getSelectedFile().getName());
                        }
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f.getSelectedFile()));
                        byte[] bytes = new byte[(int)f.getSelectedFile().length()];
                        in.read(bytes);
                        in.close();
                        FileCellEditor.this.table.getModel().setValueAt(bytes, FileCellEditor.this.row, FileCellEditor.this.col);
                        FileCellEditor.access$502(FileCellEditor.this, bytes);
                        FileCellEditor.this.download.setEnabled(true);
                    }
                    catch (Exception ex) {
                        OptionPane.showMessageDialog(ClientUtils.getParentFrame(FileCellEditor.this.table), "Error", ex.getMessage(), 0);
                    }
                }
            }
        });
        this.download.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object obj;
                JFileChooser f = new JFileChooser();
                f.setDialogTitle(ClientSettings.getInstance().getResources().getResource("download file"));
                f.setDialogType(1);
                f.setApproveButtonText(ClientSettings.getInstance().getResources().getResource("download file"));
                if (FileCellEditor.this.fileNameAttributeName != null && !FileCellEditor.this.fileNameAttributeName.equals("") && (obj = ((Grid)FileCellEditor.this.table).getGrids().getVOListTableModel().getField(FileCellEditor.this.row, FileCellEditor.this.fileNameAttributeName)) != null) {
                    f.setSelectedFile(new File(obj.toString()));
                }
                int res = f.showSaveDialog(ClientUtils.getParentFrame(FileCellEditor.this.table));
                if (res == 0) {
                    try {
                        File file = f.getSelectedFile();
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                        FileCellEditor.access$502(FileCellEditor.this, (byte[])((Grid)FileCellEditor.this.table).getGrids().getVOListTableModel().getField(FileCellEditor.this.row, FileCellEditor.this.attributeName));
                        out.write(FileCellEditor.this.cellContent);
                        out.close();
                    }
                    catch (Throwable ex) {
                        OptionPane.showMessageDialog(ClientUtils.getParentFrame(FileCellEditor.this.table), ex.getMessage(), ClientSettings.getInstance().getResources().getResource("Error while saving"), 0);
                    }
                }
            }
        });
    }

    static /* synthetic */ byte[] access$502(FileCellEditor x0, byte[] x1) {
        x0.cellContent = x1;
        return x1;
    }

    public final void finalize() {
        this.table = null;
    }

    public final Object getCellEditorValue() {
        return this.cellContent;
    }

    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        this.col = column;
        this.cellContent = (byte[])value;
        this.download.setEnabled(this.cellContent != null);
        this.download.setOpaque(false);
        this.upload.setOpaque(false);
        this.fileName.setOpaque(false);
        this.upload.setEnabled(((Grid)table).getMode() != 0);
        if (isSelected && table instanceof Grid) {
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getActiveCellBackgroundColor();
            }
            Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            this.cell.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            this.download.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            this.upload.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            this.cell.setBorder(BorderFactory.createLineBorder(table.getSelectionForeground()));
        } else {
            this.cell.setForeground(this.gridController.getForegroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            this.cell.setBorder(BorderFactory.createRaisedBevelBorder());
            if (((Grid)table).getMode() == 0 || !((Grid)table).isColorsInReadOnlyMode()) {
                this.cell.setBackground(this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            } else if (table.isCellEditable(row, column)) {
                this.cell.setBackground(ClientSettings.GRID_EDITABLE_CELL_BACKGROUND);
            } else {
                this.cell.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
            }
        }
        if (table instanceof Grid && this.fileNameAttributeName != null && !this.fileNameAttributeName.equals("")) {
            Object obj = ((Grid)table).getGrids().getVOListTableModel().getField(row, this.fileNameAttributeName);
            this.fileName.setText(obj == null ? "" : obj.toString());
        }
        return this.cell;
    }

    public final boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }
}

