/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class FormattedTextCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private int col = -1;
    private JFormattedTextField field;
    private boolean required;
    private int row = -1;
    private JTable table = null;

    public FormattedTextCellEditor(JFormattedTextField field, boolean required) {
        this.field = field;
        this.required = required;
        field.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    FormattedTextCellEditor.this.stopCellEditing();
                    FormattedTextCellEditor.this.table.requestFocus();
                    try {
                        FormattedTextCellEditor.this.table.setColumnSelectionInterval(FormattedTextCellEditor.this.col + 1, FormattedTextCellEditor.this.col + 1);
                    }
                    catch (Exception ex) {
                    }
                }
            }
        });
    }

    public final void finalize() {
        this.table = null;
        this.field = null;
    }

    public Object getCellEditorValue() {
        return this.field.getValue();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        this.col = column;
        this.field.setValue(value);
        if (this.required) {
            this.field.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_REQUIRED_CELL_BORDER));
        }
        return this.field;
    }

    public final boolean stopCellEditing() {
        return this.validate();
    }

    private boolean validate() {
        boolean ok = true;
        try {
            this.field.setValue(this.field.getFormatter().stringToValue(this.field.getText()));
        }
        catch (ParseException ex) {
            ok = false;
        }
        if (this.field.getText() != null && this.field.getValue() == null) {
            ok = false;
        }
        if (!ok) {
            this.field.setText(null);
        }
        this.fireEditingStopped();
        return ok;
    }
}

