/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.client.ImagePanel;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class ImageCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JPanel cell;
    private int col = -1;
    private GridBagLayout gridBagLayout1;
    private ImagePanel imagePanel;
    private int row = -1;
    private JButton selButton = new JButton(){

        public void paint(Graphics g) {
            super.paint(g);
            int width = g.getFontMetrics().stringWidth("...");
            if (this.isEnabled()) {
                g.setColor(UIManager.getColor("Button.foreground"));
            } else {
                g.setColor(UIManager.getColor("Button.disabledForeground"));
            }
            g.drawString("...", (this.getWidth() - width + 1) / 2, this.getHeight() / 2 + 4);
        }
    };
    private JTable table = null;

    public ImageCellEditor(boolean showButton, final FileFilter fileFilter, final ArrayList listeners, final boolean showPreview) {
        this.imagePanel = new ImagePanel();
        this.cell = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.cell.setLayout(this.gridBagLayout1);
        this.cell.add((Component)this.imagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.imagePanel.setScrollBarsPolicy(21);
        this.cell.setFocusable(true);
        this.selButton.setPreferredSize(new Dimension(21, 20));
        this.selButton.setMinimumSize(new Dimension(21, 20));
        this.selButton.setMaximumSize(new Dimension(21, 20));
        this.selButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser f = new JFileChooser();
                f.setDialogTitle(ClientSettings.getInstance().getResources().getResource("image selection"));
                Container c = ImageCellEditor.this.cell.getParent();
                while (c != null && !(c instanceof JFrame) && !(c instanceof JInternalFrame)) {
                    c = c.getParent();
                }
                if (c == null) {
                    c = MDIFrame.getInstance();
                }
                f.setFileSelectionMode(0);
                if (showPreview) {
                    PreviewImage ip = new PreviewImage();
                    f.setAccessory(ip);
                    ip.setPreferredSize(new Dimension(100, 100));
                    ip.setBorder(BorderFactory.createEtchedBorder());
                    f.addPropertyChangeListener(new PropertyChangeListener(this, ip){
                        private final /* synthetic */ 2 this$1;
                        private final /* synthetic */ PreviewImage val$ip;
                        {
                            this.this$1 = this$1;
                            this.val$ip = val$ip;
                        }

                        public void propertyChange(PropertyChangeEvent evt) {
                            try {
                                if (evt.getPropertyName().equals("SelectedFileChangedProperty")) {
                                    this.val$ip.setImage((File)evt.getNewValue());
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                }
                if (fileFilter != null) {
                    f.setFileFilter(fileFilter);
                }
                int res = f.showOpenDialog(c);
                if (res == 0) {
                    try {
                        ImageCellEditor.this.imagePanel.setImageAsStream(new FileInputStream(f.getSelectedFile()));
                        if (ImageCellEditor.this.table != null && ImageCellEditor.this.table instanceof Grid && !((Grid)ImageCellEditor.this.table).isRowHeightFixed() && ImageCellEditor.this.row != -1 && ImageCellEditor.this.col != -1) {
                            ImageCellEditor.this.table.setRowHeight(ImageCellEditor.this.row, ImageCellEditor.this.imagePanel.getImageHeight());
                        }
                        if (ImageCellEditor.this.row != -1 && ImageCellEditor.this.col != -1) {
                            ImageCellEditor.this.table.getModel().setValueAt(ImageCellEditor.this.imagePanel.getImage(), ImageCellEditor.this.row, ImageCellEditor.this.col);
                        }
                        int i = 0;
                        while (i < listeners.size()) {
                            ((ActionListener)listeners.get(i)).actionPerformed(new ActionEvent(ImageCellEditor.this, e.getID(), f.getSelectedFile().getAbsolutePath()));
                            ++i;
                        }
                    }
                    catch (Exception ex) {
                        Logger.error("org.openswing.swing.client.ImageControl", "actionPerformed", ex.getMessage(), ex);
                        OptionPane.showMessageDialog(c, "Error", ex.getMessage(), 0);
                    }
                }
            }
        });
        if (showButton) {
            this.cell.add((Component)this.selButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        }
    }

    public final void finalize() {
        this.table = null;
    }

    public final Object getCellEditorValue() {
        return this.imagePanel.getImage();
    }

    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        this.col = column;
        this.imagePanel.setImage((byte[])value);
        if (table instanceof Grid && !((Grid)table).isCellEditable(row, column)) {
            return this.imagePanel;
        }
        return this.cell;
    }

    public final boolean stopCellEditing() {
        return true;
    }

    class PreviewImage
    extends JLabel {
        public PreviewImage() {
            this.setPreferredSize(new Dimension(100, 100));
            this.setBorder(BorderFactory.createEtchedBorder());
        }

        public void setImage(File f) {
            ImageIcon icon = new ImageIcon(f.getPath());
            if (icon.getIconWidth() > this.getWidth()) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(this.getWidth(), -1, 1));
            }
            this.setIcon(icon);
            this.repaint();
        }
    }
}

