/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.client.LinkButton;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class LinkCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private ArrayList actionListeners = null;
    private LinkButton field = new LinkButton();
    private GridController gridController = null;
    public String labelAttributeName = null;
    private int row = -1;
    private JTable table = null;
    public String uriAttributeName = null;
    private Object value = null;

    public LinkCellEditor(GridController gridController, String uriAttributeName, ArrayList actionListeners, ComponentOrientation orientation, String labelAttributeName) {
        this.gridController = gridController;
        this.uriAttributeName = uriAttributeName;
        this.labelAttributeName = labelAttributeName;
        this.actionListeners = actionListeners;
        this.field.addActionListener(this);
        this.field.setOpaque(true);
        if (orientation != null) {
            this.field.setComponentOrientation(orientation);
        }
    }

    private final Component _prepareEditor(Object value) {
        this.value = value;
        if (value != null) {
            this.field.setText(value.toString());
        } else {
            this.field.setText("");
        }
        return this.field;
    }

    public final void actionPerformed(ActionEvent e) {
        if (this.row != -1) {
            this.table.setRowSelectionInterval(this.row, this.row);
        }
        if (this.actionListeners != null) {
            int i = 0;
            while (i < this.actionListeners.size()) {
                ((ActionListener)this.actionListeners.get(i)).actionPerformed(e);
                ++i;
            }
        }
    }

    public final void finalize() {
        if (this.field != null) {
            this.field.removeActionListener(this);
        }
        this.table = null;
        this.field = null;
        this.actionListeners.clear();
    }

    public final Object getCellEditorValue() {
        return this.value;
    }

    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
        Color selColor = null;
        try {
            selColor = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
        }
        catch (Exception ex1) {
            selColor = ((Grid)table).getActiveCellBackgroundColor();
        }
        this.field.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
        table.setRowSelectionInterval(row, row);
        table.setColumnSelectionInterval(column, column);
        this.field.setBorder(BorderFactory.createLineBorder(table.getSelectionForeground()));
        this.field.setToolTipText(this.gridController.getCellTooltip(row, ((Grid)table).getVOListTableModel().getColumnName(table.convertColumnIndexToModel(column))));
        this.field.setLabel((String)((Grid)table).getVOListTableModel().getField(row, this.labelAttributeName));
        this.field.setUri((String)((Grid)table).getVOListTableModel().getField(row, this.uriAttributeName));
        this.field.linkClicked();
        return this._prepareEditor(value);
    }

    public final boolean stopCellEditing() {
        return this.validate();
    }

    private final boolean validate() {
        this.fireEditingStopped();
        return true;
    }
}

