/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.client.TextAreaControl;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class MultiLineTextCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private int col = -1;
    private TextAreaControl field = new TextAreaControl(){
        private KeyEvent oldEv = null;

        public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (e.getSource() != null && e.getSource() instanceof Grid) {
                try {
                    if (this.oldEv == null || !e.equals(this.oldEv)) {
                        this.oldEv = e;
                        MultiLineTextCellEditor.this.field.processKeyEvent(e);
                        this.oldEv = null;
                    }
                }
                catch (Exception ex) {
                }
            } else if (e.getKeyChar() == '\t' || e.getKeyChar() == '\n') {
                MultiLineTextCellEditor.this.stopCellEditing();
            }
            return true;
        }
    };
    private int maxCharacters = -1;
    private boolean required;
    private int row = -1;
    private boolean selectDataOnEdit = ClientSettings.SELECT_DATA_IN_EDITABLE_GRID;
    private JTable table = null;

    public MultiLineTextCellEditor(int maxCharacters, boolean required, boolean selectDataOnEdit, ComponentOrientation orientation) {
        this.required = required;
        this.maxCharacters = maxCharacters;
        this.selectDataOnEdit = selectDataOnEdit;
        ((JTextArea)this.field.getBindingComponent()).setLineWrap(true);
        ((JTextArea)this.field.getBindingComponent()).setWrapStyleWord(true);
        ((JTextArea)this.field.getBindingComponent()).setOpaque(true);
        if (orientation != null) {
            this.field.setComponentOrientation(orientation);
        }
        this.field.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    MultiLineTextCellEditor.this.stopCellEditing();
                    MultiLineTextCellEditor.this.table.requestFocus();
                    try {
                        MultiLineTextCellEditor.this.table.setColumnSelectionInterval(MultiLineTextCellEditor.this.col + 1, MultiLineTextCellEditor.this.col + 1);
                    }
                    catch (Exception ex) {
                    }
                }
            }
        });
    }

    public final void finalize() {
        this.table = null;
        this.field = null;
    }

    public Object getCellEditorValue() {
        String text = (String)this.field.getValue();
        if (text == null) {
            text = "";
        }
        if (this.field != null && text.length() > this.maxCharacters) {
            this.field.setText(text.substring(0, this.maxCharacters));
        }
        if ((text = (String)this.field.getValue()) == null) {
            text = "";
        }
        return text;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        this.col = column;
        this.field.setText((String)value);
        if (this.selectDataOnEdit) {
            this.field.getTextArea().select(0, this.field.getTextArea().getText().length());
        }
        if (this.required) {
            this.field.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_REQUIRED_CELL_BORDER));
        }
        return this.field;
    }

    public final boolean stopCellEditing() {
        return this.validate();
    }

    private boolean validate() {
        boolean ok;
        String text = (String)this.field.getValue();
        if (text == null) {
            text = "";
        }
        boolean bl = ok = this.field == null || text.length() <= this.maxCharacters;
        if (ok) {
            this.fireEditingStopped();
        }
        return ok;
    }
}

