/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class TextCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private int col = -1;
    private boolean encryptText;
    private TextControl field = new TextControl(){
        private KeyEvent oldEv = null;

        public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (e.getSource() != null && e.getSource() instanceof Grid) {
                try {
                    if (this.oldEv == null || !e.equals(this.oldEv)) {
                        this.oldEv = e;
                        TextCellEditor.this.field.processKeyEvent(e);
                        this.oldEv = null;
                    }
                }
                catch (Exception ex) {
                }
            } else if (e.getKeyChar() == '\t' || e.getKeyChar() == '\n') {
                TextCellEditor.this.stopCellEditing();
            }
            return true;
        }
    };
    private int maxCharacters = -1;
    private JPasswordField passwdField = new JPasswordField();
    private boolean required;
    private int row = -1;
    private boolean selectDataOnEdit = ClientSettings.SELECT_DATA_IN_EDITABLE_GRID;
    private JTable table = null;

    public TextCellEditor(int maxCharacters, boolean required, boolean rPadding, boolean trimText, boolean upperCase, boolean selectDataOnEdit, ComponentOrientation orientation) {
        this.required = required;
        this.maxCharacters = maxCharacters;
        this.selectDataOnEdit = selectDataOnEdit;
        this.field.setColumns(maxCharacters);
        this.field.setMaxCharacters(maxCharacters);
        this.field.setRpadding(rPadding);
        this.field.setTrimText(trimText);
        this.field.setUpperCase(upperCase);
        if (orientation != null) {
            this.field.setComponentOrientation(orientation);
        }
        this.field.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    TextCellEditor.this.stopCellEditing();
                    TextCellEditor.this.table.requestFocus();
                    try {
                        TextCellEditor.this.table.setColumnSelectionInterval(TextCellEditor.this.col + 1, TextCellEditor.this.col + 1);
                    }
                    catch (Exception ex) {
                    }
                }
            }
        });
    }

    public TextCellEditor(int maxCharacters, boolean required) {
        this.required = required;
        this.maxCharacters = maxCharacters;
        this.encryptText = true;
    }

    public final void finalize() {
        this.passwdField = null;
        this.table = null;
        this.field = null;
    }

    public Object getCellEditorValue() {
        if (!this.encryptText) {
            if (this.field != null && this.field.getText().length() > this.maxCharacters) {
                this.field.setText(this.field.getText().substring(0, this.maxCharacters));
            }
            return this.field.getText();
        }
        if (this.passwdField.getText().length() > this.maxCharacters) {
            this.passwdField.setText(this.passwdField.getText().substring(0, this.maxCharacters));
        }
        return this.passwdField.getText();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        this.col = column;
        if (!this.encryptText) {
            this.field.setText((String)value);
            if (this.selectDataOnEdit) {
                this.field.select(0, this.field.getText().length());
            }
            if (this.required) {
                this.field.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_REQUIRED_CELL_BORDER));
            }
            return this.field;
        }
        this.passwdField.setText((String)value);
        if (this.selectDataOnEdit) {
            this.field.select(0, this.field.getText().length() - 1);
        }
        if (this.required) {
            this.passwdField.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_REQUIRED_CELL_BORDER));
        }
        return this.passwdField;
    }

    public final boolean stopCellEditing() {
        return this.validate();
    }

    private boolean validate() {
        boolean ok = !this.encryptText ? this.field == null || this.field.getText().length() <= this.maxCharacters : this.passwdField.getText().length() <= this.maxCharacters;
        if (ok) {
            this.fireEditingStopped();
        }
        return ok;
    }
}

