/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.model.client;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.ButtonColumn;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.util.client.ClientSettings;

public class VOListAdapter {
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$org$openswing$swing$message$receive$java$ValueObject;
    private Column[] colProperties = null;
    private Grids grids = null;
    private Hashtable indexes;
    private Hashtable reverseIndexes;
    private GridController tableContainer = null;
    private Class valueObjectType = null;
    private Hashtable voGetterMethods;
    private Hashtable voSetterMethods = new Hashtable();

    public VOListAdapter(Class valueObjectType, GridController tableContainer, Column[] colProperties, Grids grids) {
        this.voGetterMethods = new Hashtable();
        this.indexes = new Hashtable();
        this.reverseIndexes = new Hashtable();
        this.tableContainer = tableContainer;
        this.colProperties = colProperties;
        this.grids = grids;
        this.valueObjectType = valueObjectType;
        this.analyzeClassFields(new Hashtable(), "", new Method[0], valueObjectType);
    }

    private void analyzeClassFields(Hashtable vosAlreadyProcessed, String prefix, Method[] parentMethods, Class classType) {
        try {
            Integer num = (Integer)vosAlreadyProcessed.get(classType);
            if (num == null) {
                num = new Integer(0);
            }
            if ((num = new Integer(num + 1)) > ClientSettings.MAX_NR_OF_LOOPS_IN_ANALYZE_VO) {
                return;
            }
            vosAlreadyProcessed.put(classType, num);
            String attributeName = null;
            Method[] methods = classType.getMethods();
            String aName = null;
            int i = 0;
            while (i < methods.length) {
                Method[] newparentMethods;
                attributeName = methods[i].getName();
                if (attributeName.startsWith("get") && methods[i].getParameterTypes().length == 0 && (class$org$openswing$swing$message$receive$java$ValueObject == null ? VOListAdapter.class$("org.openswing.swing.message.receive.java.ValueObject") : class$org$openswing$swing$message$receive$java$ValueObject).isAssignableFrom(methods[i].getReturnType())) {
                    aName = this.getAttributeName(attributeName, classType);
                    newparentMethods = new Method[parentMethods.length + 1];
                    System.arraycopy(parentMethods, 0, newparentMethods, 0, parentMethods.length);
                    newparentMethods[parentMethods.length] = methods[i];
                    this.analyzeClassFields(vosAlreadyProcessed, prefix + aName + ".", newparentMethods, methods[i].getReturnType());
                }
                if (attributeName.startsWith("get") && methods[i].getParameterTypes().length == 0 && (methods[i].getReturnType().equals(class$java$lang$String == null ? VOListAdapter.class$("java.lang.String") : class$java$lang$String) || methods[i].getReturnType().equals(class$java$lang$Long == null ? VOListAdapter.class$("java.lang.Long") : class$java$lang$Long) || methods[i].getReturnType().equals(Long.TYPE) || methods[i].getReturnType().equals(class$java$lang$Float == null ? VOListAdapter.class$("java.lang.Float") : class$java$lang$Float) || methods[i].getReturnType().equals(Float.TYPE) || methods[i].getReturnType().equals(class$java$lang$Short == null ? VOListAdapter.class$("java.lang.Short") : class$java$lang$Short) || methods[i].getReturnType().equals(Short.TYPE) || methods[i].getReturnType().equals(class$java$lang$Double == null ? VOListAdapter.class$("java.lang.Double") : class$java$lang$Double) || methods[i].getReturnType().equals(Double.TYPE) || methods[i].getReturnType().equals(class$java$math$BigDecimal == null ? VOListAdapter.class$("java.math.BigDecimal") : class$java$math$BigDecimal) || methods[i].getReturnType().equals(class$java$util$Date == null ? VOListAdapter.class$("java.util.Date") : class$java$util$Date) || methods[i].getReturnType().equals(class$java$sql$Date == null ? VOListAdapter.class$("java.sql.Date") : class$java$sql$Date) || methods[i].getReturnType().equals(class$java$sql$Timestamp == null ? VOListAdapter.class$("java.sql.Timestamp") : class$java$sql$Timestamp) || methods[i].getReturnType().equals(class$java$lang$Integer == null ? VOListAdapter.class$("java.lang.Integer") : class$java$lang$Integer) || methods[i].getReturnType().equals(Integer.TYPE) || methods[i].getReturnType().equals(class$java$lang$Character == null ? VOListAdapter.class$("java.lang.Character") : class$java$lang$Character) || methods[i].getReturnType().equals(class$java$lang$Boolean == null ? VOListAdapter.class$("java.lang.Boolean") : class$java$lang$Boolean) || methods[i].getReturnType().equals(Boolean.TYPE) || methods[i].getReturnType().equals(class$javax$swing$ImageIcon == null ? VOListAdapter.class$("javax.swing.ImageIcon") : class$javax$swing$ImageIcon) || methods[i].getReturnType().equals(class$javax$swing$Icon == null ? VOListAdapter.class$("javax.swing.Icon") : class$javax$swing$Icon) || methods[i].getReturnType().equals(array$B == null ? VOListAdapter.class$("[B") : array$B) || methods[i].getReturnType().equals(class$java$lang$Object == null ? VOListAdapter.class$("java.lang.Object") : class$java$lang$Object) || (class$org$openswing$swing$message$receive$java$ValueObject == null ? VOListAdapter.class$("org.openswing.swing.message.receive.java.ValueObject") : class$org$openswing$swing$message$receive$java$ValueObject).isAssignableFrom(methods[i].getReturnType()))) {
                    attributeName = this.getAttributeName(attributeName, classType);
                    newparentMethods = new Method[parentMethods.length + 1];
                    System.arraycopy(parentMethods, 0, newparentMethods, 0, parentMethods.length);
                    newparentMethods[parentMethods.length] = methods[i];
                    this.voGetterMethods.put(prefix + attributeName, newparentMethods);
                } else if (attributeName.startsWith("is") && methods[i].getParameterTypes().length == 0 && (methods[i].getReturnType().equals(class$java$lang$Boolean == null ? VOListAdapter.class$("java.lang.Boolean") : class$java$lang$Boolean) || methods[i].getReturnType().equals(Boolean.TYPE))) {
                    attributeName = this.getAttributeName(attributeName, classType);
                    newparentMethods = new Method[parentMethods.length + 1];
                    System.arraycopy(parentMethods, 0, newparentMethods, 0, parentMethods.length);
                    newparentMethods[parentMethods.length] = methods[i];
                    this.voGetterMethods.put(prefix + attributeName, newparentMethods);
                } else if (attributeName.startsWith("set") && methods[i].getParameterTypes().length == 1) {
                    attributeName = this.getAttributeName(attributeName, classType);
                    try {
                        if (classType.getMethod("get" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), new Class[0]) != null) {
                            newparentMethods = new Method[parentMethods.length + 1];
                            System.arraycopy(parentMethods, 0, newparentMethods, 0, parentMethods.length);
                            newparentMethods[parentMethods.length] = methods[i];
                            this.voSetterMethods.put(prefix + attributeName, newparentMethods);
                        }
                    }
                    catch (NoSuchMethodException ex) {
                        try {
                            if (classType.getMethod("is" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), new Class[0]) != null) {
                                Method[] newparentMethods2 = new Method[parentMethods.length + 1];
                                System.arraycopy(parentMethods, 0, newparentMethods2, 0, parentMethods.length);
                                newparentMethods2[parentMethods.length] = methods[i];
                                this.voSetterMethods.put(prefix + attributeName, newparentMethods2);
                            }
                        }
                        catch (NoSuchMethodException exx) {
                        }
                    }
                }
                ++i;
            }
            HashSet<String> alreadyAdded = new HashSet<String>();
            int i2 = 0;
            i2 = 0;
            while (i2 < this.colProperties.length) {
                this.indexes.put(new Integer(i2), this.colProperties[i2].getColumnName());
                this.reverseIndexes.put(this.colProperties[i2].getColumnName(), new Integer(i2));
                alreadyAdded.add(this.colProperties[i2].getColumnName());
                ++i2;
            }
            Enumeration en = this.voGetterMethods.keys();
            while (en.hasMoreElements()) {
                attributeName = en.nextElement().toString();
                if (alreadyAdded.contains(attributeName)) continue;
                this.indexes.put(new Integer(i2), attributeName);
                this.reverseIndexes.put(attributeName, new Integer(i2));
                ++i2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final void finalize() {
        this.colProperties = null;
        this.voSetterMethods = null;
        this.voGetterMethods = null;
        this.tableContainer = null;
        this.grids = null;
        this.indexes = null;
        this.reverseIndexes = null;
    }

    private String getAttributeName(String methodName, Class classType) {
        String attributeName;
        block9: {
            attributeName = null;
            attributeName = methodName.startsWith("is") ? methodName.substring(2, 3).toLowerCase() + (methodName.length() > 3 ? methodName.substring(3) : "") : methodName.substring(3, 4).toLowerCase() + (methodName.length() > 4 ? methodName.substring(4) : "");
            try {
                Class c = classType;
                boolean attributeFound = false;
                while (!c.equals(class$java$lang$Object == null ? VOListAdapter.class$("java.lang.Object") : class$java$lang$Object)) {
                    try {
                        c.getDeclaredField(attributeName);
                        attributeFound = true;
                        break;
                    }
                    catch (Throwable ex2) {
                        c = c.getSuperclass();
                    }
                }
                if (attributeFound) break block9;
                String name = attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
                c = classType;
                while (!c.equals(class$java$lang$Object == null ? VOListAdapter.class$("java.lang.Object") : class$java$lang$Object)) {
                    try {
                        c.getDeclaredField(name);
                        attributeFound = true;
                        break;
                    }
                    catch (Throwable ex2) {
                        c = c.getSuperclass();
                    }
                }
                if (attributeFound) {
                    attributeName = name;
                }
            }
            catch (Throwable ex1) {}
        }
        return attributeName;
    }

    public final TableCellEditor getCellEditor(int colIndex) {
        try {
            return this.colProperties[colIndex].getCellEditor(this.tableContainer, this.grids);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public final TableCellRenderer getCellRenderer(int colIndex) {
        try {
            return this.colProperties[colIndex].getCellRenderer(this.tableContainer, this.grids);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public final Object getField(ValueObject obj, int colIndex) {
        try {
            Method[] m = (Method[])this.voGetterMethods.get(this.getFieldName(colIndex));
            if (m == null) {
                Logger.error(this.getClass().getName(), "getField", "No getter method for index " + colIndex + " and attribute name '" + this.getFieldName(colIndex) + "'.", null);
            }
            int i = 0;
            while (i < m.length - 1) {
                if ((obj = (ValueObject)m[i].invoke((Object)obj, new Object[0])) == null) {
                    if (this.grids.getGridControl() == null || !this.grids.getGridControl().isCreateInnerVO()) {
                        return null;
                    }
                    obj = (ValueObject)m[i].getReturnType().newInstance();
                }
                ++i;
            }
            return m[m.length - 1].invoke((Object)obj, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public final Class getFieldClass(int colIndex) {
        try {
            Method[] m = (Method[])this.voGetterMethods.get(this.getFieldName(colIndex));
            if (m == null) {
                Logger.error(this.getClass().getName(), "getField", "No getter method for index " + colIndex + " and attribute name '" + this.getFieldName(colIndex) + "'.", null);
            }
            return m[m.length - 1].getReturnType();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return class$java$lang$String == null ? (class$java$lang$String = VOListAdapter.class$("java.lang.String")) : class$java$lang$String;
        }
    }

    public final Column getFieldColumn(int colIndex) {
        return this.colProperties[colIndex];
    }

    public final int getFieldCount() {
        return this.colProperties.length;
    }

    public final int getFieldIndex(String fieldName) {
        Integer index = (Integer)this.reverseIndexes.get(fieldName);
        if (index != null) {
            return index;
        }
        Logger.error(this.getClass().getName(), "getFieldIndex", "The column '" + fieldName + "' does not exist", null);
        return -1;
    }

    public final int getFieldMaxWidth(int colIndex) {
        return this.colProperties[colIndex].getMaxWidth();
    }

    public final int getFieldMinWidth(int colIndex) {
        return this.colProperties[colIndex].getMinWidth();
    }

    public final String getFieldName(int colIndex) {
        String attributeName = (String)this.indexes.get(new Integer(colIndex));
        if (attributeName == null) {
            Logger.error(this.getClass().getName(), "getField", "No attribute found for index " + colIndex + ".", null);
        }
        return attributeName;
    }

    public final int getFieldPreferredWidth(int colIndex) {
        return this.colProperties[colIndex].getPreferredWidth();
    }

    public final int getFieldType(int colIndex) {
        return this.colProperties[colIndex].getColumnType();
    }

    public final Grids getGrids() {
        return this.grids;
    }

    public final GridController getTableContainer() {
        return this.tableContainer;
    }

    public final Class getValueObjectType() {
        return this.valueObjectType;
    }

    public final boolean isFieldDuplicable(int colIndex) {
        return this.colProperties[colIndex].isColumnDuplicable();
    }

    public final boolean isFieldEditable(int mode, int rowNumber, int colIndex) {
        if (colIndex < this.colProperties.length) {
            if (mode == 1) {
                return this.colProperties[colIndex].isEditableOnInsert();
            }
            if (mode == 2) {
                if (this.grids != null && this.grids.isAllowInsertInEdit() && this.grids.getCurrentNumberOfNewRows() > 0 && rowNumber >= this.grids.getVOListTableModel().getRowCount() - this.grids.getCurrentNumberOfNewRows()) {
                    return this.colProperties[colIndex].isEditableOnInsert();
                }
                if (this.grids != null && this.grids.isEditOnSingleRow() && rowNumber != this.grids.getCurrentEditingRow()) {
                    return false;
                }
                return this.colProperties[colIndex].isEditableOnEdit();
            }
            if (this.colProperties[colIndex].getColumnType() == 11 && ((ButtonColumn)this.colProperties[colIndex]).isEnableInReadOnlyMode()) {
                return true;
            }
            if (this.colProperties[colIndex].getColumnType() == 19) {
                return true;
            }
            return this.colProperties[colIndex].getColumnType() == 6 && ((CheckBoxColumn)this.colProperties[colIndex]).isEnableInReadOnlyMode();
        }
        return mode == 1 || mode == 2;
    }

    public final boolean isFieldEditable(int colIndex) {
        return false;
    }

    public final void setField(ValueObject obj, String attributeName, Object value) {
        try {
            Method[] m;
            Method[] getter = (Method[])this.voGetterMethods.get(attributeName);
            Method[] setter = (Method[])this.voSetterMethods.get(attributeName);
            if (getter == null) {
                Logger.error(this.getClass().getName(), "setField", "No getter method for attribute name '" + attributeName + "'.", null);
            }
            if (setter == null) {
                Logger.error(this.getClass().getName(), "setField", "No setter method for attribute name '" + attributeName + "'.", null);
            }
            if (value != null && (value instanceof Number || !value.equals("") && value instanceof String)) {
                if (!getter[getter.length - 1].getReturnType().equals(value.getClass())) {
                    Class<?> attrType = getter[getter.length - 1].getReturnType();
                    if (attrType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = VOListAdapter.class$("java.lang.Integer")) : class$java$lang$Integer) || attrType.equals(Integer.TYPE)) {
                        value = new Integer(Double.valueOf(value.toString()).intValue());
                    } else if (attrType.equals(class$java$lang$Double == null ? (class$java$lang$Double = VOListAdapter.class$("java.lang.Double")) : class$java$lang$Double) || attrType.equals(Double.TYPE)) {
                        value = new Double(value.toString());
                    } else if (attrType.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = VOListAdapter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                        value = new BigDecimal(value.toString());
                    } else if (attrType.equals(class$java$lang$Long == null ? (class$java$lang$Long = VOListAdapter.class$("java.lang.Long")) : class$java$lang$Long) || attrType.equals(Long.TYPE)) {
                        value = new Long(Double.valueOf(value.toString()).longValue());
                    } else if (attrType.equals(class$java$lang$Short == null ? (class$java$lang$Short = VOListAdapter.class$("java.lang.Short")) : class$java$lang$Short) || attrType.equals(Short.TYPE)) {
                        value = new Short(Double.valueOf(value.toString()).shortValue());
                    } else if (attrType.equals(class$java$lang$Float == null ? (class$java$lang$Float = VOListAdapter.class$("java.lang.Float")) : class$java$lang$Float) || attrType.equals(Float.TYPE)) {
                        value = new Float(Double.valueOf(value.toString()).floatValue());
                    }
                }
            } else if (value != null && value.equals("") && !getter[getter.length - 1].getReturnType().equals(value.getClass())) {
                value = null;
            }
            if (value != null && value.getClass().equals(class$java$util$Date == null ? (class$java$util$Date = VOListAdapter.class$("java.util.Date")) : class$java$util$Date)) {
                if (setter[setter.length - 1].getParameterTypes()[0].equals(class$java$sql$Date == null ? (class$java$sql$Date = VOListAdapter.class$("java.sql.Date")) : class$java$sql$Date)) {
                    value = new Date(((java.util.Date)value).getTime());
                } else if (setter[setter.length - 1].getParameterTypes()[0].equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = VOListAdapter.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
                    value = new Timestamp(((java.util.Date)value).getTime());
                }
            }
            if ((m = (Method[])this.voGetterMethods.get(attributeName)) == null) {
                Logger.error(this.getClass().getName(), "setField", "No getter method for attribute name '" + attributeName + "'.", null);
            }
            ValueObject oldObj = obj;
            int i = 0;
            while (i < m.length - 1) {
                oldObj = obj;
                if ((obj = (ValueObject)m[i].invoke((Object)oldObj, new Object[0])) == null) {
                    if (this.grids.getGridControl() == null || !this.grids.getGridControl().isCreateInnerVO()) {
                        return;
                    }
                    obj = (ValueObject)m[i].getReturnType().newInstance();
                    String[] attrs = attributeName.split("\\.");
                    String auxAttr = "";
                    int k = 0;
                    while (k <= i) {
                        auxAttr = auxAttr + attrs[k] + ".";
                        ++k;
                    }
                    auxAttr = auxAttr.substring(0, auxAttr.length() - 1);
                    Method aux = ((Method[])this.voSetterMethods.get(auxAttr))[i];
                    aux.invoke((Object)oldObj, obj);
                }
                ++i;
            }
            setter[setter.length - 1].invoke((Object)obj, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void setField(ValueObject obj, int colIndex, Object value) {
        this.setField(obj, this.getFieldName(colIndex), value);
    }
}

