/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.util.client.ClientSettings;

public class ButtonTableCellRenderer
extends DefaultTableCellRenderer {
    private String attributeName = null;
    private Font defaultFont = null;
    private boolean enableInReadOnlyMode = false;
    private GridController gridController = null;
    private JButton rend = new JButton();
    private boolean showAttributeValue;

    public ButtonTableCellRenderer(String text, boolean showAttributeValue, GridController gridController, int alignement, boolean enableInReadOnlyMode, Icon icon, String attributeName) {
        this.gridController = gridController;
        this.showAttributeValue = showAttributeValue;
        if (!showAttributeValue) {
            this.rend.setText(ClientSettings.getInstance().getResources().getResource(text));
        }
        this.rend.setHorizontalAlignment(alignement);
        this.enableInReadOnlyMode = enableInReadOnlyMode;
        this.attributeName = attributeName;
        if (icon != null) {
            this.rend.setIcon(icon);
        }
    }

    public final void finalize() {
        this.gridController = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.defaultFont == null) {
            this.defaultFont = this.rend.getFont();
        }
        if (this.showAttributeValue) {
            if (value != null && value instanceof byte[]) {
                this.rend.setIcon(new ImageIcon((byte[])value));
            } else if (value != null && value instanceof Icon) {
                this.rend.setIcon((Icon)value);
            } else if (value != null) {
                this.rend.setText(value.toString());
            } else {
                this.rend.setText("");
                this.rend.setIcon(null);
            }
        }
        if (hasFocus && table instanceof Grid) {
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getActiveCellBackgroundColor();
            }
            Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            this.rend.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
        } else if (isSelected && !hasFocus) {
            Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * table.getSelectionBackground().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * table.getSelectionBackground().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * table.getSelectionBackground().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getSelectionBackground();
            }
            this.rend.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
        } else {
            this.rend.setForeground(this.gridController.getForegroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            if (!(this.enableInReadOnlyMode || ((Grid)table).getMode() != 0 && ((Grid)table).isColorsInReadOnlyMode())) {
                this.rend.setBackground(this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            } else if (this.enableInReadOnlyMode || table.isCellEditable(row, column)) {
                this.rend.setBackground(this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            } else {
                this.rend.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
            }
        }
        Font f = this.gridController.getFont(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value, this.defaultFont);
        if (f != null) {
            this.rend.setFont(f);
        } else {
            this.rend.setFont(this.defaultFont);
        }
        if (table instanceof Grid) {
            this.rend.setToolTipText(this.gridController.getCellTooltip(row, ((Grid)table).getVOListTableModel().getColumnName(table.convertColumnIndexToModel(column))));
        }
        return this.rend;
    }
}

