/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.table.DefaultTableCellRenderer;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.util.client.ClientSettings;

public class CheckBoxTableCellRenderer
extends DefaultTableCellRenderer {
    private boolean allowNullValue;
    private String attributeName = null;
    private Font defaultFont = null;
    private boolean enableInReadOnlyMode = false;
    private GridController gridContainer = null;
    private Object negativeValue = null;
    private boolean paintBorder = false;
    private Object positiveValue = null;
    private CheckLabel rend;
    private Boolean selected = Boolean.FALSE;
    private Color selectionForeground = null;

    public CheckBoxTableCellRenderer(GridController gridContainer, int alignement, boolean enableInReadOnlyMode, boolean allowNullValue, String attributeName, Object positiveValue, Object negativeValue) {
        this.rend = new CheckLabel();
        this.gridContainer = gridContainer;
        this.rend.setOpaque(true);
        this.rend.setHorizontalAlignment(alignement);
        this.enableInReadOnlyMode = enableInReadOnlyMode;
        this.allowNullValue = allowNullValue;
        this.attributeName = attributeName;
        this.positiveValue = positiveValue;
        this.negativeValue = negativeValue;
    }

    public final void finalize() {
        this.gridContainer = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.defaultFont == null) {
            this.defaultFont = this.rend.getFont();
        }
        if (hasFocus && table instanceof Grid) {
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getActiveCellBackgroundColor();
            }
            Color backColor = this.gridContainer.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            this.rend.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2, 200));
            this.selectionForeground = table.getSelectionForeground();
            this.paintBorder = true;
        } else if (isSelected && !hasFocus) {
            Color backColor = this.gridContainer.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * table.getSelectionBackground().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * table.getSelectionBackground().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * table.getSelectionBackground().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getSelectionBackground();
            }
            this.rend.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            this.paintBorder = false;
        } else {
            if (!(this.enableInReadOnlyMode || ((Grid)table).getMode() != 0 && ((Grid)table).isColorsInReadOnlyMode())) {
                this.rend.setBackground(this.gridContainer.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            } else if (this.enableInReadOnlyMode || table.isCellEditable(row, column)) {
                this.rend.setBackground(ClientSettings.GRID_EDITABLE_CELL_BACKGROUND);
            } else {
                this.rend.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
            }
            this.paintBorder = false;
        }
        this.selected = value == null && this.allowNullValue ? null : (value == null && !this.allowNullValue ? Boolean.FALSE : (value.equals(this.positiveValue) ? Boolean.TRUE : Boolean.FALSE));
        this.rend.setPreferredSize(new Dimension(table.getColumnModel().getColumn(column).getWidth(), table.getHeight()));
        Font f = this.gridContainer.getFont(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value, this.defaultFont);
        if (f != null) {
            this.rend.setFont(f);
        } else {
            this.rend.setFont(this.defaultFont);
        }
        if (table instanceof Grid) {
            this.rend.setToolTipText(this.gridContainer.getCellTooltip(row, ((Grid)table).getVOListTableModel().getColumnName(table.convertColumnIndexToModel(column))));
        }
        return this.rend;
    }

    class CheckLabel
    extends JLabel {
        CheckLabel() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (CheckBoxTableCellRenderer.this.selectionForeground != null) {
                g.setColor(CheckBoxTableCellRenderer.this.selectionForeground);
            }
            if (CheckBoxTableCellRenderer.this.paintBorder && CheckBoxTableCellRenderer.this.selectionForeground != null) {
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            g.translate(this.getWidth() / 2 - 6, this.getHeight() / 2 - 5);
            Color col1 = Color.black;
            Color col2 = Color.darkGray;
            g.setColor(Color.white);
            g.fillRect(0, 0, 12, 12);
            BasicGraphicsUtils.drawLoweredBezel(g, 0, 0, 12, 12, Color.darkGray, Color.black, Color.white, Color.gray);
            if (CheckBoxTableCellRenderer.this.allowNullValue && CheckBoxTableCellRenderer.this.selected == null) {
                g.setColor(Color.lightGray);
                g.fillRect(1, 1, 10, 10);
            }
            if (Boolean.TRUE.equals(CheckBoxTableCellRenderer.this.selected)) {
                g.setColor(Color.black);
                g.drawLine(3, 5, 5, 7);
                g.drawLine(3, 6, 5, 8);
                g.drawLine(3, 7, 5, 9);
                g.drawLine(6, 6, 9, 3);
                g.drawLine(6, 7, 9, 4);
                g.drawLine(6, 8, 9, 5);
            }
        }
    }
}

