/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openswing.swing.items.client.ItemRenderer;
import org.openswing.swing.items.client.ItemsDataLocator;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.util.client.ClientSettings;

public class ComboVOTableCellRenderer
extends DefaultTableCellRenderer {
    private int allColumnPreferredWidth = 100;
    private boolean allColumnVisible = false;
    private String attributeName = null;
    private int bottomMargin = 0;
    private Column[] colProperties = new Column[0];
    private Font defaultFont = null;
    private String foreignKeyAttributeName;
    private Hashtable getters = new Hashtable();
    private GridController gridController = null;
    private List items = null;
    private ItemsDataLocator itemsDataLocator = null;
    private ValueObject itemsVO = null;
    private int leftMargin = 0;
    private ItemRenderer rend = new ItemRenderer();
    private int rightMargin = 0;
    private int topMargin = 0;

    public ComboVOTableCellRenderer(ItemsDataLocator itemsDataLocator, String attributeName, ValueObject itemsVO, Column[] colProperties, boolean allColumnVisible, int allColumnPreferredWidth, Hashtable getters, GridController gridController, int leftMargin, int rightMargin, int topMargin, int bottomMargin, ComponentOrientation orientation, String foreignKeyAttributeName) {
        Response res;
        this.itemsDataLocator = itemsDataLocator;
        this.attributeName = attributeName;
        this.itemsVO = itemsVO;
        this.colProperties = colProperties;
        this.allColumnVisible = allColumnVisible;
        this.allColumnPreferredWidth = allColumnPreferredWidth;
        this.getters = getters;
        this.gridController = gridController;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
        this.foreignKeyAttributeName = foreignKeyAttributeName;
        this.rend.setOpaque(true);
        this.setComponentOrientation(orientation);
        if (itemsDataLocator != null && itemsVO != null && !(res = itemsDataLocator.loadData(itemsVO.getClass())).isError()) {
            this.items = ((VOListResponse)res).getRows();
        }
        this.rend.init(getters, colProperties, leftMargin, rightMargin, topMargin, bottomMargin);
    }

    public final void finalize() {
        this.gridController = null;
        this.items = null;
        this.itemsDataLocator = null;
        this.colProperties = null;
        this.rend = null;
    }

    private String getFKAttributeName() {
        return this.foreignKeyAttributeName == null || this.foreignKeyAttributeName.equals("") ? this.attributeName : this.foreignKeyAttributeName;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int i;
        Object vo;
        block20: {
            if (this.defaultFont == null) {
                this.defaultFont = this.rend.getFont();
            }
            Object obj = null;
            vo = null;
            i = 0;
            try {
                if (value == null) break block20;
                i = 0;
                while (i < this.items.size()) {
                    obj = ((Method)this.getters.get(this.getFKAttributeName())).invoke(this.items.get(i), new Object[0]);
                    if (value != null && value.equals(obj)) {
                        vo = this.items.get(i);
                        break;
                    }
                    obj = null;
                    ++i;
                }
            }
            catch (Throwable ex) {
                obj = null;
            }
        }
        JPanel c = (JPanel)this.rend.getListCellRendererComponent(new JList(), (Object)vo, i, false, false);
        if (hasFocus && table instanceof Grid) {
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getActiveCellBackgroundColor();
            }
            Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            c.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            c.setBorder(BorderFactory.createLineBorder(table.getSelectionForeground()));
        } else if (isSelected && !hasFocus) {
            Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * table.getSelectionBackground().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * table.getSelectionBackground().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * table.getSelectionBackground().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getSelectionBackground();
            }
            c.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            c.setBorder(BorderFactory.createEmptyBorder());
        } else {
            c.setForeground(this.gridController.getForegroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            c.setBorder(BorderFactory.createEmptyBorder());
            if (((Grid)table).getMode() == 0 || !((Grid)table).isColorsInReadOnlyMode()) {
                c.setBackground(this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            } else if (table.isCellEditable(row, column)) {
                c.setBackground(ClientSettings.GRID_EDITABLE_CELL_BACKGROUND);
            } else {
                c.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
            }
        }
        Font f = this.gridController.getFont(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value, this.defaultFont);
        if (f != null) {
            c.setFont(f);
        } else {
            c.setFont(this.defaultFont);
        }
        if (table instanceof Grid) {
            c.setToolTipText(this.gridController.getCellTooltip(row, ((Grid)table).getVOListTableModel().getColumnName(table.convertColumnIndexToModel(column))));
        }
        c.setBorder(BorderFactory.createCompoundBorder(c.getBorder(), BorderFactory.createEmptyBorder(this.topMargin, this.leftMargin, this.bottomMargin, this.rightMargin)));
        return c;
    }

    public final void reloadItems() {
        Response res;
        if (this.itemsDataLocator != null && this.itemsVO != null && !(res = this.itemsDataLocator.loadData(this.itemsVO.getClass())).isError()) {
            this.items = ((VOListResponse)res).getRows();
            this.repaint();
        }
    }
}

