/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.IntegerColumnSettings;
import org.openswing.swing.table.renderers.client.NumericTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class CurrencyTableCellRenderer
extends NumericTableCellRenderer {
    private String currencySymbol = null;
    private boolean currencySymbolOnLeft;

    public CurrencyTableCellRenderer(int decimals, boolean grouping, boolean hideZeroDigits, boolean currencySymbolOnLeft, String currencySymbol, GridController gridController, IntegerColumnSettings dynamicSettings, int alignement, int leftMargin, int rightMargin, int topMargin, int bottomMargin, String attributeName) {
        super(decimals, grouping, hideZeroDigits, gridController, dynamicSettings, alignement, leftMargin, rightMargin, topMargin, bottomMargin, attributeName);
        this.currencySymbol = currencySymbol;
        this.currencySymbolOnLeft = currencySymbolOnLeft;
        this.setFormat(decimals, grouping);
    }

    public final void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    protected void setFormat(int decimals, boolean grouping) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(ClientSettings.getInstance().getResources().getGroupingSymbol());
        dfs.setDecimalSeparator(ClientSettings.getInstance().getResources().getDecimalSymbol());
        if (!grouping && decimals == 0) {
            this.format = this.currencySymbolOnLeft ? new DecimalFormat(this.currencySymbol + " " + "0") : new DecimalFormat("0 " + this.currencySymbol);
        } else if (grouping && decimals == 0) {
            this.format = this.currencySymbolOnLeft ? new DecimalFormat(this.currencySymbol + " " + "#,##0", dfs) : new DecimalFormat("#,##0 " + this.currencySymbol, dfs);
        } else if (grouping && decimals > 0) {
            String dec = "";
            int i = 0;
            while (i < decimals) {
                dec = dec + (this.hideZeroDigits ? "#" : "0");
                ++i;
            }
            this.format = this.currencySymbolOnLeft ? new DecimalFormat(this.currencySymbol + " " + "#,##0." + dec, dfs) : new DecimalFormat("#,##0." + dec + " " + this.currencySymbol, dfs);
        } else if (!grouping && decimals > 0) {
            String dec = "";
            int i = 0;
            while (i < decimals) {
                dec = dec + (this.hideZeroDigits ? "#" : "0");
                ++i;
            }
            this.format = this.currencySymbolOnLeft ? new DecimalFormat(this.currencySymbol + " " + "0." + dec, dfs) : new DecimalFormat("0." + dec + " " + this.currencySymbol, dfs);
        }
        this.format.setGroupingUsed(grouping);
    }
}

