/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.domains.java.DomainPair;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.util.client.ClientSettings;

public class DomainTableCellRenderer
extends DefaultTableCellRenderer {
    private String attributeName = null;
    private int bottomMargin = 0;
    private JPanel container;
    private Font defaultFont = null;
    private Domain domain = null;
    private GridController gridController = null;
    private int leftMargin = 0;
    private JLabel rend = new JLabel();
    private int rightMargin = 0;
    private int topMargin = 0;
    private boolean translateItemDescriptions;

    public DomainTableCellRenderer(Domain domain, boolean translateItemDescriptions, GridController gridController, int alignement, int leftMargin, int rightMargin, int topMargin, int bottomMargin, ComponentOrientation orientation, String attributeName) {
        this.container = new JPanel();
        this.domain = domain;
        this.translateItemDescriptions = translateItemDescriptions;
        this.gridController = gridController;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
        this.attributeName = attributeName;
        this.rend.setOpaque(true);
        this.rend.setHorizontalAlignment(alignement);
        if (orientation != null) {
            this.setComponentOrientation(orientation);
        }
    }

    public final void finalize() {
        this.gridController = null;
        this.rend = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DomainPair pair;
        if (this.defaultFont == null) {
            this.defaultFont = this.rend.getFont();
        }
        if ((pair = this.domain.getDomainPair(value)) == null) {
            this.rend.setText(null);
        } else if (this.translateItemDescriptions) {
            this.rend.setText(ClientSettings.getInstance().getResources().getResource(pair.getDescription()));
        } else {
            this.rend.setText(pair.getDescription());
        }
        if (hasFocus && table instanceof Grid) {
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getActiveCellBackgroundColor();
            }
            Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            this.rend.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            this.rend.setBorder(BorderFactory.createLineBorder(table.getSelectionForeground()));
        } else if (isSelected && !hasFocus) {
            Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * table.getSelectionBackground().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * table.getSelectionBackground().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * table.getSelectionBackground().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getSelectionBackground();
            }
            this.rend.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            this.rend.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.rend.setForeground(this.gridController.getForegroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            this.rend.setBorder(BorderFactory.createEmptyBorder());
            if (((Grid)table).getMode() == 0 || !((Grid)table).isColorsInReadOnlyMode()) {
                this.rend.setBackground(this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            } else if (table.isCellEditable(row, column)) {
                this.rend.setBackground(ClientSettings.GRID_EDITABLE_CELL_BACKGROUND);
            } else {
                this.rend.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
            }
        }
        Font f = this.gridController.getFont(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value, this.defaultFont);
        if (f != null) {
            this.rend.setFont(f);
        } else {
            this.rend.setFont(this.defaultFont);
        }
        if (table instanceof Grid) {
            this.rend.setToolTipText(this.gridController.getCellTooltip(row, ((Grid)table).getVOListTableModel().getColumnName(table.convertColumnIndexToModel(column))));
        }
        this.rend.setBorder(BorderFactory.createCompoundBorder(this.rend.getBorder(), BorderFactory.createEmptyBorder(this.topMargin, this.leftMargin, this.bottomMargin, this.rightMargin)));
        return this.rend;
    }

    public final void setDomain(Domain domain) {
        this.domain = domain;
    }
}

