/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.model.client.VOListAdapter;
import org.openswing.swing.table.model.client.VOListTableModel;
import org.openswing.swing.table.renderers.client.ExpandablePanel;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class ExpandableRenderer
extends DefaultTableCellRenderer {
    private int currentExpandedRow;
    private TableCellRenderer defaultCellRenderer = null;
    private MinusPanel expTreePanel;
    private int expandableColumn;
    private Grid grid = null;
    private Grids grids = null;
    private JPanel mainPanel = new JPanel();
    private Image minusImage = null;
    private VOListAdapter modelAdapter = null;
    private Image plusImage = null;
    private PlusPanel rendTreePanel;
    private int row = -1;
    private TreeLinesPanel treeLinesPanel = new TreeLinesPanel();

    public ExpandableRenderer(Grid grid, Grids grids, int expandableColumn, VOListAdapter modelAdapter) {
        this.rendTreePanel = new PlusPanel();
        this.expTreePanel = new MinusPanel();
        this.grid = grid;
        this.grids = grids;
        this.expandableColumn = expandableColumn;
        this.modelAdapter = modelAdapter;
        this.rendTreePanel.setOpaque(false);
        this.rendTreePanel.setMinimumSize(new Dimension(13, 13));
        this.treeLinesPanel.setSize(12, 12);
        this.treeLinesPanel.setMinimumSize(new Dimension(12, 12));
        this.treeLinesPanel.setMaximumSize(new Dimension(12, 12));
        grid.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                VOListTableModel model = (VOListTableModel)ExpandableRenderer.this.grid.getModel();
                Point p1 = e.getPoint();
                int width = 0;
                int i = 0;
                while (i < ExpandableRenderer.this.expandableColumn) {
                    width += ExpandableRenderer.this.grid.getColumnModel().getColumn(i).getWidth();
                    ++i;
                }
                ExpandableRenderer.this.row = ExpandableRenderer.this.grid.getSelectedRow();
                if (ExpandableRenderer.this.grid.isOverwriteRowWhenExpanding()) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && p1.x >= width && p1.x <= width + ExpandableRenderer.this.grid.getColumnModel().getColumn(ExpandableRenderer.this.expandableColumn).getWidth() && ExpandableRenderer.this.row != -1 && ExpandableRenderer.this.grid.getExpandableRowController().isRowExpandable(model, ExpandableRenderer.this.row)) {
                        if (ExpandableRenderer.this.grids.isRowExpanded(ExpandableRenderer.this.row)) {
                            ExpandableRenderer.this.collapseRow(ExpandableRenderer.this.row);
                        } else {
                            ExpandableRenderer.this.expandRow(ExpandableRenderer.this.row);
                        }
                        ExpandableRenderer.this.grid.repaint();
                    }
                } else if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && p1.x >= width && p1.x <= width + ExpandableRenderer.this.rendTreePanel.getWidth() && ExpandableRenderer.this.row != -1 && ExpandableRenderer.this.grid.getExpandableRowController().isRowExpandable((VOListTableModel)ExpandableRenderer.this.grid.getModel(), ExpandableRenderer.this.row)) {
                    if (ExpandableRenderer.this.grids.isRowExpanded(ExpandableRenderer.this.row)) {
                        ExpandableRenderer.this.collapseRow(ExpandableRenderer.this.row);
                    } else {
                        ExpandableRenderer.this.expandRow(ExpandableRenderer.this.row);
                    }
                    ExpandableRenderer.this.grid.repaint();
                }
            }
        });
    }

    private void collapseAllRowsExcept(int row) {
        int i = 0;
        while (i < this.grids.getVOListTableModel().getRowCount()) {
            if (i != row && this.grids.isRowExpanded(i)) {
                this.collapseRow(i);
            }
            ++i;
        }
    }

    public final void collapseRow(int row) {
        this.currentExpandedRow = -1;
        ExpandablePanel c = (ExpandablePanel)this.grids.getComponentInCache(row);
        if (c != null) {
            this.grid.remove(c);
        }
        this.grids.collapseRow(row);
        if (this.grid.getRowHeight(row) != this.grid.getRowHeight()) {
            this.grid.setRowHeight(row, this.grid.getRowHeight());
        }
        int[] cols = new int[this.grid.getColumnModel().getColumnCount() - this.expandableColumn];
        int i = 0;
        while (i < cols.length) {
            cols[i] = i + this.expandableColumn;
            ++i;
        }
        this.grid.removeMergedCells(new int[]{row}, cols);
        if (this.grid.getExpandableRowController().removeShowedComponent(this.grids.getVOListTableModel(), row, (JComponent)c.getNestedComponent())) {
            this.grids.removeComponentInCache(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Component expandRow(final int row) {
        Component component;
        block20: {
            ClientUtils.fireBusyEvent(true);
            if (this.grid.isSingleExpandableRow()) {
                this.collapseAllRowsExcept(row);
            }
            this.grids.expandRow(row);
            this.currentExpandedRow = row;
            ExpandablePanel expPanel = (ExpandablePanel)this.grids.getComponentInCache(row);
            Component c = null;
            c = expPanel == null ? this.grid.getExpandableRowController().getComponentToShow(this.grids.getVOListTableModel(), row) : expPanel.getNestedComponent();
            if (c == null) break block20;
            int width = 0;
            int i = this.expandableColumn;
            while (i < this.grid.getColumnModel().getColumnCount()) {
                width += this.grid.getColumnModel().getColumn(i).getWidth();
                ++i;
            }
            int height = this.grid.getRowHeight(row);
            Dimension dim = c.getSize();
            if (dim.width == 0 && dim.height == 0) {
                dim = c.getPreferredSize();
            }
            int delta = 0;
            if (!this.grid.isOverwriteRowWhenExpanding()) {
                delta = this.grid.getRowHeight(row);
            }
            dim.height += delta;
            if (dim.getHeight() > (double)height) {
                height = dim.height;
                if (this.grid.getRowHeight(row) != height) {
                    this.grid.setRowHeight(row, height);
                }
            }
            ((JComponent)c).setMaximumSize(new Dimension(width - 13, height - delta));
            ((JComponent)c).setSize(new Dimension(width - 13, height - delta));
            ((JComponent)c).setPreferredSize(new Dimension(width - 13, height - delta));
            int[] cols = new int[this.grid.getColumnModel().getColumnCount() - this.expandableColumn];
            int i2 = 0;
            while (i2 < cols.length) {
                cols[i2] = i2 + this.expandableColumn;
                ++i2;
            }
            this.grid.mergeCells(new int[]{row}, cols);
            if (!this.grid.isOverwriteRowWhenExpanding()) {
                JPanel nestedCompContainer = new JPanel();
                nestedCompContainer.setLayout(null);
                JPanel aux = new JPanel();
                aux.setLayout(null);
                Component comp = null;
                int w = 0;
                int i3 = this.expandableColumn;
                while (i3 < this.grid.getColumnModel().getColumnCount()) {
                    comp = this.modelAdapter.getCellRenderer(this.grid.convertColumnIndexToModel(i3)).getTableCellRendererComponent(this.grid, this.grid.getValueAt(row, i3), false, false, row, this.grid.convertColumnIndexToModel(i3));
                    if (i3 == this.expandableColumn) {
                        aux.add(this.expTreePanel);
                        this.expTreePanel.setBackground(comp.getBackground());
                        this.expTreePanel.setBounds(0, 0, 13, delta);
                    }
                    aux.add(comp);
                    comp.setBounds(w + (i3 == this.expandableColumn ? 12 : 0), 0, this.grid.getColumnModel().getColumn(i3 + this.expandableColumn).getWidth() - 1 - (i3 == this.expandableColumn ? 12 : 0), delta);
                    JSeparator sep = new JSeparator(1);
                    aux.add(sep);
                    sep.setBounds((w += this.grid.getColumnModel().getColumn(i3 + this.expandableColumn).getWidth()) - 1, 0, 1, delta);
                    aux.setBackground(comp.getBackground());
                    ++i3;
                }
                aux.setSize(w, delta);
                aux.setMinimumSize(new Dimension(w, delta));
                nestedCompContainer.setMinimumSize(new Dimension(width, height));
                nestedCompContainer.setSize(new Dimension(width, height));
                nestedCompContainer.setPreferredSize(new Dimension(width, height));
                this.treeLinesPanel.setBackground(this.expTreePanel.getBackground());
                nestedCompContainer.add(aux);
                aux.setBounds(0, 0, w, delta);
                nestedCompContainer.add(this.treeLinesPanel);
                this.treeLinesPanel.setBounds(1, delta, this.treeLinesPanel.getWidth(), this.treeLinesPanel.getHeight());
                nestedCompContainer.add(c);
                c.setBounds(this.treeLinesPanel.getWidth() + 1, delta, c.getWidth(), c.getHeight());
                nestedCompContainer.setFocusable(true);
                expPanel = new ExpandablePanel(this.grid, c, nestedCompContainer);
                nestedCompContainer.setBackground(comp.getBackground());
                expPanel.setBackground(comp.getBackground());
                this.grids.putComponentInCache(row, expPanel);
                this.grid.add(expPanel);
                int y = 0;
                int i4 = 0;
                while (i4 < row) {
                    y += this.grid.getRowHeight(i4);
                    ++i4;
                }
                int x = 0;
                int i5 = 0;
                while (i5 < this.expandableColumn) {
                    x += this.grid.getColumnModel().getColumn(i5).getWidth();
                    ++i5;
                }
                expPanel.setBounds(x, y, width, height);
            } else {
                expPanel = new ExpandablePanel(this.grid, c, c);
                this.grids.putComponentInCache(row, expPanel);
                this.grid.add(expPanel);
                int y = this.grid.getRowHeight();
                int i6 = 0;
                while (i6 < row) {
                    y += this.grid.getRowHeight(i6);
                    ++i6;
                }
                int x = 13;
                int i7 = 0;
                while (i7 < this.expandableColumn) {
                    x += this.grid.getColumnModel().getColumn(i7).getWidth();
                    ++i7;
                }
                expPanel.setBounds(x, y, width, height);
            }
            this.grids.setCurrentNestedComponent(row, expPanel);
            final ExpandablePanel aux = expPanel;
            SwingUtilities.invokeLater(new Runnable(){

                static /* synthetic */ int access$500(2 x0) {
                    return x0.row;
                }

                static /* synthetic */ ExpandableRenderer access$600(2 x0) {
                    return x0.ExpandableRenderer.this;
                }

                public void run() {
                    ExpandableRenderer.this.grid.repaint();
                    Component comp = ExpandableRenderer.this.grid.getExpandableRowController().getFocusableComponent((JComponent)aux.getNestedComponent());
                    if (comp != null) {
                        comp.requestFocus();
                        if (comp instanceof JComponent) {
                            AbstractAction exitAction = new AbstractAction(this, comp){
                                private final /* synthetic */ 2 this$1;
                                private final /* synthetic */ Component val$comp;
                                {
                                    this.this$1 = this$1;
                                    this.val$comp = val$comp;
                                }

                                public void actionPerformed(ActionEvent e) {
                                    ((JComponent)this.val$comp).getInputMap().remove(ClientSettings.COLLAPSE_CELL_KEY);
                                    ((JComponent)this.val$comp).getActionMap().remove("exitAction");
                                    2.access$600(this.this$1).collapseRow(2.access$500(this.this$1));
                                    ExpandableRenderer.access$000(2.access$600(this.this$1)).requestFocus();
                                }
                            };
                            ((JComponent)comp).getInputMap().put(ClientSettings.COLLAPSE_CELL_KEY, "exitAction");
                            ((JComponent)comp).getActionMap().put("exitAction", exitAction);
                        }
                    } else {
                        aux.requestFocus();
                    }
                }
            });
            ExpandablePanel expandablePanel = expPanel;
            Object var21_27 = null;
            ClientUtils.fireBusyEvent(false);
            return expandablePanel;
        }
        try {
            component = null;
            Object var21_28 = null;
        }
        catch (Throwable t) {
            Component component2;
            try {
                t.printStackTrace();
                component2 = null;
                Object var21_29 = null;
            }
            catch (Throwable throwable) {
                Object var21_30 = null;
                ClientUtils.fireBusyEvent(false);
                throw throwable;
            }
            ClientUtils.fireBusyEvent(false);
            return component2;
        }
        ClientUtils.fireBusyEvent(false);
        return component;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.row = row;
        if (!this.grid.getExpandableRowController().isRowExpandable((VOListTableModel)this.grid.getModel(), row)) {
            if (column == this.expandableColumn) {
                Component comp = this.defaultCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.rendTreePanel.setBackground(comp.getBackground());
                this.mainPanel.setBackground(comp.getBackground());
                this.mainPanel.removeAll();
                this.mainPanel.setLayout(new BorderLayout(2, 0));
                this.mainPanel.add(comp, "Center");
                if (!this.grid.isOverwriteRowWhenExpanding()) {
                    this.mainPanel.add((Component)this.rendTreePanel, "West");
                }
                this.mainPanel.revalidate();
                return this.mainPanel;
            }
            return this.defaultCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (column < this.expandableColumn) {
            return this.defaultCellRenderer.getTableCellRendererComponent(table, value, isSelected && !this.grids.isRowExpanded(row), !this.grids.isRowExpanded(row) && hasFocus, row, column);
        }
        if (!this.grids.isRowExpanded(row)) {
            if (column == this.expandableColumn) {
                this.mainPanel.removeAll();
                this.mainPanel.setLayout(new BorderLayout(2, 0));
                Component comp = this.defaultCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.mainPanel.add(comp, "Center");
                this.mainPanel.setBackground(comp.getBackground());
                this.rendTreePanel.setBackground(comp.getBackground());
                if (!this.grid.isOverwriteRowWhenExpanding()) {
                    this.mainPanel.add((Component)this.rendTreePanel, "West");
                }
                this.mainPanel.revalidate();
                return this.mainPanel;
            }
            return this.defaultCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        Component c = this.grids.getComponentInCache(row);
        if (c != null) {
            c.setFocusable(true);
            if (this.grid.isOverwriteRowWhenExpanding()) {
                return c;
            }
            this.mainPanel.removeAll();
            return this.mainPanel;
        }
        return this.defaultCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public final void refreshExpandableRenderer() {
        if (this.currentExpandedRow != -1) {
            int row = this.currentExpandedRow;
            this.collapseRow(row);
            this.expandRow(row);
        }
    }

    public void setDefaultCellRenderer(TableCellRenderer rend) {
        this.defaultCellRenderer = rend;
    }

    class MinusPanel
    extends JPanel {
        MinusPanel() {
        }

        public final void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!ExpandableRenderer.this.grid.isOverwriteRowWhenExpanding()) {
                if (ExpandableRenderer.this.minusImage == null) {
                    ExpandableRenderer.this.minusImage = ClientUtils.getImage("minus.gif");
                }
                g.setColor(new Color(128, 128, 128));
                g.drawLine(ExpandableRenderer.this.minusImage.getWidth(this) / 2, this.getHeight() / 2 + ExpandableRenderer.this.minusImage.getHeight(this) / 2 - 1, ExpandableRenderer.this.minusImage.getWidth(this) / 2, this.getHeight());
                g.drawImage(ExpandableRenderer.this.minusImage, 0, this.getHeight() / 2 - ExpandableRenderer.this.minusImage.getHeight(this) / 2, ExpandableRenderer.this.minusImage.getWidth(this), ExpandableRenderer.this.minusImage.getHeight(this), this);
            }
        }
    }

    class PlusPanel
    extends JPanel {
        PlusPanel() {
        }

        public final void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!ExpandableRenderer.this.grid.isOverwriteRowWhenExpanding() && ExpandableRenderer.this.row != -1 && ExpandableRenderer.this.grid.getExpandableRowController().isRowExpandable((VOListTableModel)ExpandableRenderer.this.grid.getModel(), ExpandableRenderer.this.row)) {
                if (ExpandableRenderer.this.plusImage == null) {
                    ExpandableRenderer.this.plusImage = ClientUtils.getImage("plus.gif");
                }
                g.drawImage(ExpandableRenderer.this.plusImage, 0, this.getHeight() / 2 - ExpandableRenderer.this.plusImage.getHeight(this) / 2, ExpandableRenderer.this.plusImage.getWidth(this), ExpandableRenderer.this.plusImage.getHeight(this), this);
            }
        }
    }

    class TreeLinesPanel
    extends JPanel {
        TreeLinesPanel() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(new Color(128, 128, 128));
            g.drawLine(this.getWidth() / 2 - 2, 0, this.getWidth() / 2 - 2, 10);
            g.drawLine(this.getWidth() / 2 - 2, 10, this.getWidth(), 10);
        }
    }

    class LinePanel
    extends JPanel {
        public LinePanel() {
            this.setMaximumSize(new Dimension(1, ExpandableRenderer.this.grid.getRowHeight()));
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(ExpandableRenderer.this.grid.getGridColor());
            g.drawLine(0, 0, 0, this.getHeight());
        }
    }
}

