/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class FileTableCellRenderer
extends DefaultTableCellRenderer {
    private String attributeName = null;
    private byte[] cellContent = null;
    private JButton download;
    private JLabel fileName;
    private String fileNameAttributeName = null;
    private GridController gridController = null;
    private JPanel rend = new JPanel();
    private JTable table = null;
    private JButton upload;

    public FileTableCellRenderer(GridController gridController, String attributeName, boolean showUploadButton, boolean showDownloadButton, String fileNameAttributeName) {
        this.fileName = new JLabel();
        this.upload = new JButton(ClientSettings.getInstance().getResources().getResource("upload file"));
        this.download = new JButton(ClientSettings.getInstance().getResources().getResource("download file"));
        this.gridController = gridController;
        this.attributeName = attributeName;
        this.fileNameAttributeName = fileNameAttributeName;
        this.rend.setLayout(new GridBagLayout());
        this.upload.setEnabled(false);
        if (fileNameAttributeName != null && !fileNameAttributeName.equals("")) {
            this.rend.add((Component)this.fileName, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (showUploadButton) {
            this.rend.add((Component)this.upload, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (showDownloadButton) {
            this.rend.add((Component)this.download, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.download.setOpaque(false);
        this.upload.setOpaque(false);
        this.fileName.setOpaque(false);
        this.rend.setFocusable(true);
        this.download.setPreferredSize(new Dimension(21, 20));
        this.download.setMinimumSize(new Dimension(100, 20));
        this.download.setMaximumSize(new Dimension(100, 20));
        this.upload.setPreferredSize(new Dimension(100, 20));
        this.upload.setMinimumSize(new Dimension(100, 20));
        this.upload.setMaximumSize(new Dimension(100, 20));
    }

    static /* synthetic */ byte[] access$302(FileTableCellRenderer x0, byte[] x1) {
        x0.cellContent = x1;
        return x1;
    }

    public final void finalize() {
        this.gridController = null;
        this.rend = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, final int column) {
        if (this.table == null) {
            this.table = table;
            table.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    int w = 0;
                    int i = 0;
                    while (i < column) {
                        w += FileTableCellRenderer.this.table.getColumnModel().getColumn(i).getWidth();
                        ++i;
                    }
                    int delta = e.getX() - w;
                    int downloadPosX = ((FileTableCellRenderer)FileTableCellRenderer.this).download.getLocation().x;
                    if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e) && delta > downloadPosX && delta < downloadPosX + FileTableCellRenderer.this.download.getWidth()) {
                        Object obj;
                        JFileChooser f = new JFileChooser();
                        f.setDialogTitle(ClientSettings.getInstance().getResources().getResource("download file"));
                        f.setDialogType(1);
                        f.setApproveButtonText(ClientSettings.getInstance().getResources().getResource("download file"));
                        int row = FileTableCellRenderer.this.table.rowAtPoint(e.getPoint());
                        if (FileTableCellRenderer.this.fileNameAttributeName != null && !FileTableCellRenderer.this.fileNameAttributeName.equals("") && (obj = ((Grid)FileTableCellRenderer.this.table).getGrids().getVOListTableModel().getField(row, FileTableCellRenderer.this.fileNameAttributeName)) != null) {
                            f.setSelectedFile(new File(obj.toString()));
                        }
                        int res = f.showSaveDialog(ClientUtils.getParentFrame(FileTableCellRenderer.this.table));
                        if (res == 0) {
                            try {
                                File file = f.getSelectedFile();
                                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                                FileTableCellRenderer.access$302(FileTableCellRenderer.this, (byte[])((Grid)FileTableCellRenderer.this.table).getGrids().getVOListTableModel().getField(row, FileTableCellRenderer.this.attributeName));
                                out.write(FileTableCellRenderer.this.cellContent);
                                out.close();
                            }
                            catch (Throwable ex) {
                                OptionPane.showMessageDialog(ClientUtils.getParentFrame(FileTableCellRenderer.this.table), ex.getMessage(), ClientSettings.getInstance().getResources().getResource("Error while saving"), 0);
                            }
                        }
                    }
                }
            });
        }
        this.cellContent = (byte[])value;
        this.download.setEnabled(this.cellContent != null);
        this.upload.setEnabled(((Grid)table).getMode() != 0);
        if (table instanceof Grid && this.fileNameAttributeName != null && !this.fileNameAttributeName.equals("")) {
            Object obj = ((Grid)table).getGrids().getVOListTableModel().getField(row, this.fileNameAttributeName);
            this.fileName.setText(obj == null ? "" : obj.toString());
        }
        if (hasFocus && table instanceof Grid) {
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getActiveCellBackgroundColor();
            }
            Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            this.rend.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            this.download.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            this.upload.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            this.rend.setBorder(BorderFactory.createLineBorder(table.getSelectionForeground()));
        } else if (isSelected && !hasFocus) {
            Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * table.getSelectionBackground().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * table.getSelectionBackground().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * table.getSelectionBackground().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getSelectionBackground();
            }
            this.rend.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            this.rend.setBorder(BorderFactory.createRaisedBevelBorder());
        } else {
            this.rend.setForeground(this.gridController.getForegroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            this.rend.setBorder(BorderFactory.createRaisedBevelBorder());
            if (((Grid)table).getMode() == 0 || !((Grid)table).isColorsInReadOnlyMode()) {
                this.rend.setBackground(this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            } else if (table.isCellEditable(row, column)) {
                this.rend.setBackground(ClientSettings.GRID_EDITABLE_CELL_BACKGROUND);
            } else {
                this.rend.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
            }
        }
        if (table instanceof Grid) {
            this.rend.setToolTipText(this.gridController.getCellTooltip(row, ((Grid)table).getVOListTableModel().getColumnName(table.convertColumnIndexToModel(column))));
        }
        return this.rend;
    }
}

