/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.CheckBoxControl;
import org.openswing.swing.client.CurrencyControl;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.ImageControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.client.NumericControl;
import org.openswing.swing.client.TextAreaControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.TypeController;
import org.openswing.swing.util.client.ClientSettings;

public class MultipleTypeTableCellRenderer
extends DefaultTableCellRenderer {
    private String attributeName;
    private int bottomMargin = 0;
    private JPanel container;
    private Font defaultFont = null;
    private GridControl grid;
    private GridController gridController = null;
    private Hashtable inputControls = new Hashtable();
    private JLabel l;
    private int leftMargin = 0;
    private JPanel p = new JPanel();
    private int rightMargin = 0;
    private int row = -1;
    private int topMargin = 0;
    private TypeController typeController = null;

    public MultipleTypeTableCellRenderer(GridController gridController, TypeController typeController, int alignement, int leftMargin, int rightMargin, int topMargin, int bottomMargin, String attributeName, GridControl grid) {
        this.l = new JLabel();
        this.container = new JPanel();
        this.gridController = gridController;
        this.typeController = typeController;
        this.setHorizontalAlignment(alignement);
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
        this.attributeName = attributeName;
        this.grid = grid;
        this.p.setLayout(new GridBagLayout());
    }

    public final void finalize() {
        this.gridController = null;
        this.grid = null;
        this.typeController = null;
        this.inputControls.clear();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            Color selColor;
            Color backColor;
            this.row = row;
            InputControl ic = this.prepareRenderer();
            ic.setValue(value);
            JComponent c = null;
            c = ic instanceof BaseInputControl ? ((BaseInputControl)ic).getBindingComponent() : (JComponent)((Object)ic);
            if (c instanceof JComboBox) {
                this.l.setText(((JComboBox)c).getSelectedItem().toString());
                this.p.removeAll();
                this.p.add((Component)this.l, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                c = this.p;
            }
            if (this.defaultFont == null) {
                this.defaultFont = table.getFont();
            }
            if (isSelected && !hasFocus) {
                c.setForeground(table.getSelectionForeground());
                backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
                selColor = table.getSelectionBackground();
                c.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            } else {
                c.setBackground(table.getBackground());
                c.setForeground(table.getForeground());
            }
            if (hasFocus && table instanceof Grid) {
                Color selColor2 = null;
                try {
                    selColor2 = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
                }
                catch (Exception ex1) {
                    selColor2 = ((Grid)table).getActiveCellBackgroundColor();
                }
                Color backColor2 = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
                c.setBackground(new Color((backColor2.getRed() + selColor2.getRed()) / 2, (backColor2.getGreen() + selColor2.getGreen()) / 2, (backColor2.getBlue() + selColor2.getBlue()) / 2, 200));
                c.setBorder(BorderFactory.createLineBorder(table.getSelectionForeground()));
            } else if (isSelected && !hasFocus) {
                c.setForeground(table.getSelectionForeground());
                backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
                selColor = null;
                try {
                    selColor = new Color(Math.min(255, 2 * table.getSelectionBackground().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * table.getSelectionBackground().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * table.getSelectionBackground().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
                }
                catch (Exception ex1) {
                    selColor = ((Grid)table).getSelectionBackground();
                }
                c.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
                c.setBorder(BorderFactory.createEmptyBorder());
            } else {
                c.setForeground(this.gridController.getForegroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
                c.setBorder(BorderFactory.createEmptyBorder());
                if (((Grid)table).getMode() == 0 || !((Grid)table).isColorsInReadOnlyMode()) {
                    c.setBackground(this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
                } else if (table.isCellEditable(row, column)) {
                    c.setBackground(ClientSettings.GRID_EDITABLE_CELL_BACKGROUND);
                } else {
                    c.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
                }
            }
            Font f = this.gridController.getFont(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value, this.defaultFont);
            if (f != null) {
                c.setFont(f);
            } else {
                c.setFont(this.defaultFont);
            }
            c.setBorder(BorderFactory.createCompoundBorder(c.getBorder(), BorderFactory.createEmptyBorder(this.topMargin, this.leftMargin, this.bottomMargin, this.rightMargin)));
            return c;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new JLabel();
        }
    }

    private InputControl prepareRenderer() {
        InputControl ic = this.typeController.getAdditionalProperties(this.row, this.attributeName, this.grid);
        if (ic != null) {
            return ic;
        }
        int type = this.typeController.getCellType(this.row, this.attributeName, this.grid);
        ic = (InputControl)this.inputControls.get(new Integer(type));
        if (ic == null) {
            switch (type) {
                case 0: {
                    ic = new TextControl();
                    break;
                }
                case 1: {
                    ic = new DateControl();
                    break;
                }
                case 2: {
                    ic = new DateControl();
                    ((DateControl)ic).setDateType(2);
                    break;
                }
                case 3: {
                    ic = new DateControl();
                    ((DateControl)ic).setDateType(3);
                    break;
                }
                case 4: {
                    ic = new NumericControl();
                    break;
                }
                case 5: {
                    ic = new NumericControl();
                    ((NumericControl)ic).setDecimals(5);
                    break;
                }
                case 6: {
                    ic = new CheckBoxControl();
                    break;
                }
                case 9: {
                    ic = new NumericControl();
                    ((NumericControl)ic).setMaxValue(100.0);
                    break;
                }
                case 10: {
                    ic = new CurrencyControl();
                    break;
                }
                case 12: {
                    ic = new ImageControl();
                    break;
                }
                case 14: {
                    ic = new TextAreaControl();
                    break;
                }
                default: {
                    ic = new TextControl();
                }
            }
            this.inputControls.put(new Integer(type), ic);
        }
        return ic;
    }
}

