/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.CurrencyColumnSettings;
import org.openswing.swing.table.columns.client.DecimalColumnSettings;
import org.openswing.swing.table.columns.client.IntegerColumnSettings;
import org.openswing.swing.table.renderers.client.CurrencyTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class NumericTableCellRenderer
implements TableCellRenderer {
    public static final String VALUE_UNKNOWN = "???";
    private String attributeName = null;
    protected int bottomMargin = 0;
    private JTextField c = new JTextField();
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    private int decimals;
    private Font defaultFont = null;
    private IntegerColumnSettings dynamicSettings = null;
    protected DecimalFormat format = null;
    private Grid grid = null;
    private GridController gridController = null;
    private boolean grouping;
    protected boolean hideZeroDigits = false;
    protected int leftMargin = 0;
    protected int rightMargin = 0;
    private int row = -1;
    protected int topMargin = 0;

    public NumericTableCellRenderer(int decimals, boolean grouping, boolean hideZeroDigits, GridController gridController, IntegerColumnSettings dynamicSettings, int alignement, int leftMargin, int rightMargin, int topMargin, int bottomMargin, String attributeName) {
        this.decimals = decimals;
        this.grouping = false;
        this.gridController = gridController;
        this.dynamicSettings = dynamicSettings;
        this.attributeName = attributeName;
        this.hideZeroDigits = hideZeroDigits;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
        this.c.setHorizontalAlignment(alignement);
        this.setFormat(decimals, grouping);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final void finalize() {
        this.gridController = null;
        this.grid = null;
        this.dynamicSettings = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color selColor;
        Color backColor;
        this.row = row;
        this.grid = (Grid)table;
        this.setValue(value);
        if (this.defaultFont == null) {
            this.defaultFont = this.c.getFont();
        }
        if (isSelected && !hasFocus) {
            this.c.setForeground(table.getSelectionForeground());
            backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            selColor = table.getSelectionBackground();
            this.c.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
        } else {
            this.c.setBackground(table.getBackground());
            this.c.setForeground(table.getForeground());
        }
        if (hasFocus && table instanceof Grid) {
            Color selColor2 = null;
            try {
                selColor2 = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor2 = ((Grid)table).getActiveCellBackgroundColor();
            }
            Color backColor2 = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            this.c.setBackground(new Color((backColor2.getRed() + selColor2.getRed()) / 2, (backColor2.getGreen() + selColor2.getGreen()) / 2, (backColor2.getBlue() + selColor2.getBlue()) / 2, 200));
            this.c.setBorder(BorderFactory.createLineBorder(table.getSelectionForeground()));
        } else if (isSelected && !hasFocus) {
            this.c.setForeground(table.getSelectionForeground());
            backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * table.getSelectionBackground().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * table.getSelectionBackground().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * table.getSelectionBackground().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getSelectionBackground();
            }
            this.c.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            this.c.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.c.setForeground(this.gridController.getForegroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            this.c.setBorder(BorderFactory.createEmptyBorder());
            if (((Grid)table).getMode() == 0 || !((Grid)table).isColorsInReadOnlyMode()) {
                this.c.setBackground(this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            } else if (table.isCellEditable(row, column)) {
                this.c.setBackground(ClientSettings.GRID_EDITABLE_CELL_BACKGROUND);
            } else {
                this.c.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
            }
        }
        Font f = this.gridController.getFont(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value, this.defaultFont);
        if (f != null) {
            this.c.setFont(f);
        } else {
            this.c.setFont(this.defaultFont);
        }
        if (table instanceof Grid) {
            this.c.setToolTipText(this.gridController.getCellTooltip(row, ((Grid)table).getVOListTableModel().getColumnName(table.convertColumnIndexToModel(column))));
        }
        this.c.setBorder(BorderFactory.createCompoundBorder(this.c.getBorder(), BorderFactory.createEmptyBorder(this.topMargin, this.leftMargin, this.bottomMargin, this.rightMargin)));
        this.c.setMinimumSize(new Dimension(this.grid.getColumnModel().getColumn(column).getWidth(), this.grid.getRowHeight(row)));
        this.c.setPreferredSize(new Dimension(this.grid.getColumnModel().getColumn(column).getWidth(), this.grid.getRowHeight(row)));
        this.c.setSize(this.grid.getColumnModel().getColumn(column).getWidth(), this.grid.getRowHeight(row));
        return this.c;
    }

    protected void setFormat(int decimals, boolean grouping) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(ClientSettings.getInstance().getResources().getGroupingSymbol());
        dfs.setDecimalSeparator(ClientSettings.getInstance().getResources().getDecimalSymbol());
        if (!grouping && decimals == 0) {
            this.format = new DecimalFormat("#");
        } else if (grouping && decimals == 0) {
            this.format = new DecimalFormat("#,###", dfs);
        } else if (grouping && decimals > 0) {
            String dec = "";
            int i = 0;
            while (i < decimals) {
                dec = dec + (this.hideZeroDigits ? "#" : "0");
                ++i;
            }
            this.format = new DecimalFormat("#,##0." + dec, dfs);
        } else if (!grouping && decimals > 0) {
            String dec = "";
            int i = 0;
            while (i < decimals) {
                dec = dec + (this.hideZeroDigits ? "#" : "0");
                ++i;
            }
            this.format = new DecimalFormat("0." + dec, dfs);
        }
        this.format.setGroupingUsed(grouping);
    }

    protected void setValue(Object value) {
        double val = 0.0;
        String s = VALUE_UNKNOWN;
        if (value == null) {
            this.c.setText(null);
            return;
        }
        if (value.getClass() == (class$java$lang$Double == null ? (class$java$lang$Double = NumericTableCellRenderer.class$("java.lang.Double")) : class$java$lang$Double) || value.getClass() == Double.TYPE) {
            val = (Double)value;
        } else if (value.getClass() == (class$java$lang$Float == null ? (class$java$lang$Float = NumericTableCellRenderer.class$("java.lang.Float")) : class$java$lang$Float) || value.getClass() == Float.TYPE) {
            val = ((Float)value).doubleValue();
        } else if (value.getClass() == (class$java$lang$Short == null ? (class$java$lang$Short = NumericTableCellRenderer.class$("java.lang.Short")) : class$java$lang$Short) || value.getClass() == Short.TYPE) {
            val = ((Short)value).doubleValue();
        } else if (value.getClass() == (class$java$lang$Long == null ? (class$java$lang$Long = NumericTableCellRenderer.class$("java.lang.Long")) : class$java$lang$Long) || value.getClass() == Long.TYPE) {
            val = ((Long)value).longValue();
        } else if (value.getClass() == (class$java$lang$Integer == null ? (class$java$lang$Integer = NumericTableCellRenderer.class$("java.lang.Integer")) : class$java$lang$Integer) || value.getClass() == Integer.TYPE) {
            val = ((Integer)value).doubleValue();
        } else if (value.getClass() == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumericTableCellRenderer.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            val = ((BigDecimal)value).doubleValue();
        } else {
            this.c.setText(VALUE_UNKNOWN);
            return;
        }
        if (this.row != -1 && this.dynamicSettings != null) {
            if (this instanceof CurrencyTableCellRenderer && this.dynamicSettings instanceof CurrencyColumnSettings) {
                ((CurrencyTableCellRenderer)this).setCurrencySymbol(((CurrencyColumnSettings)this.dynamicSettings).getCurrencySymbol(this.row));
            }
            if (this.dynamicSettings instanceof DecimalColumnSettings) {
                this.setFormat(((DecimalColumnSettings)this.dynamicSettings).getDecimals(this.row), this.dynamicSettings.isGrouping(this.row));
            } else {
                this.setFormat(0, this.dynamicSettings.isGrouping(this.row));
            }
        }
        s = this.format.format(val);
        this.c.setText(s);
    }
}

