/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openswing.swing.miscellaneous.client.ProgressBar;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.util.client.ClientSettings;

public class ProgressBarTableCellRenderer
extends DefaultTableCellRenderer {
    private String attributeName = null;
    private ArrayList coloredBands;
    private Color currentColor;
    private GridController gridContainer = null;
    private double maxValue;
    private double minValue;
    private boolean showAllBands;

    public ProgressBarTableCellRenderer(GridController gridContainer, ArrayList coloredBands, double minValue, double maxValue, boolean showAllBands, Color currentColor, String attributeName) {
        this.gridContainer = gridContainer;
        this.coloredBands = coloredBands;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.showAllBands = showAllBands;
        this.currentColor = currentColor;
        this.attributeName = attributeName;
    }

    public final void finalize() {
        this.gridContainer = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ProgressBar rend = new ProgressBar();
        rend.setColor(this.currentColor);
        rend.setShowAllBands(this.showAllBands);
        rend.setMinValue(this.minValue);
        rend.setMaxValue(this.maxValue);
        Object[] band = null;
        int i = 0;
        while (i < this.coloredBands.size()) {
            band = (Object[])this.coloredBands.get(i);
            rend.addColoredBand((Double)band[0], (Double)band[1], (Color)band[2]);
            ++i;
        }
        if (value != null && value instanceof Number) {
            rend.setValue(((Number)value).doubleValue());
        }
        rend.repaint();
        if (hasFocus && table instanceof Grid) {
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getActiveCellBackgroundColor();
            }
            Color backColor = this.gridContainer.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            rend.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2, 200));
        } else if (isSelected && !hasFocus) {
            Color backColor = this.gridContainer.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * table.getSelectionBackground().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * table.getSelectionBackground().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * table.getSelectionBackground().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getSelectionBackground();
            }
            rend.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
        } else if (((Grid)table).getMode() == 0 || !((Grid)table).isColorsInReadOnlyMode()) {
            rend.setBackground(this.gridContainer.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
        } else if (table.isCellEditable(row, column)) {
            rend.setBackground(ClientSettings.GRID_EDITABLE_CELL_BACKGROUND);
        } else {
            rend.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
        }
        rend.setPreferredSize(new Dimension(table.getColumnModel().getColumn(column).getWidth(), table.getHeight()));
        if (table instanceof Grid) {
            rend.setToolTipText(this.gridContainer.getCellTooltip(row, ((Grid)table).getVOListTableModel().getColumnName(table.convertColumnIndexToModel(column))));
        }
        return rend;
    }
}

