/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.tree.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.text.Format;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.tree.client.AbstractCellEditor;
import org.openswing.swing.tree.client.TreePanel;
import org.openswing.swing.tree.client.TreeTableModel;
import org.openswing.swing.tree.client.TreeTableModelAdapter;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class TreeGrid
extends JTable {
    private String attributeName;
    static /* synthetic */ Class class$org$openswing$swing$tree$client$TreeTableModel;
    private Hashtable gridColumnAlignments = new Hashtable();
    private ArrayList gridColumns = new ArrayList();
    protected TreeTableCellRenderer tree;
    private TreeGridNodeRenderer treeRenderer;

    public TreeGrid(TreeTableModel treeTableModel, String attributeName, ArrayList gridColumns, ArrayList gridColumnSizes, Hashtable gridColumnAlignments, String folderIconName, String leavesImageName, Format formatter, boolean rootVisible) {
        this.attributeName = attributeName;
        this.gridColumns = gridColumns;
        this.gridColumnAlignments = gridColumnAlignments;
        this.treeRenderer = new TreeGridNodeRenderer(folderIconName, leavesImageName, formatter);
        this.tree = new TreeTableCellRenderer(treeTableModel);
        this.tree.setRootVisible(rootVisible);
        this.tree.setCellRenderer(this.treeRenderer);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(class$org$openswing$swing$tree$client$TreeTableModel == null ? (class$org$openswing$swing$tree$client$TreeTableModel = TreeGrid.class$("org.openswing.swing.tree.client.TreeTableModel")) : class$org$openswing$swing$tree$client$TreeTableModel, this.tree);
        this.setDefaultEditor(class$org$openswing$swing$tree$client$TreeTableModel == null ? (class$org$openswing$swing$tree$client$TreeTableModel = TreeGrid.class$("org.openswing.swing.tree.client.TreeTableModel")) : class$org$openswing$swing$tree$client$TreeTableModel, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
        int i = 0;
        while (i < gridColumnSizes.size()) {
            this.getColumnModel().getColumn(i).setPreferredWidth((Integer)gridColumnSizes.get(i));
            if (gridColumnAlignments.containsKey(gridColumns.get(i)) && !gridColumns.get(i).equals(attributeName)) {
                DefaultTableCellRenderer rend = new DefaultTableCellRenderer();
                rend.setHorizontalAlignment((Integer)gridColumnAlignments.get(gridColumns.get(i)));
                this.getColumnModel().getColumn(i).setCellRenderer(rend);
            }
            ++i;
        }
        JTableHeader th = this.getTableHeader();
        th.setPreferredSize(new Dimension(th.getPreferredSize().width, ClientSettings.HEADER_HEIGHT));
        this.setRowHeight(ClientSettings.CELL_HEIGHT);
        this.setBackground(ClientSettings.GRID_CELL_BACKGROUND);
        this.setForeground(ClientSettings.GRID_CELL_FOREGROUND);
        this.setSelectionForeground(ClientSettings.GRID_SELECTION_FOREGROUND);
        this.setSelectionBackground(ClientSettings.GRID_SELECTION_BACKGROUND);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == (class$org$openswing$swing$tree$client$TreeTableModel == null ? (class$org$openswing$swing$tree$client$TreeTableModel = TreeGrid.class$("org.openswing.swing.tree.client.TreeTableModel")) : class$org$openswing$swing$tree$client$TreeTableModel) ? -1 : this.editingRow;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                    Object var2_1 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        int counter = min;
                        while (counter <= max) {
                            TreePath selPath;
                            if (this.listSelectionModel.isSelectedIndex(counter) && (selPath = TreeGrid.this.tree.getPathForRow(counter)) != null) {
                                this.addSelectionPath(selPath);
                            }
                            ++counter;
                        }
                    }
                    Object var6_5 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
                {
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return TreeGrid.this.tree;
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                int counter = TreeGrid.this.getColumnCount() - 1;
                while (counter >= 0) {
                    if (TreeGrid.this.getColumnClass(counter) == (class$org$openswing$swing$tree$client$TreeTableModel == null ? TreeGrid.class$("org.openswing.swing.tree.client.TreeTableModel") : class$org$openswing$swing$tree$client$TreeTableModel)) {
                        MouseEvent me = (MouseEvent)e;
                        MouseEvent newME = new MouseEvent(TreeGrid.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - TreeGrid.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                        TreeGrid.this.tree.dispatchEvent(newME);
                        break;
                    }
                    --counter;
                }
            }
            return false;
        }
    }

    public class TreeGridNodeRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon folderIcon = null;
        private Format formatter;
        ImageIcon leafIcon = null;
        TreePanel treePanel;

        public TreeGridNodeRenderer(String folderIconName, String leavesImageName, Format formatter) {
            try {
                this.treePanel = this.treePanel;
                this.formatter = formatter;
                this.folderIcon = new ImageIcon(ClientUtils.getImage(folderIconName));
                this.leafIcon = new ImageIcon(ClientUtils.getImage(leavesImageName));
                this.setOpaque(false);
                this.setBackgroundNonSelectionColor(new Color(0, 0, 0, 0));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TreeGridNodeRenderer l;
            block8: {
                try {
                    super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    if (leaf) {
                        this.setIcon(this.leafIcon);
                    } else {
                        this.setIcon(this.folderIcon);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                l = this;
                try {
                    Method getter;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    ValueObject vo = (ValueObject)node.getUserObject();
                    if (vo == null || (value = (getter = vo.getClass().getMethod("get" + TreeGrid.this.attributeName.substring(0, 1).toUpperCase() + TreeGrid.this.attributeName.substring(1), new Class[0])).invoke((Object)vo, new Object[0])) == null) break block8;
                    if (this.formatter != null) {
                        value = this.formatter.format(value);
                    }
                    l.setText(value.toString());
                    if (TreeGrid.this.gridColumnAlignments.get(TreeGrid.this.attributeName) != null) {
                        this.setHorizontalAlignment((Integer)TreeGrid.this.gridColumnAlignments.get(TreeGrid.this.attributeName));
                    }
                }
                catch (Throwable ex1) {
                    ex1.printStackTrace();
                }
            }
            return l;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }

        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, TreeGrid.this.getHeight());
        }

        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (TreeGrid.this != null && TreeGrid.this.getRowHeight() != rowHeight) {
                    TreeGrid.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }
    }
}

