/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.tree.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.tree.client.TreeNodeRendererListener;
import org.openswing.swing.tree.client.TreePanel;
import org.openswing.swing.util.client.ClientUtils;

public class TreeNodeRenderer
extends DefaultTreeCellRenderer {
    private CheckBoxLabel checkBox = new CheckBoxLabel();
    private ImageIcon folderIcon = null;
    private String iconAttributeName;
    private ImageIcon leafIcon = null;
    private JPanel panel = new JPanel();
    private String tooltipAttributeName;
    private TreePanel treePanel;

    public TreeNodeRenderer(TreePanel treePanel, String folderIconName, String leavesImageName, String iconAttributeName, String tooltipAttributeName) {
        try {
            this.treePanel = treePanel;
            this.iconAttributeName = iconAttributeName;
            this.tooltipAttributeName = tooltipAttributeName;
            this.folderIcon = new ImageIcon(ClientUtils.getImage(folderIconName));
            this.leafIcon = new ImageIcon(ClientUtils.getImage(leavesImageName));
            this.panel.setOpaque(false);
            this.setOpaque(false);
            this.checkBox.setOpaque(false);
            this.panel.setLayout(new BorderLayout(0, 0));
            this.panel.add((Component)this, "Center");
            if (treePanel.isShowCheckBoxes()) {
                this.checkBox.setSize(14, 14);
                this.checkBox.setPreferredSize(new Dimension(14, 14));
                this.panel.add((Component)this.checkBox, "Before");
                KeyListener kl = null;
                ArrayList<EventListener> toRemove = new ArrayList<EventListener>();
                int i = 0;
                while (i < treePanel.getTree().getKeyListeners().length) {
                    kl = treePanel.getTree().getKeyListeners()[i];
                    if (kl instanceof TreeNodeRendererListener) {
                        toRemove.add(kl);
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < toRemove.size()) {
                    treePanel.getTree().removeKeyListener((KeyListener)toRemove.get(i2));
                    ++i2;
                }
                MouseListener ml = null;
                toRemove.clear();
                int i3 = 0;
                while (i3 < treePanel.getTree().getMouseListeners().length) {
                    ml = treePanel.getTree().getMouseListeners()[i3];
                    if (ml instanceof TreeNodeRendererListener) {
                        toRemove.add(ml);
                    }
                    ++i3;
                }
                int i4 = 0;
                while (i4 < toRemove.size()) {
                    treePanel.getTree().removeMouseListener((MouseListener)toRemove.get(i4));
                    ++i4;
                }
                TreeNodeRendererListener l = new TreeNodeRendererListener(treePanel);
                treePanel.getTree().addKeyListener(l);
                treePanel.getTree().addMouseListener(l);
            }
            this.setBackgroundNonSelectionColor(new Color(0, 0, 0, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        block32: {
            try {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                this.checkBox.setEnabled(this.treePanel.isEnabled());
                if (this.iconAttributeName == null) {
                    if (leaf) {
                        this.setIcon(this.leafIcon);
                    } else {
                        this.setIcon(this.folderIcon);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            TreeNodeRenderer l = this;
            if (value != null && value.toString() != null) {
                FontMetrics fm = l.getFontMetrics(((Component)l).getFont());
                int w = 0;
                try {
                    w = fm.stringWidth(value.toString());
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                this.setBounds(0, 0, w, l.getHeight());
            }
            DefaultMutableTreeNode node = null;
            ValueObject vo = null;
            try {
                node = (DefaultMutableTreeNode)value;
                if (this.treePanel.isShowCheckBoxes()) {
                    this.checkBox.setSelected(this.treePanel.getCheckedNodes().contains(node));
                    if (leaf && !this.treePanel.isShowCheckBoxesOnLeaves()) {
                        this.checkBox.setVisible(false);
                    } else {
                        this.checkBox.setVisible(true);
                        this.checkBox.setGray(this.isGrayCheckBox(node));
                    }
                }
            }
            catch (ClassCastException ex1) {
                Logger.error(this.getClass().getName(), "getTreeCellRendererComponent", "Expected a node of type DefaultMutableTreeNode or some subclass", null);
            }
            try {
                vo = (ValueObject)node.getUserObject();
            }
            catch (ClassCastException ex1) {
                Logger.error(this.getClass().getName(), "getTreeCellRendererComponent", "ValueObject expected inside the node of type DefaultMutableTreeNode", null);
            }
            try {
                Method getter;
                if (vo == null) break block32;
                String attributeName = this.treePanel.getTreeDataLocator().getNodeNameAttribute();
                if (attributeName != null) {
                    getter = vo.getClass().getMethod("get" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), new Class[0]);
                    value = getter.invoke((Object)vo, new Object[0]);
                    if (value != null) {
                        l.setText(value.toString());
                    } else {
                        l.setText("");
                    }
                }
                if (this.iconAttributeName != null) {
                    getter = vo.getClass().getMethod("get" + this.iconAttributeName.substring(0, 1).toUpperCase() + this.iconAttributeName.substring(1), new Class[0]);
                    value = getter.invoke((Object)vo, new Object[0]);
                    if (value != null) {
                        if (value instanceof byte[]) {
                            this.setIcon(new ImageIcon((byte[])value));
                        } else if (value instanceof String) {
                            this.setIcon(new ImageIcon(ClientUtils.getImage(value.toString())));
                        }
                    } else if (leaf) {
                        this.setIcon(this.leafIcon);
                    } else {
                        this.setIcon(this.folderIcon);
                    }
                }
                if (this.tooltipAttributeName != null) {
                    getter = vo.getClass().getMethod("get" + this.tooltipAttributeName.substring(0, 1).toUpperCase() + this.tooltipAttributeName.substring(1), new Class[0]);
                    value = getter.invoke((Object)vo, new Object[0]);
                    if (value != null && value instanceof String) {
                        l.setToolTipText(value.toString());
                        this.panel.setToolTipText(value.toString());
                    } else if (value == null) {
                        l.setToolTipText("");
                        this.panel.setToolTipText("");
                    }
                }
            }
            catch (Throwable ex1) {
                Logger.error(this.getClass().getName(), "getTreeCellRendererComponent", "ValueObject expected inside the node of type DefaultMutableTreeNode", ex1);
            }
        }
        return this.panel;
    }

    private boolean isGrayCheckBox(TreeNode node) {
        boolean gray = false;
        if (this.treePanel.getCheckedNodes().contains(node)) {
            int i = 0;
            while (i < node.getChildCount()) {
                if (!this.treePanel.getCheckedNodes().contains(node.getChildAt(i)) && this.treePanel.isShowCheckBoxes() || !this.treePanel.getCheckedNodes().contains(node.getChildAt(i)) && !node.getChildAt(i).isLeaf() && !this.treePanel.isShowCheckBoxes()) {
                    return true;
                }
                if (!node.getChildAt(i).isLeaf() || this.treePanel.isShowCheckBoxes()) {
                    gray = this.isGrayCheckBox(node.getChildAt(i));
                }
                if (gray) {
                    return true;
                }
                ++i;
            }
        }
        return gray;
    }

    class CheckBoxLabel
    extends JLabel {
        private boolean gray;
        private boolean sel;

        CheckBoxLabel() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.translate(this.getWidth() / 2 - 6, this.getHeight() / 2 - 5);
            BasicGraphicsUtils.drawLoweredBezel(g, 0, 0, 12, 12, Color.darkGray, Color.black, Color.white, Color.gray);
            if (this.gray) {
                g.setColor(Color.lightGray);
                g.fillRect(1, 1, 10, 10);
            }
            if (this.sel) {
                g.setColor(Color.black);
                g.drawLine(3, 5, 5, 7);
                g.drawLine(3, 6, 5, 8);
                g.drawLine(3, 7, 5, 9);
                g.drawLine(6, 6, 9, 3);
                g.drawLine(6, 7, 9, 4);
                g.drawLine(6, 8, 9, 5);
            }
        }

        public void setGray(boolean gray) {
            this.gray = gray;
            this.repaint();
        }

        public void setSelected(boolean sel) {
            this.sel = sel;
            this.repaint();
        }
    }
}

