/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.util.client;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

public class ApplicationEventQueue {
    private static ApplicationEventQueue applicationEventQueue = null;
    private InternalEventQueue eventQueue;
    private ArrayList keyListeners = new ArrayList();
    private ArrayList mouseListeners = new ArrayList();

    private ApplicationEventQueue() {
        this.eventQueue = new InternalEventQueue();
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(this.eventQueue);
    }

    public final void addKeyListener(KeyListener listener) {
        this.keyListeners.add(listener);
    }

    public final void addMouseListener(MouseListener listener) {
        this.mouseListeners.add(listener);
    }

    public final void dispatchEvent(AWTEvent e) {
        this.eventQueue.dispatchEvent(e);
    }

    public static final ApplicationEventQueue getInstance() {
        if (applicationEventQueue == null) {
            applicationEventQueue = new ApplicationEventQueue();
        }
        return applicationEventQueue;
    }

    public final KeyListener[] getKeyListeners() {
        return this.keyListeners.toArray(new KeyListener[this.keyListeners.size()]);
    }

    public final void removeKeyListener(KeyListener listener) {
        this.keyListeners.remove(listener);
    }

    public final void removeMouseListener(MouseListener listener) {
        this.mouseListeners.remove(listener);
    }

    class InternalEventQueue
    extends EventQueue {
        InternalEventQueue() {
        }

        protected void dispatchEvent(AWTEvent e) {
            block14: {
                int i;
                block16: {
                    int i2;
                    block15: {
                        try {
                            super.dispatchEvent(e);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (e instanceof MouseEvent) {
                            if (e.getID() == 501) {
                                int i3 = 0;
                                while (i3 < ApplicationEventQueue.this.mouseListeners.size()) {
                                    ((MouseListener)ApplicationEventQueue.this.mouseListeners.get(i3)).mousePressed((MouseEvent)e);
                                    ++i3;
                                }
                            } else if (e.getID() == 502) {
                                i2 = 0;
                                while (i2 < ApplicationEventQueue.this.mouseListeners.size()) {
                                    ((MouseListener)ApplicationEventQueue.this.mouseListeners.get(i2)).mouseReleased((MouseEvent)e);
                                    ++i2;
                                }
                            } else if (e.getID() == 500) {
                                i = 0;
                                while (i < ApplicationEventQueue.this.mouseListeners.size()) {
                                    ((MouseListener)ApplicationEventQueue.this.mouseListeners.get(i)).mouseClicked((MouseEvent)e);
                                    ++i;
                                }
                            }
                        }
                        if (!(e instanceof KeyEvent)) break block14;
                        if (e.getID() != 401) break block15;
                        int i4 = 0;
                        while (i4 < ApplicationEventQueue.this.keyListeners.size()) {
                            ((KeyListener)ApplicationEventQueue.this.keyListeners.get(i4)).keyPressed((KeyEvent)e);
                            ++i4;
                        }
                        break block14;
                    }
                    if (e.getID() != 402) break block16;
                    i2 = 0;
                    while (i2 < ApplicationEventQueue.this.keyListeners.size()) {
                        ((KeyListener)ApplicationEventQueue.this.keyListeners.get(i2)).keyReleased((KeyEvent)e);
                        ++i2;
                    }
                    break block14;
                }
                if (e.getID() != 400) break block14;
                i = 0;
                while (i < ApplicationEventQueue.this.keyListeners.size()) {
                    ((KeyListener)ApplicationEventQueue.this.keyListeners.get(i)).keyTyped((KeyEvent)e);
                    ++i;
                }
            }
        }
    }
}

