/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.util.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.SearchControl;
import org.openswing.swing.util.client.SearchWindowManager;

public class SearchWindowManager {
    private JComponent comp;
    private SearchControl inputControl;
    private int lastElementFound = -1;
    private SearchWindow searchWindow;
    private String textToSearch = "";

    public SearchWindowManager(SearchControl inputControl) {
        this.inputControl = inputControl;
        inputControl.getComponent().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SearchWindowManager.this.processKey(e);
            }

            public void keyTyped(KeyEvent e) {
                SearchWindowManager.this.processKey(e);
            }
        });
        inputControl.getComponent().addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SearchWindowManager.this.hideSearchWindow();
            }
        });
        Container c = inputControl.getComponent().getParent();
        while (c != null && !(c instanceof JScrollPane)) {
            c = c.getParent();
        }
        this.comp = c instanceof JScrollPane ? (JScrollPane)c : inputControl.getComponent();
        this.comp.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                super.componentHidden(e);
                SearchWindowManager.this.hideSearchWindow();
            }

            public void componentMoved(ComponentEvent e) {
                super.componentMoved(e);
                Point location = SearchWindowManager.this.getSearchWindowLocation();
                if (location != null && SearchWindowManager.this.searchWindow != null) {
                    SearchWindowManager.this.searchWindow.setLocation(location.x, location.y);
                }
            }

            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                Point location = SearchWindowManager.this.getSearchWindowLocation();
                if (location != null && SearchWindowManager.this.searchWindow != null) {
                    SearchWindowManager.this.searchWindow.setLocation(location.x, location.y);
                }
            }
        });
    }

    private Point getSearchWindowLocation() {
        Point searchWindowLocation;
        try {
            searchWindowLocation = this.comp.getLocationOnScreen();
        }
        catch (IllegalComponentStateException e) {
            return this.comp.getLocation();
        }
        if (searchWindowLocation == null) {
            return null;
        }
        if (this.searchWindow == null) {
            return null;
        }
        searchWindowLocation.y -= this.searchWindow.getPreferredSize().height;
        if (searchWindowLocation.y < 0) {
            searchWindowLocation.y = 0;
        }
        if (searchWindowLocation.x < 0) {
            searchWindowLocation.x = 0;
        }
        this.packSearchWindow();
        return searchWindowLocation;
    }

    public void hideSearchWindow() {
        if (this.searchWindow != null) {
            this.searchWindow.setVisible(false);
            this.searchWindow.dispose();
            this.searchWindow = null;
        }
    }

    public final boolean isSearchWindowVisible() {
        return this.searchWindow != null;
    }

    private void packSearchWindow() {
        if (this.searchWindow == null) {
            return;
        }
        this.searchWindow.pack();
    }

    private void processKey(KeyEvent e) {
        boolean ok;
        if (!this.inputControl.isReadOnly() || this.inputControl.disableListener()) {
            this.hideSearchWindow();
            return;
        }
        char c = e.getKeyChar();
        boolean bl = ok = e.getID() == 400 && (Character.isLetterOrDigit(c) || c == ' ' || c == '*' || c == '?' || c == '\b' || c == '/' || c == '.' || c == ',' || c == '-');
        if (ok) {
            if (e.getID() == 400) {
                if ((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    return;
                }
                if (e.isAltDown()) {
                    return;
                }
                this.textToSearch = c == '\b' ? (this.textToSearch.length() > 0 ? this.textToSearch.substring(0, this.textToSearch.length() - 1) : "") : this.textToSearch + String.valueOf(e.getKeyChar());
            }
            if (this.searchWindow != null) {
                this.hideSearchWindow();
            }
            this.searchWindow = new SearchWindow(this.textToSearch);
            Point location = this.getSearchWindowLocation();
            if (location != null) {
                this.searchWindow.setLocation(location.x, location.y);
            }
            this.searchWindow.setVisible(true);
            if (e.getKeyCode() != 10) {
                if (e.getKeyCode() != 27) {
                    e.consume();
                }
            }
        } else if (e.getKeyCode() == 27 && this.searchWindow != null) {
            this.hideSearchWindow();
            e.consume();
        }
    }

    class SearchField
    extends JTextField {
        SearchField() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusable(false);
            this.setOpaque(false);
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 4;
            return size;
        }

        private boolean isDeactivateKey(KeyEvent e) {
            int keyCode = e.getKeyCode();
            return keyCode == 10 || keyCode == 27 || keyCode == 33 || keyCode == 34 || keyCode == 36 || keyCode == 35 || keyCode == 37 || keyCode == 39 || keyCode == 38 || keyCode == 40;
        }

        public void processKeyEvent(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 8 && this.getDocument().getLength() == 0) {
                e.consume();
                return;
            }
            if (this.isDeactivateKey(e)) {
                SearchWindowManager.this.hideSearchWindow();
                if (keyCode == 27) {
                    e.consume();
                }
                return;
            }
            super.processKeyEvent(e);
            if (keyCode == 8) {
                e.consume();
            }
        }
    }

    private class SearchWindow
    extends JWindow {
        private Color defaultForeground;
        private JLabel notFoundLabel;
        private SearchField searchField;
        private JLabel searchLabel = new JLabel(ClientSettings.getInstance().getResources().getResource("search") + ": ");

        public SearchWindow(String text) {
            this.notFoundLabel = new JLabel();
            this.searchLabel.setVerticalAlignment(3);
            this.searchLabel.setFont(new Font(this.searchLabel.getFont().getName(), 1, this.searchLabel.getFont().getSize()));
            this.notFoundLabel.setVerticalAlignment(3);
            this.notFoundLabel.setForeground(Color.red);
            this.searchField = new SearchField();
            this.searchField.setCursor(this.getCursor());
            this.defaultForeground = this.searchField.getForeground();
            this.searchField.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ SearchWindow this$1;
                private Timer timer;
                {
                    this.this$1 = this$1;
                    this.timer = new Timer(200, new ActionListener(this){
                        private final /* synthetic */ 4 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public void actionPerformed(ActionEvent e) {
                            this.this$2.applyText();
                        }
                    });
                }

                protected void applyText() {
                    String text = SearchWindow.access$300(this.this$1).getText().trim();
                    if (text.length() != 0) {
                        int found = SearchWindow.access$400(this.this$1, text);
                        if (found == -1) {
                            found = SearchWindowManager.access$600(SearchWindow.access$500(this.this$1)).search(text);
                            if (found == -1) {
                                SearchWindow.access$300(this.this$1).setForeground(Color.red);
                            } else {
                                SearchWindow.access$300(this.this$1).setForeground(SearchWindow.access$700(this.this$1));
                            }
                        } else {
                            SearchWindow.access$300(this.this$1).setForeground(SearchWindow.access$700(this.this$1));
                        }
                        SearchWindow.access$800(this.this$1, found, null, text);
                    } else {
                        SearchWindow.access$500(this.this$1).hideSearchWindow();
                    }
                }

                public void changedUpdate(DocumentEvent e) {
                    this.startTimer();
                }

                public void insertUpdate(DocumentEvent e) {
                    this.startTimer();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.startTimer();
                }

                void startTimer() {
                    this.applyText();
                }
            });
            this.searchField.setText(text);
            try {
                ((JPanel)this.getContentPane()).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray, 1), BorderFactory.createEmptyBorder(2, 6, 2, 8)));
                this.getContentPane().setBackground(new Color(250, 250, 200));
            }
            catch (Exception ex) {
                // empty catch block
            }
            Dimension size = this.searchLabel.getPreferredSize();
            size.height = this.searchField.getPreferredSize().height;
            this.searchLabel.setPreferredSize(size);
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)this.searchLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.searchField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.notFoundLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        }

        static /* synthetic */ SearchField access$300(SearchWindow x0) {
            return x0.searchField;
        }

        static /* synthetic */ int access$400(SearchWindow x0, String x1) {
            return x0.searchFromCurrentIndex(x1);
        }

        static /* synthetic */ SearchWindowManager access$500(SearchWindow x0) {
            return x0.SearchWindowManager.this;
        }

        static /* synthetic */ Color access$700(SearchWindow x0) {
            return x0.defaultForeground;
        }

        static /* synthetic */ void access$800(SearchWindow x0, int x1, KeyEvent x2, String x3) {
            x0.select(x1, x2, x3);
        }

        private boolean compare(String item, String textToSearch) {
            if (item == null) {
                return false;
            }
            if (textToSearch == null || textToSearch.trim().length() == 0) {
                return true;
            }
            if (textToSearch.indexOf(42) == -1 && textToSearch.indexOf(63) == -1) {
                return item.toUpperCase().startsWith(textToSearch);
            }
            try {
                return Pattern.compile(item.toUpperCase(), 2).matcher(item.toUpperCase()).find();
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }

        public void processKeyEvent(KeyEvent e) {
            this.searchField.processKeyEvent(e);
            if (e.isConsumed() && (this.searchField.getText() == null || this.searchField.getText().trim().length() == 0)) {
                return;
            }
            if (e.getKeyCode() != 10) {
                e.consume();
            }
        }

        private int searchFromCurrentIndex(String textToSearch) {
            int selectedIndex;
            textToSearch = textToSearch.toUpperCase();
            int n = selectedIndex = SearchWindowManager.this.lastElementFound != -1 ? SearchWindowManager.this.lastElementFound : SearchWindowManager.this.inputControl.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if (SearchWindowManager.this.inputControl.getRowCount() == 0) {
                return -1;
            }
            String element = null;
            int i = selectedIndex;
            while (i < SearchWindowManager.this.inputControl.getRowCount()) {
                element = SearchWindowManager.this.inputControl.getValueAt(i);
                if (this.compare(element, textToSearch)) {
                    return i;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < selectedIndex) {
                element = SearchWindowManager.this.inputControl.getValueAt(i2);
                if (this.compare(element, textToSearch)) {
                    return i2;
                }
                ++i2;
            }
            return -1;
        }

        private void select(int index, KeyEvent e, String textToSearch) {
            if (index != -1) {
                SearchWindowManager.this.inputControl.setSelectedIndex(index);
                SearchWindowManager.this.lastElementFound = index;
                this.searchField.setForeground(this.defaultForeground);
                this.notFoundLabel.setText("");
            } else {
                this.searchField.setForeground(Color.red);
                this.notFoundLabel.setText(ClientSettings.getInstance().getResources().getResource("not found"));
            }
        }
    }
}

