/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.wizard.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;
import org.openswing.swing.wizard.client.WizardController;
import org.openswing.swing.wizard.client.WizardInnerPanel;

public class WizardPanel
extends JPanel
implements ActionListener {
    JButton backButton;
    private String backImageName = "prev.gif";
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonsPanel;
    JButton cancelButton;
    private String cancelImageName = "cancel.gif";
    CardLayout cardLayout1;
    private WizardInnerPanel currentVisiblePanel = null;
    private String finishImageName = "exec.gif";
    FlowLayout flowLayout1;
    private String imageName = null;
    private ImagePanel imagePanel;
    private ArrayList listeners;
    JPanel mainPanel = new JPanel();
    JButton nextButton;
    private String nextImageName = "next.gif";
    private ArrayList panels;
    private WizardController wizardController;

    public WizardPanel() {
        this.buttonsPanel = new JPanel();
        this.cardLayout1 = new CardLayout();
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.cancelButton = new JButton();
        this.flowLayout1 = new FlowLayout();
        this.listeners = new ArrayList();
        this.panels = new ArrayList();
        this.wizardController = new WizardController();
        this.imagePanel = new ImagePanel();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        String panelId;
        int i = 0;
        while (i < this.listeners.size()) {
            ((ActionListener)this.listeners.get(i)).actionPerformed(actionEvent);
            ++i;
        }
        if (actionEvent.getSource().equals(this.backButton)) {
            String panelId2 = this.wizardController.getBackPanelId(this);
            if (panelId2 != null) {
                this.currentVisiblePanel = this.getPanel(panelId2);
                this.cardLayout1.show(this.mainPanel, panelId2);
                if (panelId2.equals(this.wizardController.getFirstPanelId(this))) {
                    this.backButton.setEnabled(false);
                    this.nextButton.setEnabled(true);
                } else {
                    this.backButton.setEnabled(true);
                    this.nextButton.setEnabled(true);
                }
                this.cancelButton.setText(ClientSettings.getInstance().getResources().getResource("cancel"));
                this.cancelButton.setIcon(new ImageIcon(ClientUtils.getImage(this.cancelImageName)));
                this.buttonsPanel.revalidate();
                this.buttonsPanel.repaint();
                this.imagePanel.setImage(this.imageName);
                if (this.currentVisiblePanel.getImageName() != null) {
                    this.imagePanel.setImage(this.currentVisiblePanel.getImageName());
                }
                this.currentVisiblePanel.init();
            }
        } else if (actionEvent.getSource().equals(this.nextButton) && (panelId = this.wizardController.getNextPanelId(this)) != null) {
            this.currentVisiblePanel = this.getPanel(panelId);
            this.cardLayout1.show(this.mainPanel, panelId);
            if (panelId.equals(this.wizardController.getLastPanelId(this))) {
                this.nextButton.setEnabled(false);
                this.backButton.setEnabled(true);
                this.cancelButton.setText(ClientSettings.getInstance().getResources().getResource("finish"));
                this.cancelButton.setIcon(new ImageIcon(ClientUtils.getImage(this.finishImageName)));
                this.buttonsPanel.revalidate();
                this.buttonsPanel.repaint();
            } else {
                this.nextButton.setEnabled(true);
                this.backButton.setEnabled(true);
            }
            this.imagePanel.setImage(this.imageName);
            if (this.currentVisiblePanel.getImageName() != null) {
                this.imagePanel.setImage(this.currentVisiblePanel.getImageName());
            }
            this.currentVisiblePanel.init();
        }
    }

    public final void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public final void addButton(JButton button, int pos) {
        this.buttonsPanel.add((Component)button, pos);
        button.addActionListener(this);
    }

    public final void addNotify() {
        String panelId;
        super.addNotify();
        if (!Beans.isDesignTime() && this.currentVisiblePanel == null && (panelId = this.wizardController.getFirstPanelId(this)) != null) {
            this.currentVisiblePanel = this.getPanel(panelId);
            this.cardLayout1.show(this.mainPanel, this.currentVisiblePanel.getPanelId());
            if (this.panels.size() > 1) {
                this.nextButton.setEnabled(true);
            }
            this.imagePanel.setImage(this.imageName);
            if (this.currentVisiblePanel.getImageName() != null) {
                this.imagePanel.setImage(this.currentVisiblePanel.getImageName());
            }
            this.backButton.setIcon(new ImageIcon(ClientUtils.getImage(this.backImageName)));
            this.nextButton.setIcon(new ImageIcon(ClientUtils.getImage(this.nextImageName)));
            this.cancelButton.setIcon(new ImageIcon(ClientUtils.getImage(this.cancelImageName)));
            this.currentVisiblePanel.init();
        }
    }

    public final void addPanel(WizardInnerPanel panel) {
        this.panels.add(panel);
        this.mainPanel.add(panel.getPanelId(), panel);
    }

    public final JButton getBackButton() {
        return this.backButton;
    }

    public final String getBackImageName() {
        return this.backImageName;
    }

    public final JPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    public final JButton getCancelButton() {
        return this.cancelButton;
    }

    public final String getCancelImageName() {
        return this.cancelImageName;
    }

    public final WizardInnerPanel getCurrentVisiblePanel() {
        return this.currentVisiblePanel;
    }

    public final String getFinishImageName() {
        return this.finishImageName;
    }

    public final String getImageName() {
        return this.imageName;
    }

    public final WizardController getNavigationLogic() {
        return this.wizardController;
    }

    public final JButton getNextButton() {
        return this.nextButton;
    }

    public final String getNextImageName() {
        return this.nextImageName;
    }

    public final WizardInnerPanel getPanel(String panelId) {
        int i = 0;
        while (i < this.panels.size()) {
            if (((WizardInnerPanel)this.panels.get(i)).getPanelId().equals(panelId)) {
                return (WizardInnerPanel)this.panels.get(i);
            }
            ++i;
        }
        return null;
    }

    public WizardInnerPanel[] getPanels() {
        return this.panels.toArray(new WizardInnerPanel[this.panels.size()]);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.mainPanel.setLayout(this.cardLayout1);
        this.buttonsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonsPanel.setLayout(this.flowLayout1);
        this.mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.backButton.setPreferredSize(new Dimension(120, 30));
        this.backButton.setMinimumSize(new Dimension(120, 30));
        this.backButton.setEnabled(false);
        this.backButton.setEnabled(false);
        this.backButton.setText(ClientSettings.getInstance().getResources().getResource("back"));
        this.backButton.addActionListener(this);
        this.nextButton.setPreferredSize(new Dimension(120, 30));
        this.nextButton.setMinimumSize(new Dimension(120, 30));
        this.nextButton.setEnabled(false);
        this.nextButton.setText(ClientSettings.getInstance().getResources().getResource("next"));
        this.nextButton.addActionListener(this);
        this.cancelButton.setPreferredSize(new Dimension(120, 30));
        this.cancelButton.setMinimumSize(new Dimension(120, 30));
        this.cancelButton.setText(ClientSettings.getInstance().getResources().getResource("cancel"));
        this.cancelButton.addActionListener(this);
        this.flowLayout1.setAlignment(2);
        this.add((Component)this.imagePanel, "West");
        this.add((Component)this.mainPanel, "Center");
        this.add((Component)this.buttonsPanel, "South");
        this.buttonsPanel.add((Component)this.backButton, null);
        this.buttonsPanel.add((Component)this.nextButton, null);
        this.buttonsPanel.add((Component)this.cancelButton, null);
    }

    public final void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public final void removeButton(JButton button) {
        this.buttonsPanel.remove(button);
        this.buttonsPanel.revalidate();
        this.buttonsPanel.repaint();
        button.removeActionListener(this);
    }

    public final void setBackImageName(String backImageName) {
        this.backImageName = backImageName;
    }

    public final void setCancelImageName(String cancelImageName) {
        this.cancelImageName = cancelImageName;
    }

    public final void setFinishImageName(String finishImageName) {
        this.finishImageName = finishImageName;
    }

    public final void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public final void setNavigationLogic(WizardController wizardController) {
        this.wizardController = wizardController;
    }

    public final void setNextImageName(String nextImageName) {
        this.nextImageName = nextImageName;
    }

    class ImagePanel
    extends JPanel {
        private Image image = null;

        ImagePanel() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this.image.getWidth(this), this.image.getHeight(this), this);
            }
        }

        public void setImage(String imageName) {
            if (imageName == null) {
                this.image = null;
                this.setSize(0, 0);
                this.setPreferredSize(new Dimension(0, 0));
                this.setMinimumSize(new Dimension(0, 0));
                return;
            }
            this.image = ClientUtils.getImage(imageName);
            if (this.image == null) {
                return;
            }
            this.setSize(this.image.getWidth(this), this.image.getHeight(this));
            this.setPreferredSize(new Dimension(this.image.getWidth(this), this.image.getHeight(this)));
            this.setMinimumSize(new Dimension(this.image.getWidth(this), this.image.getHeight(this)));
            this.repaint();
        }
    }
}

