/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.export.java;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.openswing.swing.export.java.ComponentExportOptions;
import org.openswing.swing.export.java.ExportOptions;
import org.openswing.swing.export.java.GridExportCallbacks;
import org.openswing.swing.export.java.GridExportOptions;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;

public class ExportToExcel {
    private int appendRow(HSSFWorkbook wb, HSSFSheet s, Object vo, ExportOptions exportOptions, GridExportOptions opt, Hashtable gettersMethods, HSSFCellStyle csText, HSSFCellStyle csBool, HSSFCellStyle csDecNum, HSSFCellStyle csIntNum, HSSFCellStyle csDate, HSSFCellStyle csTime, HSSFCellStyle csDateTime, int rownum, int tableType) throws Throwable {
        HSSFRow r = null;
        HSSFCell c = null;
        r = s.createRow(rownum);
        String aName = null;
        Method getter = null;
        Class<?> clazz = null;
        Object obj = null;
        short i = 0;
        while (i < opt.getExportColumns().size()) {
            c = r.createCell(i);
            clazz = vo.getClass();
            obj = vo;
            aName = opt.getExportAttrColumns().get(i).toString();
            while (aName.indexOf(".") != -1) {
                try {
                    getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                }
                catch (NoSuchMethodException ex2) {
                    getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                }
                aName = aName.substring(aName.indexOf(".") + 1);
                clazz = getter.getReturnType();
                obj = getter.invoke(obj, new Object[0]);
                if (obj == null) break;
            }
            try {
                getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            if (obj != null) {
                obj = getter.invoke(obj, new Object[0]);
            }
            if (obj != null) {
                if (obj instanceof String) {
                    try {
                        c.setEncoding((short)1);
                    }
                    catch (NoSuchMethodError ex) {
                        // empty catch block
                    }
                    c.setCellValue(obj.toString());
                    c.setCellStyle(csText);
                } else if (obj instanceof BigDecimal || obj instanceof Double || obj instanceof Float || obj.getClass() == Double.TYPE || obj.getClass() == Float.TYPE) {
                    c.setCellValue(Double.parseDouble(obj.toString()));
                    c.setCellStyle(csDecNum);
                } else if (obj instanceof Integer || obj instanceof Short || obj instanceof Long || obj.getClass() == Integer.TYPE || obj.getClass() == Short.TYPE || obj.getClass() == Long.TYPE) {
                    c.setCellValue(Double.parseDouble(obj.toString()));
                    c.setCellStyle(csIntNum);
                } else if (obj instanceof Boolean) {
                    c.setCellValue(((Boolean)obj).booleanValue());
                    c.setCellStyle(csBool);
                } else if (obj.getClass().equals(Boolean.TYPE)) {
                    c.setCellValue(((Boolean)obj).booleanValue());
                    c.setCellStyle(csBool);
                } else if (obj instanceof Date || obj instanceof java.util.Date || obj instanceof Timestamp) {
                    c.setCellValue((java.util.Date)obj);
                    int type = (Integer)opt.getColumnsType().get(opt.getExportAttrColumns().get(i));
                    if (type == 1) {
                        c.setCellStyle(csDate);
                    } else if (type == 2) {
                        c.setCellStyle(csDateTime);
                    } else if (type == 3) {
                        c.setCellStyle(csTime);
                        Calendar cal = Calendar.getInstance();
                        cal.setTime((java.util.Date)obj);
                        if (cal.get(1) < 1900) {
                            cal.set(1, 2000);
                        }
                        c.setCellValue(cal.getTime());
                    }
                }
            } else {
                c.setCellValue("");
                c.setCellStyle(csText);
            }
            s.setColumnWidth(i, (short)(32 * ((Integer)opt.getColumnsWidth().get(opt.getExportAttrColumns().get(i))).shortValue()));
            i = (short)(i + 1);
        }
        ++rownum;
        if (opt.getCallbacks() != null) {
            if (tableType == 0) {
                rownum = this.processComponent(wb, s, exportOptions, opt.getCallbacks().getComponentPerRowInHeader((ValueObject)vo, rownum), rownum);
            } else if (tableType == 1) {
                rownum = this.processComponent(wb, s, exportOptions, opt.getCallbacks().getComponentPerRow((ValueObject)vo, rownum), rownum);
            } else if (tableType == 2) {
                rownum = this.processComponent(wb, s, exportOptions, opt.getCallbacks().getComponentPerRowInFooter((ValueObject)vo, rownum), rownum);
            }
        }
        return rownum;
    }

    public byte[] getDocument(ExportOptions opt) throws Throwable {
        Object obj = null;
        int rownum = 0;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet s = wb.createSheet();
        int i = 0;
        while (i < opt.getComponentsExportOptions().size()) {
            obj = opt.getComponentsExportOptions().get(i);
            rownum = this.processComponent(wb, s, opt, obj, rownum);
            ++i;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        wb.write((OutputStream)out);
        byte[] doc = out.toByteArray();
        out.close();
        return doc;
    }

    private int prepareGenericComponent(int rownum, HSSFWorkbook wb, HSSFSheet s, ExportOptions exportOptions, ComponentExportOptions opt) throws Throwable {
        Object[] row = null;
        Object obj = null;
        HSSFRow r = null;
        HSSFCell c = null;
        HSSFCellStyle csText = wb.createCellStyle();
        csText.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"text"));
        csText.setBorderBottom((short)1);
        csText.setBorderLeft((short)1);
        csText.setBorderRight((short)1);
        csText.setBorderTop((short)1);
        HSSFCellStyle csTitle = wb.createCellStyle();
        csTitle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"text"));
        csTitle.setBorderBottom((short)1);
        csTitle.setBorderLeft((short)1);
        csTitle.setBorderRight((short)1);
        csTitle.setBorderTop((short)1);
        HSSFFont f = wb.createFont();
        f.setBoldweight((short)400);
        csTitle.setFont(f);
        HSSFCellStyle csBool = wb.createCellStyle();
        csBool.setBorderBottom((short)1);
        csBool.setBorderLeft((short)1);
        csBool.setBorderRight((short)1);
        csBool.setBorderTop((short)1);
        HSSFCellStyle csDecNum = wb.createCellStyle();
        csDecNum.setDataFormat(wb.createDataFormat().getFormat("#,##0.#####"));
        csDecNum.setBorderBottom((short)1);
        csDecNum.setBorderLeft((short)1);
        csDecNum.setBorderRight((short)1);
        csDecNum.setBorderTop((short)1);
        HSSFCellStyle csIntNum = wb.createCellStyle();
        csIntNum.setDataFormat(wb.createDataFormat().getFormat("#,##0"));
        csIntNum.setBorderBottom((short)1);
        csIntNum.setBorderLeft((short)1);
        csIntNum.setBorderRight((short)1);
        csIntNum.setBorderTop((short)1);
        HSSFCellStyle csDateTime = wb.createCellStyle();
        csDateTime.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy h:mm"));
        csDateTime.setBorderBottom((short)1);
        csDateTime.setBorderLeft((short)1);
        csDateTime.setBorderRight((short)1);
        csDateTime.setBorderTop((short)1);
        if (opt.getCellsContent() != null) {
            int i = 0;
            while (i < opt.getCellsContent().length) {
                row = opt.getCellsContent()[i];
                r = s.createRow(rownum);
                short j = 0;
                while (j < row.length) {
                    c = r.createCell(j);
                    obj = row[j];
                    if (obj != null) {
                        if (obj instanceof String) {
                            try {
                                c.setEncoding((short)1);
                            }
                            catch (NoSuchMethodError ex) {
                                // empty catch block
                            }
                            c.setCellValue(obj.toString());
                            c.setCellStyle(csText);
                        } else if (obj instanceof BigDecimal || obj instanceof Double || obj instanceof Float || obj.getClass() == Double.TYPE || obj.getClass() == Float.TYPE) {
                            c.setCellValue(Double.parseDouble(obj.toString()));
                            c.setCellStyle(csDecNum);
                        } else if (obj instanceof Integer || obj instanceof Short || obj instanceof Long || obj.getClass() == Integer.TYPE || obj.getClass() == Short.TYPE || obj.getClass() == Long.TYPE) {
                            c.setCellValue(Double.parseDouble(obj.toString()));
                            c.setCellStyle(csIntNum);
                        } else if (obj instanceof Boolean) {
                            c.setCellValue(((Boolean)obj).booleanValue());
                            c.setCellStyle(csBool);
                        } else if (obj.getClass().equals(Boolean.TYPE)) {
                            c.setCellValue(((Boolean)obj).booleanValue());
                            c.setCellStyle(csBool);
                        } else if (obj instanceof Date || obj instanceof java.util.Date || obj instanceof Timestamp) {
                            c.setCellValue((java.util.Date)obj);
                            c.setCellStyle(csDateTime);
                        }
                    } else {
                        c.setCellValue("");
                        c.setCellStyle(csText);
                    }
                    j = (short)(j + 1);
                }
                ++rownum;
                ++i;
            }
        }
        return rownum;
    }

    private int prepareGrid(int rownum, HSSFWorkbook wb, HSSFSheet s, ExportOptions exportOptions, GridExportOptions opt) throws Throwable {
        int j;
        String[] filters;
        HSSFRow r = null;
        HSSFCell c = null;
        HSSFCellStyle csText = wb.createCellStyle();
        csText.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"text"));
        csText.setBorderBottom((short)1);
        csText.setBorderLeft((short)1);
        csText.setBorderRight((short)1);
        csText.setBorderTop((short)1);
        HSSFCellStyle csTitle = wb.createCellStyle();
        csTitle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"text"));
        csTitle.setBorderBottom((short)1);
        csTitle.setBorderLeft((short)1);
        csTitle.setBorderRight((short)1);
        csTitle.setBorderTop((short)1);
        HSSFFont f = wb.createFont();
        f.setBoldweight((short)400);
        csTitle.setFont(f);
        HSSFCellStyle csBool = wb.createCellStyle();
        csBool.setBorderBottom((short)1);
        csBool.setBorderLeft((short)1);
        csBool.setBorderRight((short)1);
        csBool.setBorderTop((short)1);
        HSSFCellStyle csDecNum = wb.createCellStyle();
        csDecNum.setDataFormat(wb.createDataFormat().getFormat("#,##0.#####"));
        csDecNum.setBorderBottom((short)1);
        csDecNum.setBorderLeft((short)1);
        csDecNum.setBorderRight((short)1);
        csDecNum.setBorderTop((short)1);
        HSSFCellStyle csIntNum = wb.createCellStyle();
        csIntNum.setDataFormat(wb.createDataFormat().getFormat("#,##0"));
        csIntNum.setBorderBottom((short)1);
        csIntNum.setBorderLeft((short)1);
        csIntNum.setBorderRight((short)1);
        csIntNum.setBorderTop((short)1);
        HSSFCellStyle csDate = wb.createCellStyle();
        csDate.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy"));
        csDate.setBorderBottom((short)1);
        csDate.setBorderLeft((short)1);
        csDate.setBorderRight((short)1);
        csDate.setBorderTop((short)1);
        HSSFCellStyle csTime = wb.createCellStyle();
        csTime.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)(exportOptions.getTimeFormat().equals("HH:mm") ? "h:mm" : "h:mm AM/PM")));
        csTime.setBorderBottom((short)1);
        csTime.setBorderLeft((short)1);
        csTime.setBorderRight((short)1);
        csTime.setBorderTop((short)1);
        HSSFCellStyle csDateTime = wb.createCellStyle();
        csDateTime.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy h:mm"));
        csDateTime.setBorderBottom((short)1);
        csDateTime.setBorderLeft((short)1);
        csDateTime.setBorderRight((short)1);
        csDateTime.setBorderTop((short)1);
        String methodName = null;
        String attributeName = null;
        Hashtable<String, Method> gettersMethods = new Hashtable<String, Method>();
        Method[] voMethods = opt.getValueObjectType().getMethods();
        int i = 0;
        while (i < voMethods.length) {
            methodName = voMethods[i].getName();
            if (methodName.startsWith("get")) {
                attributeName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                if (opt.getExportAttrColumns().contains(attributeName)) {
                    gettersMethods.put(attributeName, voMethods[i]);
                }
            }
            ++i;
        }
        Response response = null;
        int start = 0;
        Object value = null;
        Object vo = null;
        boolean firstRow = true;
        if (opt.getTitle() != null && !opt.getTitle().equals("")) {
            r = s.createRow(rownum);
            c = r.createCell((short)0);
            try {
                c.setEncoding((short)1);
            }
            catch (NoSuchMethodError ex) {
                // empty catch block
            }
            c.setCellValue(opt.getTitle());
            c.setCellStyle(csTitle);
            ++rownum;
            ++rownum;
        }
        if ((filters = opt.getFilteringConditions()) != null) {
            int i2 = 0;
            while (i2 < filters.length) {
                r = s.createRow(rownum);
                c = r.createCell((short)0);
                try {
                    c.setEncoding((short)1);
                }
                catch (NoSuchMethodError ex) {
                    // empty catch block
                }
                c.setCellValue(filters[i2]);
                ++rownum;
                ++i2;
            }
            ++rownum;
        }
        do {
            if ((response = opt.getGridDataLocator().loadData(1, start, opt.getFilteredColumns(), opt.getCurrentSortedColumns(), opt.getCurrentSortedVersusColumns(), opt.getValueObjectType(), opt.getOtherGridParams())).isError()) {
                throw new Exception(response.getErrorMessage());
            }
            j = 0;
            while (j < ((VOListResponse)response).getRows().size()) {
                if (firstRow) {
                    firstRow = false;
                    r = s.createRow(rownum++);
                    short i3 = 0;
                    while (i3 < opt.getExportColumns().size()) {
                        c = r.createCell(i3);
                        try {
                            c.setEncoding((short)1);
                        }
                        catch (NoSuchMethodError ex) {
                            // empty catch block
                        }
                        c.setCellValue(opt.getExportColumns().get(i3).toString());
                        c.setCellStyle(csTitle);
                        i3 = (short)(i3 + 1);
                    }
                    int k = 0;
                    while (k < opt.getTopRows().size()) {
                        vo = opt.getTopRows().get(k);
                        rownum = this.appendRow(wb, s, vo, exportOptions, opt, gettersMethods, csText, csBool, csDecNum, csIntNum, csDate, csTime, csDateTime, rownum, 0);
                        ++k;
                    }
                }
                vo = ((VOListResponse)response).getRows().get(j);
                rownum = this.appendRow(wb, s, vo, exportOptions, opt, gettersMethods, csText, csBool, csDecNum, csIntNum, csDate, csTime, csDateTime, rownum, 1);
                ++j;
            }
            start += ((VOListResponse)response).getRows().size();
        } while (((VOListResponse)response).isMoreRows() && rownum < opt.getMaxRows());
        j = 0;
        while (j < opt.getBottomRows().size()) {
            vo = opt.getBottomRows().get(j);
            rownum = this.appendRow(wb, s, vo, exportOptions, opt, gettersMethods, csText, csBool, csDecNum, csIntNum, csDate, csTime, csDateTime, rownum, 2);
            ++j;
        }
        return rownum;
    }

    private int processComponent(HSSFWorkbook wb, HSSFSheet s, ExportOptions exportOptions, Object obj, int rownum) throws Throwable {
        if (obj != null) {
            GridExportCallbacks callbacks = null;
            if (obj instanceof GridExportOptions) {
                callbacks = ((GridExportOptions)obj).getCallbacks();
                if (callbacks != null) {
                    rownum = this.processComponent(wb, s, exportOptions, callbacks.getHeaderComponent(), rownum) + 1;
                }
                rownum = this.prepareGrid(rownum, wb, s, exportOptions, (GridExportOptions)obj) + 1;
                if (callbacks != null) {
                    rownum = this.processComponent(wb, s, exportOptions, callbacks.getFooterComponent(), rownum) + 1;
                }
            } else {
                if (obj instanceof ComponentExportOptions) {
                    return this.prepareGenericComponent(rownum, wb, s, exportOptions, (ComponentExportOptions)obj) + 1;
                }
                return rownum;
            }
        }
        return rownum;
    }
}

