/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.export.server;

import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.openswing.swing.export.java.ExportOptions;
import org.openswing.swing.export.java.ExportToCSV;
import org.openswing.swing.export.java.ExportToExcel;
import org.openswing.swing.export.java.ExportToHTML;
import org.openswing.swing.export.java.ExportToPDF;
import org.openswing.swing.export.java.ExportToRTF;
import org.openswing.swing.export.java.ExportToXML;
import org.openswing.swing.export.java.ExportToXMLFat;
import org.openswing.swing.export.java.GridExportOptions;
import org.openswing.swing.export.server.EJBExportRemote;
import org.openswing.swing.message.receive.java.BytesResponse;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.table.java.EJBGridDataLocator;

@Stateless
public class EJBExportBean
implements EJBExportRemote {
    InitialContext initialContext;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Response export(ExportOptions exportOptions) throws Exception {
        this.initialContext = new InitialContext();
        Object var2_2 = null;
        GridExportOptions gridExportOptions = null;
        for (int i = 0; i < exportOptions.getComponentsExportOptions().size(); ++i) {
            var2_2 = exportOptions.getComponentsExportOptions().get(i);
            if (!(var2_2 instanceof GridExportOptions)) continue;
            gridExportOptions = var2_2;
            ((EJBGridDataLocator)gridExportOptions.getGridDataLocator()).setInitialContext(this.initialContext);
            gridExportOptions.getOtherGridParams().put("LOAD_ALL", Boolean.TRUE);
        }
        byte[] byArray = null;
        String string = null;
        try {
            block12: {
                block11: {
                    if (exportOptions.getExportType().equals("XLS")) {
                        byArray = new ExportToExcel().getDocument(exportOptions);
                        string = "doc" + System.currentTimeMillis() + ".xls";
                        return new BytesResponse(byArray, string);
                    }
                    if (exportOptions.getExportType().equals("CSV (,)")) break block11;
                    if (!exportOptions.getExportType().equals("CSV (;)")) break block12;
                }
                byArray = new ExportToCSV().getDocument(exportOptions);
                string = "doc" + System.currentTimeMillis() + ".csv";
                return new BytesResponse(byArray, string);
            }
            if (exportOptions.getExportType().equals("XML (small format)")) {
                byArray = new ExportToXML().getDocument(exportOptions);
                string = "doc" + System.currentTimeMillis() + ".xml";
                return new BytesResponse(byArray, string);
            }
            if (exportOptions.getExportType().equals("XML (large format)")) {
                byArray = new ExportToXMLFat().getDocument(exportOptions);
                string = "doc" + System.currentTimeMillis() + ".xml";
                return new BytesResponse(byArray, string);
            }
            if (exportOptions.getExportType().equals("HTML")) {
                byArray = new ExportToHTML().getDocument(exportOptions);
                string = "doc" + System.currentTimeMillis() + ".html";
                return new BytesResponse(byArray, string);
            }
            if (exportOptions.getExportType().equals("PDF")) {
                byArray = new ExportToPDF().getDocument(exportOptions);
                string = "doc" + System.currentTimeMillis() + ".pdf";
                return new BytesResponse(byArray, string);
            }
            if (!exportOptions.getExportType().equals("RTF")) return new BytesResponse(byArray, string);
            byArray = new ExportToRTF().getDocument(exportOptions);
            string = "doc" + System.currentTimeMillis() + ".rtf";
            return new BytesResponse(byArray, string);
        }
        catch (Throwable throwable) {
            new ErrorResponse(throwable.getMessage());
        }
        return new BytesResponse(byArray, string);
    }

    public void setInitialContext(InitialContext initialContext) {
        this.initialContext = initialContext;
    }
}

