/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.internationalization.java;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;

public class Resources
implements Serializable {
    public static final int DMY = 1;
    public static final String HH_MM = "HH:mm";
    public static final String HH_MM_SS = "HH:mm:ss";
    public static final String H_MM_AAA = "h:mm aaa";
    public static final String H_MM_SS_AAA = "h:mm:ss aaa";
    public static final int MDY = 2;
    public static final int YDM = 3;
    public static final int YMD = 0;
    private String currencySymbol;
    private int dateFormat;
    private char dateFormatSeparator;
    private char decimalSymbol;
    private Properties dictionary;
    private char groupingSymbol;
    private String languageId;
    private boolean showCenturyInDateFormat;
    private boolean showResourceNotFoundWarning = true;
    private String timeFormat;

    public Resources(Properties dictionary, String currencySymbol, char decimalSymbol, char groupingSymbol, int dateFormat, boolean showCenturyInDateFormat, char dateFormatSeparator, String timeFormat, String languageId, boolean showResourceNotFoundWarning) {
        if (dateFormat < 0 || dateFormat > 3) {
            dateFormat = 0;
        }
        this.dictionary = dictionary;
        this.currencySymbol = currencySymbol;
        this.decimalSymbol = decimalSymbol;
        this.groupingSymbol = groupingSymbol;
        this.dateFormat = dateFormat;
        this.showCenturyInDateFormat = showCenturyInDateFormat;
        this.dateFormatSeparator = dateFormatSeparator;
        this.languageId = languageId;
        this.showResourceNotFoundWarning = showResourceNotFoundWarning;
        if (!(timeFormat.equals(HH_MM) || timeFormat.equals(H_MM_AAA) || timeFormat.equals(HH_MM_SS) || timeFormat.equals(H_MM_SS_AAA))) {
            System.err.println("The time format specified '" + timeFormat + "' is not allowed.\nAllowable values are: '" + HH_MM + "' or '" + H_MM_AAA + "'" + "' or '" + HH_MM_SS + "'" + "' or '" + H_MM_SS_AAA + "'");
            timeFormat = HH_MM;
        }
        this.timeFormat = timeFormat;
    }

    public final String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public final int getDateFormat() {
        return this.dateFormat;
    }

    public final char getDateFormatSeparator() {
        return this.dateFormatSeparator;
    }

    public final String getDateMask(int dateType, int dateFormat, char separator, boolean showCentury, String timeFormat) {
        String mask = null;
        switch (dateType) {
            case 1: 
            case 2: {
                String year = "yy";
                if (showCentury) {
                    year = year + "yy";
                }
                switch (dateFormat) {
                    case 0: {
                        mask = year + separator + "MM" + separator + "dd";
                        break;
                    }
                    case 1: {
                        mask = "dd" + separator + "MM" + separator + year;
                        break;
                    }
                    case 2: {
                        mask = "MM" + separator + "dd" + separator + year;
                        break;
                    }
                    case 3: {
                        mask = year + separator + "dd" + separator + "MM";
                    }
                }
                if (dateType != 2) break;
                mask = mask + " " + timeFormat;
                break;
            }
            case 3: {
                mask = timeFormat;
            }
        }
        return mask;
    }

    public final String getDateMask(int dateType) {
        return this.getDateMask(dateType, this.dateFormat, this.dateFormatSeparator, this.showCenturyInDateFormat, this.timeFormat);
    }

    public final char getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public final Enumeration getEntries() {
        return this.dictionary.keys();
    }

    public final char getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public final String getLanguageId() {
        return this.languageId;
    }

    public final String getResource(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        if (this.dictionary.containsKey(text)) {
            return this.dictionary.getProperty(text);
        }
        if (this.dictionary.size() > 0 && this.showResourceNotFoundWarning) {
            System.err.println("The resource '" + text + "' is not defined.");
        }
        return text;
    }

    public final String getTimeFormat() {
        return this.timeFormat;
    }

    public final boolean isShowCenturyInDateFormat() {
        return this.showCenturyInDateFormat;
    }
}

