/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.java;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InputFilter
implements Serializable {
    public static final String EQ = "=";
    public static final String GE = ">=";
    public static final String GT = ">";
    public static final String IS_NOT_NULL = "IS NOT NULL";
    public static final String IS_NULL = "IS NULL";
    public static final String LE = "<=";
    public static final String LT = "<";
    public static final String NEQ = "<>";
    private HashMap filterValues;
    private HashMap operators = new HashMap();

    public InputFilter() {
        this.filterValues = new HashMap();
    }

    public final void addEqualsFilter(String columnName, Object value) {
        ArrayList<String> ops = (ArrayList<String>)this.operators.get(columnName);
        ArrayList<Object> vals = (ArrayList<Object>)this.filterValues.get(columnName);
        if (ops == null) {
            ops = new ArrayList<String>();
            vals = new ArrayList<Object>();
            this.operators.put(columnName, ops);
            this.filterValues.put(columnName, vals);
        }
        ops.add(EQ);
        vals.add(value);
    }

    public final void addGreaterOrEqualsToFilter(String columnName, Object value) {
        ArrayList<String> ops = (ArrayList<String>)this.operators.get(columnName);
        ArrayList<Object> vals = (ArrayList<Object>)this.filterValues.get(columnName);
        if (ops == null) {
            ops = new ArrayList<String>();
            vals = new ArrayList<Object>();
            this.operators.put(columnName, ops);
            this.filterValues.put(columnName, vals);
        }
        ops.add(GE);
        vals.add(value);
    }

    public final void addGreaterThanFilter(String columnName, Object value) {
        ArrayList<String> ops = (ArrayList<String>)this.operators.get(columnName);
        ArrayList<Object> vals = (ArrayList<Object>)this.filterValues.get(columnName);
        if (ops == null) {
            ops = new ArrayList<String>();
            vals = new ArrayList<Object>();
            this.operators.put(columnName, ops);
            this.filterValues.put(columnName, vals);
        }
        ops.add(GT);
        vals.add(value);
    }

    public final void addIsNotNullFilter(String columnName, Object value) {
        ArrayList<String> ops = (ArrayList<String>)this.operators.get(columnName);
        ArrayList<Object> vals = (ArrayList<Object>)this.filterValues.get(columnName);
        if (ops == null) {
            ops = new ArrayList<String>();
            vals = new ArrayList<Object>();
            this.operators.put(columnName, ops);
            this.filterValues.put(columnName, vals);
        }
        ops.add(IS_NOT_NULL);
        vals.add(value);
    }

    public final void addIsNullFilter(String columnName, Object value) {
        ArrayList<String> ops = (ArrayList<String>)this.operators.get(columnName);
        ArrayList<Object> vals = (ArrayList<Object>)this.filterValues.get(columnName);
        if (ops == null) {
            ops = new ArrayList<String>();
            vals = new ArrayList<Object>();
            this.operators.put(columnName, ops);
            this.filterValues.put(columnName, vals);
        }
        ops.add(IS_NULL);
        vals.add(value);
    }

    public final void addLessOrEqualsToFilter(String columnName, Object value) {
        ArrayList<String> ops = (ArrayList<String>)this.operators.get(columnName);
        ArrayList<Object> vals = (ArrayList<Object>)this.filterValues.get(columnName);
        if (ops == null) {
            ops = new ArrayList<String>();
            vals = new ArrayList<Object>();
            this.operators.put(columnName, ops);
            this.filterValues.put(columnName, vals);
        }
        ops.add(LE);
        vals.add(value);
    }

    public final void addLessThanFilter(String columnName, Object value) {
        ArrayList<String> ops = (ArrayList<String>)this.operators.get(columnName);
        ArrayList<Object> vals = (ArrayList<Object>)this.filterValues.get(columnName);
        if (ops == null) {
            ops = new ArrayList<String>();
            vals = new ArrayList<Object>();
            this.operators.put(columnName, ops);
            this.filterValues.put(columnName, vals);
        }
        ops.add(LT);
        vals.add(value);
    }

    public final void addNotEqualsFilter(String columnName, Object value) {
        ArrayList<String> ops = (ArrayList<String>)this.operators.get(columnName);
        ArrayList<Object> vals = (ArrayList<Object>)this.filterValues.get(columnName);
        if (ops == null) {
            ops = new ArrayList<String>();
            vals = new ArrayList<Object>();
            this.operators.put(columnName, ops);
            this.filterValues.put(columnName, vals);
        }
        ops.add(NEQ);
        vals.add(value);
    }

    public final Iterator getFilteredColumnNames() {
        return this.operators.keySet().iterator();
    }

    public final String getWhereClause(Map attributesMap, ArrayList bindVariables) {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.getFilteredColumnNames();
        String columnName = null;
        String dbColumnName = null;
        ArrayList ops = null;
        ArrayList vals = null;
        while (it.hasNext()) {
            columnName = it.next().toString();
            dbColumnName = (String)attributesMap.get(columnName);
            if (dbColumnName == null) continue;
            ops = (ArrayList)this.operators.get(columnName);
            vals = (ArrayList)this.filterValues.get(columnName);
            if (ops == null) continue;
            int i = 0;
            while (i < ops.size()) {
                sb.append(dbColumnName).append(" ").append(ops.get(i));
                if (!ops.get(i).equals(IS_NULL) && !ops.get(i).equals(IS_NOT_NULL)) {
                    sb.append(" ? AND ");
                    bindVariables.add(vals.get(i));
                }
                ++i;
            }
        }
        if (sb.length() > 0) {
            return "(" + sb.toString().substring(0, sb.toString().length() - 4) + ")";
        }
        return "";
    }

    public final void removeFilters(String columnName) {
        this.operators.remove(columnName);
        this.filterValues.remove(columnName);
    }

    public final boolean skipRow(String columnName, Object value) {
        ArrayList ops = (ArrayList)this.operators.get(columnName);
        if (ops == null) {
            return false;
        }
        ArrayList vals = (ArrayList)this.filterValues.get(columnName);
        int i = 0;
        while (i < ops.size()) {
            if (ops.get(i).equals(EQ)) {
                if (value == null && vals.get(i) == null) {
                    return false;
                }
                if (value != null && vals.get(i) == null) {
                    return true;
                }
                if (value == null && vals.get(i) != null) {
                    return true;
                }
                return !value.equals(vals.get(i));
            }
            if (ops.get(i).equals(NEQ)) {
                if (value == null && vals.get(i) == null) {
                    return true;
                }
                if (value != null && vals.get(i) == null) {
                    return false;
                }
                if (value == null && vals.get(i) != null) {
                    return false;
                }
                return value.equals(vals.get(i));
            }
            if (ops.get(i).equals(IS_NULL)) {
                return value != null;
            }
            if (ops.get(i).equals(IS_NOT_NULL)) {
                return value == null;
            }
            if (ops.get(i).equals(LT)) {
                if (value == null) {
                    return true;
                }
                if (value instanceof Number) {
                    return ((Number)value).doubleValue() >= ((Number)vals.get(i)).doubleValue();
                }
                if (value instanceof Date) {
                    return ((Date)value).compareTo((Date)vals.get(i)) >= 0;
                }
                return value.toString().compareTo(vals.get(i).toString()) >= 0;
            }
            if (ops.get(i).equals(LE)) {
                if (value == null) {
                    return true;
                }
                if (value instanceof Number) {
                    return ((Number)value).doubleValue() > ((Number)vals.get(i)).doubleValue();
                }
                if (value instanceof Date) {
                    return ((Date)value).compareTo((Date)vals.get(i)) > 0;
                }
                return value.toString().compareTo(vals.get(i).toString()) > 0;
            }
            if (ops.get(i).equals(GT)) {
                if (value == null) {
                    return true;
                }
                if (value instanceof Number) {
                    return ((Number)value).doubleValue() <= ((Number)vals.get(i)).doubleValue();
                }
                if (value instanceof Date) {
                    return ((Date)value).compareTo((Date)vals.get(i)) <= 0;
                }
                return value.toString().compareTo(vals.get(i).toString()) <= 0;
            }
            if (ops.get(i).equals(GE)) {
                if (value == null) {
                    return true;
                }
                if (value instanceof Number) {
                    return ((Number)value).doubleValue() < ((Number)vals.get(i)).doubleValue();
                }
                if (value instanceof Date) {
                    return ((Date)value).compareTo((Date)vals.get(i)) < 0;
                }
                return value.toString().compareTo(vals.get(i).toString()) < 0;
            }
            ++i;
        }
        return false;
    }
}

