/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.tablemodelreaders.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openswing.swing.pivottable.java.InputFilter;
import org.openswing.swing.pivottable.tablemodelreaders.server.Reader;

public class SQLReader
implements Reader {
    private String[] attributeNames = null;
    private Map attributesMap = null;
    private ArrayList bindVariables = null;
    private Connection conn = null;
    private HashMap indexes = new HashMap();
    private PreparedStatement pstmt = null;
    private Map reverseAttributesMap = new HashMap();
    private ResultSet rset = null;
    private String sql = null;

    public SQLReader(String sql, Connection conn, Map attributesMap) {
        this(sql, new ArrayList(), conn, attributesMap);
    }

    public SQLReader(String sql, ArrayList bindVariables, Connection conn, Map attributesMap) {
        this.sql = sql;
        this.bindVariables = bindVariables;
        this.conn = conn;
        this.attributesMap = attributesMap;
        Iterator it = attributesMap.keySet().iterator();
        String colName = null;
        while (it.hasNext()) {
            colName = it.next().toString();
            this.reverseAttributesMap.put(attributesMap.get(colName), colName);
        }
    }

    public final int getColumnCount() {
        return this.attributeNames.length;
    }

    public final String getColumnName(int index) {
        return this.attributeNames[index];
    }

    public final Object getValueAt(int col) {
        try {
            return this.rset.getObject(col + 1);
        }
        catch (SQLException ex) {
            return null;
        }
    }

    public final boolean initializeScrolling(InputFilter inputFilter) {
        try {
            ArrayList additionalBindVars = new ArrayList();
            String script = this.sql;
            String whereClause = inputFilter.getWhereClause(this.attributesMap, additionalBindVars);
            if (whereClause.length() > 0) {
                int w = this.sql.replace('\n', ' ').toLowerCase().indexOf(" where ");
                int o = this.sql.replace('\n', ' ').toLowerCase().indexOf(" order by ");
                if (w == -1 && o == -1) {
                    script = this.sql + " WHERE " + whereClause;
                } else if (w == -1 && o != -1) {
                    script = this.sql.substring(0, o) + " WHERE " + whereClause + this.sql.substring(o);
                } else if (w != -1 && o != -1) {
                    script = this.sql.substring(0, o) + " AND " + whereClause + this.sql.substring(o);
                }
            }
            this.pstmt = this.conn.prepareStatement(script);
            int i = 0;
            while (i < this.bindVariables.size()) {
                this.pstmt.setObject(i + 1, this.bindVariables.get(i));
                ++i;
            }
            int i2 = 0;
            while (i2 < additionalBindVars.size()) {
                this.pstmt.setObject(this.bindVariables.size() + i2 + 1, additionalBindVars.get(i2));
                ++i2;
            }
            this.rset = this.pstmt.executeQuery();
            String colName = null;
            this.attributeNames = new String[this.rset.getMetaData().getColumnCount()];
            int i3 = 0;
            while (i3 < this.rset.getMetaData().getColumnCount()) {
                this.attributeNames[i3] = colName = (String)this.reverseAttributesMap.get(this.rset.getMetaData().getColumnName(i3 + 1));
                this.indexes.put(colName, new Integer(i3));
                ++i3;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean nextRow(InputFilter inputFilter) {
        boolean moreRows;
        try {
            moreRows = this.rset.next();
        }
        catch (Exception ex) {
            moreRows = false;
        }
        if (!moreRows) {
            try {
                this.rset.close();
            }
            catch (Exception ex1) {
                // empty catch block
            }
            try {
                this.pstmt.close();
            }
            catch (Exception ex1) {
            }
        }
        return moreRows;
    }
}

