/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.server;

import java.sql.Connection;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.openswing.swing.server.ConnectionSource;
import org.openswing.swing.server.NoConnectionSource;

public class ConnectionManager {
    private static ConnectionSource connectionSource = new NoConnectionSource();

    public static Connection getConnection(ServletContext context) throws Exception {
        return connectionSource.getConnection(context);
    }

    public static void initConnectionSource(HttpServlet servlet, String connectionSourceClassName) {
        try {
            connectionSource = (ConnectionSource)Class.forName(connectionSourceClassName).newInstance();
            if (!connectionSource.initPooler(servlet)) {
                connectionSource = null;
            }
        }
        catch (Throwable ex) {
            connectionSource = null;
            ex.printStackTrace();
            servlet.getServletContext().log("Error while creating connection source '" + connectionSourceClassName + "'", ex);
        }
    }

    public static boolean isConnectionSourceCreated() {
        return connectionSource != null;
    }

    public static void releaseConnection(Connection conn, ServletContext context) {
        connectionSource.releaseConnection(conn, context);
    }
}

