/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openswing.swing.internationalization.server.ServerResourcesFactory;
import org.openswing.swing.logger.server.Logger;
import org.openswing.swing.logger.server.LoggerMethods;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.TextResponse;
import org.openswing.swing.message.send.java.Command;
import org.openswing.swing.server.Action;
import org.openswing.swing.server.ActionsCollection;
import org.openswing.swing.server.ConnectionManager;
import org.openswing.swing.server.ControllerCallbacks;
import org.openswing.swing.server.GenericAction;
import org.openswing.swing.server.SessionIdGenerator;
import org.openswing.swing.server.UserSessionParameters;
import org.openswing.swing.util.server.DefaultObjectReceiver;
import org.openswing.swing.util.server.ObjectReceiver;

public class Controller
extends HttpServlet {
    public static final String ACTION_CLASSES = "ACTION_CLASSES";
    public static final String CONTROLLER_CALLBACKS = "CONTROLLER_CALLBACKS";
    public static final String RESOURCES_FACTORY = "RESOURCES_FACTORY";
    public static final String SESSION_IDS = "SESSION_IDS";
    public static final String SESSION_ID_GENERATOR = "SESSION_ID_GENERATOR";
    public static final String USER_SESSIONS = "USER_SESSIONS";
    private ActionsCollection actions = null;
    private ObjectReceiver objectReceiver = new DefaultObjectReceiver();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String sessionId = request.getParameter("sessionId");
            String docId = request.getParameter("docId");
            HashSet authenticatedIds = (HashSet)this.getServletContext().getAttribute(SESSION_IDS);
            if (authenticatedIds == null) {
                authenticatedIds = new HashSet();
                this.getServletContext().setAttribute(SESSION_IDS, authenticatedIds);
            }
            if (sessionId == null) {
                Logger.error("NONAME", ((Object)((Object)this)).getClass().getName(), "doGet", "Session identifier not specified", null);
                PrintWriter pw = response.getWriter();
                pw.println("<html><head><title>ERROR</title></html>");
                pw.println("<body>Access denied: you must specify a session identifier</body>");
                pw.println("</html>");
                pw.close();
            } else if (authenticatedIds.contains(sessionId)) {
                if (docId == null) {
                    Logger.error("NONAME", ((Object)((Object)this)).getClass().getName(), "doGet", "Document identifier not specified", null);
                    PrintWriter pw = response.getWriter();
                    pw.println("<html><head><title>ERROR</title></html>");
                    pw.println("<body>Document not available: you must specify a document identifier</body>");
                    pw.println("</html>");
                    pw.close();
                } else {
                    Object doc = this.getServletContext().getAttribute(docId);
                    new TimeoutDocIdThread(docId);
                    if (doc == null) {
                        Logger.error("NONAME", ((Object)((Object)this)).getClass().getName(), "doGet", "Document identifier not valid", null);
                        PrintWriter pw = response.getWriter();
                        pw.println("<html><head><title>ERROR</title></html>");
                        pw.println("<body>Document not available: you must specify a valid document identifier</body>");
                        pw.println("</html>");
                        pw.close();
                    } else {
                        if (docId.endsWith(".xls")) {
                            response.setContentType("application/vnd.ms-excel");
                        } else if (docId.endsWith(".xls") || docId.endsWith(".csv")) {
                            response.setContentType("application/vnd.ms-excel");
                        } else if (docId.endsWith(".pdf")) {
                            response.setContentType("application/pdf");
                        } else if (docId.endsWith(".rtf")) {
                            response.setContentType("application/rtf");
                        } else if (docId.endsWith(".html")) {
                            response.setContentType("text/html");
                        } else if (docId.endsWith(".xml")) {
                            response.setContentType("text/xml");
                        }
                        ServletOutputStream out = response.getOutputStream();
                        out.write((byte[])doc);
                        out.close();
                    }
                }
            } else {
                Logger.error("NONAME", ((Object)((Object)this)).getClass().getName(), "doGet", "Session identifier not valid: '" + sessionId + "'", null);
                PrintWriter pw = response.getWriter();
                pw.println("<html><head><title>ERROR</title></html>");
                pw.println("<body>Access denied: you must specify a valid session identifier</body>");
                pw.println("</html>");
                pw.close();
            }
        }
        catch (Throwable ex) {
            Logger.error("NONAME", ((Object)((Object)this)).getClass().getName(), "doGet", "Error on receiving a GET request", ex);
            try {
                PrintWriter pw = response.getWriter();
                pw.println("<html><head><title>ERROR</title></html>");
                pw.println("<body>An error occours on processing the request:<br>" + ex.toString() + "</body>");
                pw.println("</html>");
                pw.close();
            }
            catch (IOException ex1) {
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Hashtable userSessions;
        Response answer = null;
        HashSet authenticatedIds = (HashSet)this.getServletContext().getAttribute(SESSION_IDS);
        if (authenticatedIds == null) {
            authenticatedIds = new HashSet();
            this.getServletContext().setAttribute(SESSION_IDS, authenticatedIds);
        }
        if ((userSessions = (Hashtable)this.getServletContext().getAttribute(USER_SESSIONS)) == null) {
            userSessions = new Hashtable();
            this.getServletContext().setAttribute(USER_SESSIONS, userSessions);
        }
        ServerResourcesFactory factory = (ServerResourcesFactory)this.getServletContext().getAttribute(RESOURCES_FACTORY);
        try {
            Command command = this.objectReceiver.getObjectFromRequest(request);
            if (!ConnectionManager.isConnectionSourceCreated() || command.getMethodName().equals("databaseAlreadyExixts")) {
                Object action = this.actions.get(command.getMethodName());
                if (action != null && action instanceof Action) {
                    answer = ((Action)action).executeCommand(command.getInputParam(), null, request, response, request.getSession(true), this.getServletContext());
                } else if (action != null && action instanceof GenericAction) {
                    answer = this.processGenericAction(request, response, factory, userSessions, action.getClass(), command);
                }
            } else if (command.getSessionId() == null && !command.getMethodName().equals("login")) {
                answer = new ErrorResponse("Cannot process the request: authentication needed!");
            } else if (command.getSessionId() != null && !authenticatedIds.contains(command.getSessionId())) {
                answer = new ErrorResponse("Cannot process the request: authentication needed!");
            } else if (command.getSessionId() != null && authenticatedIds.contains(command.getSessionId()) && command.getMethodName().equals("logout")) {
                authenticatedIds.remove(command.getSessionId());
                userSessions.remove(command.getSessionId());
                answer = new TextResponse(factory.getResources(((UserSessionParameters)userSessions.get(command.getSessionId())).getLanguageId()).getResource("User disconnected"));
            } else {
                Object action = this.actions.get(command.getMethodName());
                if (action != null && action instanceof Action) {
                    answer = ((Action)action).executeCommand(command.getInputParam(), command.getSessionId() == null ? null : (UserSessionParameters)userSessions.get(command.getSessionId()), request, response, request.getSession(true), this.getServletContext());
                } else if (action != null && action instanceof GenericAction) {
                    answer = this.processGenericAction(request, response, factory, userSessions, action.getClass(), command);
                } else {
                    String msg = "Client request not supported";
                    if (command.getSessionId() != null) {
                        msg = factory.getResources(((UserSessionParameters)userSessions.get(command.getSessionId())).getLanguageId()).getResource(msg);
                    }
                    answer = new ErrorResponse(msg + ": '" + command.getMethodName() + "'");
                }
            }
        }
        catch (Throwable ex) {
            this.getServletContext().log("Error on processing client request", ex);
            try {
                this.objectReceiver.setObjectToResponse(response, new ErrorResponse(ex.getMessage()));
            }
            catch (Exception exx1) {
                this.getServletContext().log("Error on processing client request", (Throwable)exx1);
                response.getOutputStream().close();
            }
            return;
        }
        try {
            this.objectReceiver.setObjectToResponse(response, answer);
        }
        catch (Exception ex1) {
            this.getServletContext().log("Error on processing client request", (Throwable)ex1);
            response.getOutputStream().close();
            return;
        }
    }

    public void init() throws ServletException {
        String msg;
        String msg2;
        boolean logOk = false;
        try {
            String logger = super.getInitParameter("logger");
            if (logger != null) {
                LoggerMethods loggerObject = (LoggerMethods)Class.forName(logger).newInstance();
                Logger.init(loggerObject, 0);
            }
            Logger.info("NONAME", ((Object)((Object)this)).getClass().getName(), "init", "Initialized log manager");
            logOk = true;
        }
        catch (Throwable ex) {
            this.getServletContext().log("Error on initializing logger class", ex);
        }
        try {
            String actionClasses = super.getInitParameter("actionClasses");
            if (actionClasses != null) {
                this.actions = (ActionsCollection)Class.forName(actionClasses).newInstance();
                this.getServletContext().setAttribute(ACTION_CLASSES, (Object)this.actions);
            }
        }
        catch (Throwable ex) {
            msg2 = "Error on initializing action classes collection";
            if (logOk) {
                Logger.error("NONAME", ((Object)((Object)this)).getClass().getName(), "init", msg2, ex);
            }
            this.getServletContext().log(msg2, ex);
        }
        try {
            String connectionSource = super.getInitParameter("connectionSource");
            if (connectionSource != null) {
                ConnectionManager.initConnectionSource(this, connectionSource);
            }
        }
        catch (Throwable ex) {
            msg2 = "Error on initializing connection source";
            if (logOk) {
                Logger.error("NONAME", ((Object)((Object)this)).getClass().getName(), "init", msg2, ex);
            }
            this.getServletContext().log(msg2, ex);
        }
        try {
            String resourceFactory = super.getInitParameter("resourceFactory");
            if (resourceFactory != null) {
                ServerResourcesFactory factory = (ServerResourcesFactory)Class.forName(resourceFactory).newInstance();
                factory.init(this.getServletContext());
                this.getServletContext().setAttribute(RESOURCES_FACTORY, (Object)factory);
            }
        }
        catch (Throwable ex) {
            msg2 = "Error on initializing internationalization settings";
            if (logOk) {
                Logger.error("NONAME", ((Object)((Object)this)).getClass().getName(), "init", msg2, ex);
            }
            this.getServletContext().log(msg2, ex);
        }
        try {
            String sessionIdGenerator = super.getInitParameter("sessionIdGenerator");
            if (sessionIdGenerator != null) {
                SessionIdGenerator generator = (SessionIdGenerator)Class.forName(sessionIdGenerator).newInstance();
                this.getServletContext().setAttribute(SESSION_ID_GENERATOR, (Object)generator);
            }
        }
        catch (Throwable ex) {
            msg2 = "Error on initializing session identifiers generator";
            if (logOk) {
                Logger.error("NONAME", ((Object)((Object)this)).getClass().getName(), "init", msg2, ex);
            }
            this.getServletContext().log(msg2, ex);
        }
        ControllerCallbacks controllerCallbacksObj = null;
        try {
            String controllerCallbacks = super.getInitParameter("controllerCallbacks");
            if (controllerCallbacks != null) {
                controllerCallbacksObj = (ControllerCallbacks)Class.forName(controllerCallbacks).newInstance();
                this.getServletContext().setAttribute(CONTROLLER_CALLBACKS, (Object)controllerCallbacksObj);
            }
        }
        catch (Throwable ex) {
            msg = "Error on initializing controller callbacks class";
            if (logOk) {
                Logger.error("NONAME", ((Object)((Object)this)).getClass().getName(), "init", msg, ex);
            }
            this.getServletContext().log(msg, ex);
        }
        if (controllerCallbacksObj != null) {
            controllerCallbacksObj.afterInit(super.getServletContext());
        }
        try {
            String objectsReceiverClassName = super.getInitParameter("objectsReceiver");
            if (objectsReceiverClassName != null) {
                this.objectReceiver = (ObjectReceiver)Class.forName(objectsReceiverClassName).newInstance();
            }
        }
        catch (Throwable ex) {
            msg = "Error on initializing objects receiver class";
            if (logOk) {
                Logger.error("NONAME", ((Object)((Object)this)).getClass().getName(), "init", msg, ex);
            }
            this.getServletContext().log(msg, ex);
        }
        if (logOk) {
            Logger.info("NONAME", ((Object)((Object)this)).getClass().getName(), "init", "Servlet Initialization completed.");
        }
    }

    private Response processGenericAction(HttpServletRequest request, HttpServletResponse response, ServerResourcesFactory factory, Hashtable userSessions, Class genericAction, Command command) throws Throwable {
        GenericAction action = (GenericAction)genericAction.newInstance();
        action.context = this.getServletContext();
        action.request = request;
        action.response = response;
        action.userSession = request.getSession(true);
        action.userSessionPars = command.getSessionId() == null ? null : (UserSessionParameters)userSessions.get(command.getSessionId());
        Object[] args = null;
        args = command.getInputParam() instanceof Object[] ? (Object[])command.getInputParam() : new Object[]{command.getInputParam()};
        Class[] argsType = new Class[args.length];
        boolean nullValue = false;
        int i = 0;
        while (i < args.length) {
            if (args[i] == null) {
                nullValue = true;
                break;
            }
            argsType[i] = args[i].getClass();
            ++i;
        }
        if (!nullValue) {
            try {
                return (Response)genericAction.getMethod(command.getMethodName(), argsType).invoke((Object)action, args);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        Method[] mm = genericAction.getMethods();
        ArrayList<Method> aux = new ArrayList<Method>();
        int i2 = 0;
        while (i2 < mm.length) {
            if (mm[i2].getName().equals(command.getMethodName()) && mm[i2].getParameterTypes().length == args.length) {
                aux.add(mm[i2]);
            }
            ++i2;
        }
        Method m = null;
        boolean methodFound = false;
        int i3 = 0;
        while (i3 < aux.size()) {
            m = (Method)aux.get(i3);
            methodFound = true;
            int j = 0;
            while (j < args.length) {
                if (args[j] != null && !m.getParameterTypes()[j].isAssignableFrom(args[j].getClass())) {
                    methodFound = false;
                    break;
                }
                ++j;
            }
            if (methodFound) {
                return (Response)m.invoke((Object)action, args);
            }
            ++i3;
        }
        String msg = "Client request not supported";
        if (command.getSessionId() != null) {
            msg = factory.getResources(((UserSessionParameters)userSessions.get(command.getSessionId())).getLanguageId()).getResource(msg);
        }
        return new ErrorResponse(msg + ": '" + command.getMethodName() + "'");
    }

    class TimeoutDocIdThread
    extends Thread {
        private String docId;

        public TimeoutDocIdThread(String docId) {
            this.docId = docId;
            this.start();
        }

        public void run() {
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            try {
                Controller.this.getServletContext().removeAttribute(this.docId);
            }
            catch (Exception ex1) {
            }
        }
    }
}

