/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.server;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.sql.DataSource;
import org.openswing.swing.server.ConnectionSource;

public class DataSourceConnection
implements ConnectionSource {
    private DataSource dataSource = null;

    public Connection getConnection(ServletContext context) throws Exception {
        Connection conn = this.dataSource.getConnection();
        try {
            conn.setTransactionIsolation(2);
        }
        catch (Exception ex) {
            // empty catch block
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public boolean initPooler(HttpServlet servlet) {
        try {
            InitialContext ic = new InitialContext();
            Context envCtx = (Context)ic.lookup("java:comp/env");
            this.dataSource = (DataSource)envCtx.lookup("jdbc/" + servlet.getInitParameter("dataSourceName"));
            return this.dataSource != null;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            servlet.getServletContext().log("Error while creating data source", ex);
            return false;
        }
    }

    public void releaseConnection(Connection conn, ServletContext context) {
        try {
            conn.rollback();
            conn.close();
        }
        catch (SQLException ex) {
            context.log("Error while releasing the database connection", (Throwable)ex);
        }
    }
}

