/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.permissions.database.server;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.openswing.swing.table.permissions.database.server.DbConnectionSource;
import org.openswing.swing.table.permissions.database.server.DbDigestDescriptor;
import org.openswing.swing.table.permissions.database.server.DbPermissionsDescriptor;
import org.openswing.swing.table.permissions.java.GridPermissions;
import org.openswing.swing.table.permissions.java.GridPermissionsManager;

public class DbGridPermissionsManager
extends GridPermissionsManager {
    private DbConnectionSource dbConnectionSource = null;
    private DbDigestDescriptor dbDigestDescriptor = null;
    private DbPermissionsDescriptor dbPermissionsDescriptor = null;

    public DbGridPermissionsManager(DbConnectionSource dbConnectionSource, DbDigestDescriptor dbDigestDescriptor, DbPermissionsDescriptor dbPermissionsDescriptor) {
        this.dbConnectionSource = dbConnectionSource;
        this.dbDigestDescriptor = dbDigestDescriptor;
        this.dbPermissionsDescriptor = dbPermissionsDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllGridPermissionsPerFunctionId(String functionId) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            Hashtable h = this.dbPermissionsDescriptor.deleteAllGridPermissions(functionId);
            String where = " and ";
            Enumeration en = h.keys();
            String field = null;
            ArrayList whereValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                where = where + field + "=? and ";
                whereValues.add(h.get(field));
            }
            where = where.length() > 5 ? where.substring(0, where.length() - 4) : "";
            pstmt = conn.prepareStatement("delete from " + this.dbPermissionsDescriptor.getGridPermissionsTableName() + " " + "where " + this.dbPermissionsDescriptor.getFunctionIdFieldNameInGridPermissionsTable() + "=? " + where);
            pstmt.setString(1, functionId);
            int i = 0;
            while (i < whereValues.size()) {
                pstmt.setObject(i + 2, whereValues.get(i));
                ++i;
            }
            pstmt.execute();
            String sql = "delete from " + this.dbPermissionsDescriptor.getGridPermissionsDefaultsTableName() + " " + "where " + this.dbPermissionsDescriptor.getFunctionIdFieldNameInDefaultsTableName() + "=? ";
            int i2 = 0;
            while (i2 < this.dbPermissionsDescriptor.getOtherFieldNamesInDefaultsTableName().length) {
                sql = sql + " and " + this.dbPermissionsDescriptor.getOtherFieldNamesInDefaultsTableName()[i2] + "=? ";
                ++i2;
            }
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, functionId);
            int i3 = 0;
            while (i3 < whereValues.size()) {
                pstmt.setObject(i3 + 2, this.dbPermissionsDescriptor.getOtherFieldValuesInDefaultsTableName()[i3]);
                ++i3;
            }
            pstmt.execute();
            conn.commit();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastGridDigest(String functionId) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            pstmt = conn.prepareStatement("select " + this.dbDigestDescriptor.getDigestFieldName() + " " + "from " + this.dbDigestDescriptor.getDigestTableName() + " " + "where " + this.dbDigestDescriptor.getFunctionIdFieldName() + "=? ");
            pstmt.setString(1, functionId);
            rset = pstmt.executeQuery();
            if (rset.next()) {
                String string = rset.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridPermissions getUserGridPermissions(String functionId, ArrayList userRoles, String[] columnAttributes, boolean[] columnsVisibility, boolean[] columnEditableInInsert, boolean[] columnsEditableInEdit, boolean[] columnsMandatory) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            String sql = "select " + this.dbPermissionsDescriptor.getColumnsAttributeFieldNameInGridPermissionsTable() + "," + this.dbPermissionsDescriptor.getEditableColumnsInInsertFieldNameInGridPermissionsTable() + "," + this.dbPermissionsDescriptor.getEditableColumnsInEditFieldNameInGridPermissionsTable() + "," + this.dbPermissionsDescriptor.getColumnsMandatoryFieldNameInGridPermissionsTable() + "," + this.dbPermissionsDescriptor.getColumnsVisibilityFieldNameInGridPermissionsTable() + " " + "from " + this.dbPermissionsDescriptor.getGridPermissionsTableName() + " " + "where " + this.dbPermissionsDescriptor.getFunctionIdFieldNameInGridPermissionsTable() + "=? ";
            int j = 0;
            while (j < userRoles.size()) {
                sql = sql + " and (";
                int i = 0;
                while (i < this.dbPermissionsDescriptor.getRoleIdFieldNamesInGridPermissionsTable().length) {
                    sql = sql + this.dbPermissionsDescriptor.getRoleIdFieldNamesInGridPermissionsTable()[i] + "=? or ";
                    ++i;
                }
                sql = sql.substring(0, sql.length() - 3);
                sql = sql + ") ";
                ++j;
            }
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, functionId);
            Object[] roleId = null;
            int count = 2;
            int j2 = 0;
            while (j2 < userRoles.size()) {
                roleId = (Object[])userRoles.get(j2);
                int i = 0;
                while (i < roleId.length) {
                    pstmt.setObject(count, roleId[i]);
                    ++count;
                    ++i;
                }
                ++j2;
            }
            rset = pstmt.executeQuery();
            GridPermissions permissions = new GridPermissions(functionId, this.getUsername(), (String[])columnAttributes.clone(), (boolean[])columnsVisibility.clone(), (boolean[])columnEditableInInsert.clone(), (boolean[])columnsEditableInEdit.clone(), (boolean[])columnsMandatory.clone());
            String[] aux = null;
            while (rset.next()) {
                aux = rset.getString(1).split(",");
                int i = 0;
                while (i < aux.length) {
                    permissions.getColumnsAttribute()[i] = aux[i];
                    ++i;
                }
                aux = rset.getString(2).split(",");
                int i2 = 0;
                while (i2 < aux.length) {
                    permissions.getColumnsEditabilityInInsert()[i2] = permissions.getColumnsEditabilityInInsert()[i2] && aux[i2].equals("true");
                    ++i2;
                }
                aux = rset.getString(3).split(",");
                int i3 = 0;
                while (i3 < aux.length) {
                    permissions.getColumnsEditabilityInEdit()[i3] = permissions.getColumnsEditabilityInEdit()[i3] && aux[i3].equals("true");
                    ++i3;
                }
                aux = rset.getString(4).split(",");
                int i4 = 0;
                while (i4 < aux.length) {
                    permissions.getColumnsMandatory()[i4] = permissions.getColumnsMandatory()[i4] || aux[i4].equals("true");
                    ++i4;
                }
                aux = rset.getString(5).split(",");
                int i5 = 0;
                while (i5 < aux.length) {
                    permissions.getColumnsVisibility()[i5] = aux[i5].equals("true");
                    ++i5;
                }
            }
            GridPermissions gridPermissions = permissions;
            return gridPermissions;
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList getUserRoles() throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            String roleIdFields = "";
            int i = 0;
            while (i < this.dbPermissionsDescriptor.getRoleIdFieldNamesInUserRolesTable().length) {
                roleIdFields = roleIdFields + this.dbPermissionsDescriptor.getRoleIdFieldNamesInUserRolesTable()[i] + ",";
                ++i;
            }
            roleIdFields = roleIdFields.substring(0, roleIdFields.length() - 1);
            String sql = "select " + roleIdFields + " " + "from " + this.dbPermissionsDescriptor.getUserRolesTableName() + " " + "where " + this.dbPermissionsDescriptor.getUsernameFieldNameInUserRolesTable() + "=? ";
            int i2 = 0;
            while (i2 < this.dbPermissionsDescriptor.getRolesWhereFieldNames().length) {
                sql = sql + " and " + this.dbPermissionsDescriptor.getRolesWhereFieldNames()[i2] + "=? ";
                ++i2;
            }
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, this.getUsername());
            int i3 = 0;
            while (i3 < this.dbPermissionsDescriptor.getRolesWhereValues().length) {
                pstmt.setObject(i3 + 2, this.dbPermissionsDescriptor.getRolesWhereValues()[i3]);
                ++i3;
            }
            rset = pstmt.executeQuery();
            ArrayList<Object[]> roleIds = new ArrayList<Object[]>();
            Object[] roleId = null;
            while (rset.next()) {
                roleId = new Object[rset.getMetaData().getColumnCount()];
                int i4 = 0;
                while (i4 < roleId.length) {
                    roleId[i4] = rset.getObject(i4 + 1);
                    ++i4;
                }
                roleIds.add(roleId);
            }
            ArrayList<Object[]> arrayList = roleIds;
            return arrayList;
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeGridDigest(String functionId, String gridDigest) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            Hashtable h1 = this.dbDigestDescriptor.storeGridDigestOnSetUpdate();
            Hashtable h2 = this.dbDigestDescriptor.storeGridDigestOnWhereUpdate();
            String where = " and ";
            Enumeration en = h2.keys();
            String field = null;
            ArrayList whereValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                where = where + field + "=? and ";
                whereValues.add(h2.get(field));
            }
            where = where.length() > 5 ? where.substring(0, where.length() - 4) : "";
            String set = ",";
            en = h1.keys();
            field = null;
            ArrayList setValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                set = set + field + "=?,";
                setValues.add(h1.get(field));
            }
            set = set.length() > 1 ? set.substring(0, set.length() - 1) : "";
            pstmt = conn.prepareStatement("update " + this.dbDigestDescriptor.getDigestTableName() + " " + "set " + this.dbDigestDescriptor.getDigestFieldName() + "=? " + set + " " + "where " + this.dbDigestDescriptor.getFunctionIdFieldName() + "=? " + where);
            pstmt.setString(1, gridDigest);
            pstmt.setString(2 + setValues.size(), functionId);
            int i = 0;
            while (i < setValues.size()) {
                pstmt.setObject(i + 2, setValues.get(i));
                ++i;
            }
            int i2 = 0;
            while (i2 < whereValues.size()) {
                pstmt.setObject(i2 + setValues.size() + 3, whereValues.get(i2));
                ++i2;
            }
            int num = pstmt.executeUpdate();
            if (num == 0) {
                Hashtable h = this.dbDigestDescriptor.storeGridDigestOnInsert();
                String ins = "";
                en = h.keys();
                field = null;
                String pkQuestions = "";
                ArrayList insValues = new ArrayList();
                while (en.hasMoreElements()) {
                    field = en.nextElement().toString();
                    pkQuestions = pkQuestions + "?,";
                    ins = ins + "," + field;
                    insValues.add(h.get(field));
                }
                pstmt = conn.prepareStatement("insert into " + this.dbDigestDescriptor.getDigestTableName() + "(" + this.dbDigestDescriptor.getDigestFieldName() + "," + this.dbDigestDescriptor.getFunctionIdFieldName() + ins + ") " + "values(" + pkQuestions + "?,?)");
                pstmt.setString(1, gridDigest);
                pstmt.setString(2, functionId);
                int i3 = 0;
                while (i3 < insValues.size()) {
                    pstmt.setObject(i3 + 3, insValues.get(i3));
                    ++i3;
                }
                pstmt.execute();
            }
            conn.commit();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    public void storeGridPermissionsDefaults(String functionId, String[] columnAttributes, boolean[] columnsVisibility, boolean[] columnEditableInInsert, boolean[] columnsEditableInEdit, boolean[] columnsMandatory) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            String sql = "update " + this.dbPermissionsDescriptor.getGridPermissionsDefaultsTableName() + " set " + this.dbPermissionsDescriptor.getColumnsAttributeFieldNameInDefaultsTableName() + "=? and " + this.dbPermissionsDescriptor.getColumnsMandatoryFieldNameInDefaultsTableName() + "=? and " + this.dbPermissionsDescriptor.getColumnsVisibilityFieldNameInDefaultsTableName() + "=? and " + this.dbPermissionsDescriptor.getEditableColumnsInEditFieldNameInDefaultsTableName() + "=? and " + this.dbPermissionsDescriptor.getEditableColumnsInInsertFieldNameInDefaultsTableName() + "=? where " + this.dbPermissionsDescriptor.getFunctionIdFieldNameInDefaultsTableName() + "=? ";
            int i = 0;
            while (i < this.dbPermissionsDescriptor.getOtherFieldNamesInDefaultsTableName().length) {
                sql = sql + " and " + this.dbPermissionsDescriptor.getOtherFieldNamesInDefaultsTableName()[i] + "=? ";
                ++i;
            }
            pstmt = conn.prepareStatement(sql);
            String aux = "";
            int i2 = 0;
            while (i2 < columnAttributes.length) {
                aux = aux + columnAttributes[i2] + ",";
                ++i2;
            }
            aux = aux.substring(0, aux.length() - 1);
            pstmt.setString(1, aux);
            aux = "";
            int i3 = 0;
            while (i3 < columnAttributes.length) {
                aux = aux + (columnsMandatory[i3] ? "true" : "false") + ",";
                ++i3;
            }
            aux = aux.substring(0, aux.length() - 1);
            pstmt.setString(2, aux);
            aux = "";
            int i4 = 0;
            while (i4 < columnAttributes.length) {
                aux = aux + (columnsVisibility[i4] ? "true" : "false") + ",";
                ++i4;
            }
            aux = aux.substring(0, aux.length() - 1);
            pstmt.setString(3, aux);
            aux = "";
            int i5 = 0;
            while (i5 < columnAttributes.length) {
                aux = aux + (columnsEditableInEdit[i5] ? "true" : "false") + ",";
                ++i5;
            }
            aux = aux.substring(0, aux.length() - 1);
            pstmt.setString(4, aux);
            aux = "";
            int i6 = 0;
            while (i6 < columnAttributes.length) {
                aux = aux + (columnEditableInInsert[i6] ? "true" : "false") + ",";
                ++i6;
            }
            aux = aux.substring(0, aux.length() - 1);
            pstmt.setString(5, aux);
            pstmt.setString(6, functionId);
            int i7 = 0;
            while (i7 < this.dbPermissionsDescriptor.getOtherFieldValuesInDefaultsTableName().length) {
                pstmt.setObject(i7 + 7, this.dbPermissionsDescriptor.getOtherFieldValuesInDefaultsTableName()[i7]);
                ++i7;
            }
            int num = pstmt.executeUpdate();
            if (num == 0) {
                sql = "insert into " + this.dbPermissionsDescriptor.getGridPermissionsDefaultsTableName() + "(" + this.dbPermissionsDescriptor.getColumnsAttributeFieldNameInDefaultsTableName() + "," + this.dbPermissionsDescriptor.getColumnsMandatoryFieldNameInDefaultsTableName() + "," + this.dbPermissionsDescriptor.getColumnsVisibilityFieldNameInDefaultsTableName() + "," + this.dbPermissionsDescriptor.getEditableColumnsInEditFieldNameInDefaultsTableName() + "," + this.dbPermissionsDescriptor.getEditableColumnsInInsertFieldNameInDefaultsTableName() + "," + this.dbPermissionsDescriptor.getFunctionIdFieldNameInDefaultsTableName();
                int i8 = 0;
                while (i8 < this.dbPermissionsDescriptor.getOtherFieldNamesInDefaultsTableName().length) {
                    sql = sql + "," + this.dbPermissionsDescriptor.getOtherFieldNamesInDefaultsTableName()[i8];
                    ++i8;
                }
                sql = sql + ") values(?,?,?,?,?,?";
                int i9 = 0;
                while (i9 < this.dbPermissionsDescriptor.getOtherFieldNamesInDefaultsTableName().length) {
                    sql = sql + ",?";
                    ++i9;
                }
                sql = sql + ")";
                pstmt = conn.prepareStatement(sql);
                aux = "";
                int i10 = 0;
                while (i10 < columnAttributes.length) {
                    aux = aux + columnAttributes[i10] + ",";
                    ++i10;
                }
                aux = aux.substring(0, aux.length() - 1);
                pstmt.setString(1, aux);
                aux = "";
                int i11 = 0;
                while (i11 < columnAttributes.length) {
                    aux = aux + (columnsMandatory[i11] ? "true" : "false") + ",";
                    ++i11;
                }
                aux = aux.substring(0, aux.length() - 1);
                pstmt.setString(2, aux);
                aux = "";
                int i12 = 0;
                while (i12 < columnAttributes.length) {
                    aux = aux + (columnsVisibility[i12] ? "true" : "false") + ",";
                    ++i12;
                }
                aux = aux.substring(0, aux.length() - 1);
                pstmt.setString(3, aux);
                aux = "";
                int i13 = 0;
                while (i13 < columnAttributes.length) {
                    aux = aux + (columnsEditableInEdit[i13] ? "true" : "false") + ",";
                    ++i13;
                }
                aux = aux.substring(0, aux.length() - 1);
                pstmt.setString(4, aux);
                aux = "";
                int i14 = 0;
                while (i14 < columnAttributes.length) {
                    aux = aux + (columnEditableInInsert[i14] ? "true" : "false") + ",";
                    ++i14;
                }
                aux = aux.substring(0, aux.length() - 1);
                pstmt.setString(5, aux);
                pstmt.setString(6, functionId);
                int i15 = 0;
                while (i15 < this.dbPermissionsDescriptor.getOtherFieldValuesInDefaultsTableName().length) {
                    pstmt.setObject(i15 + 7, this.dbPermissionsDescriptor.getOtherFieldValuesInDefaultsTableName()[i15]);
                    ++i15;
                }
                pstmt.execute();
            }
            conn.commit();
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage());
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }
}

