/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.openswing.swing.client.AutoCompletitionInputControl;
import org.openswing.swing.client.AutoCompletitionListener;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.CodBox;
import org.openswing.swing.client.CodBoxContainer;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.form.model.client.ValueChangeEvent;
import org.openswing.swing.form.model.client.ValueChangeListener;
import org.openswing.swing.lookup.client.LookupAutoCompletitionDataLocator;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupParent;
import org.openswing.swing.lookup.client.RestoreFocusOnInvalidCodeException;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class CodLookupControl
extends BaseInputControl
implements CodBoxContainer,
InputControl,
LookupParent,
AutoCompletitionInputControl {
    private AutoCompletitionListener autoCompletitionListener = null;
    private long autoCompletitionWaitTime;
    private Component buttonSeparator = Box.createHorizontalStrut(5);
    private CodBox codBox;
    private String controllerClassName = null;
    private String controllerMethodName = null;
    private boolean enableCodBox = true;
    private boolean firstTime = true;
    private JButton lookupButton = new JButton(){

        public void paint(Graphics g) {
            super.paint(g);
            int width = g.getFontMetrics().stringWidth("...");
            if (this.isEnabled()) {
                g.setColor(UIManager.getColor("Button.foreground"));
            } else {
                g.setColor(UIManager.getColor("Button.disabledForeground"));
            }
            g.drawString("...", (this.getWidth() - width + 1) / 2, this.getHeight() / 2 + 4);
        }
    };
    private JButton plusButton;
    private LookupController validationController = null;

    public CodLookupControl() {
        this.codBox = new CodBox();
        this.plusButton = new JButton(){

            public void paint(Graphics g) {
                super.paint(g);
                int width = g.getFontMetrics().stringWidth("...");
                g.drawString("+", (this.getWidth() - width + 1) / 2, this.getHeight() / 2 + 4);
            }
        };
        this.autoCompletitionWaitTime = ClientSettings.LOOKUP_AUTO_COMPLETITION_WAIT_TIME;
        this.codBox.setContainer(this);
        this.codBox.setColumns(10);
        StringBuffer s = new StringBuffer(this.getMaxCharacters());
        int i = 0;
        while (i < this.getMaxCharacters()) {
            s.append("0");
            ++i;
        }
        this.setMinimumSize(new Dimension(this.getFontMetrics(this.getFont()).stringWidth(s.toString()) + this.lookupButton.getPreferredSize().width, this.getPreferredSize().height));
        this.lookupButton.setText(null);
        this.lookupButton.setPreferredSize(new Dimension(21, this.codBox.getPreferredSize().height));
        ClientUtils.addTabListener(this.lookupButton);
        this.lookupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CodLookupControl.this.validationController != null) {
                    CodLookupControl.this.validationController.openLookupFrame(CodLookupControl.this.lookupButton, (LookupParent)CodLookupControl.this);
                }
            }
        });
        this.plusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CodLookupControl.this.controllerClassName != null) {
                    try {
                        Class.forName(CodLookupControl.this.controllerClassName).newInstance();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                } else if (CodLookupControl.this.controllerMethodName != null) {
                    try {
                        MDIFrame.getClientFacade().getClass().getMethod(CodLookupControl.this.controllerMethodName, new Class[0]).invoke((Object)MDIFrame.getClientFacade(), new Object[0]);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.codBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.buttonSeparator, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lookupButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.lookupButton.setPreferredSize(new Dimension(this.lookupButton.getPreferredSize().width, this.codBox.getPreferredSize().height));
        this.lookupButton.setMaximumSize(new Dimension(this.lookupButton.getPreferredSize().width, this.codBox.getPreferredSize().height));
        this.lookupButton.setMinimumSize(new Dimension(this.lookupButton.getPreferredSize().width, this.codBox.getPreferredSize().height));
        this.plusButton.setPreferredSize(new Dimension(this.lookupButton.getPreferredSize().width, this.codBox.getPreferredSize().height));
        this.plusButton.setMaximumSize(new Dimension(this.lookupButton.getPreferredSize().width, this.codBox.getPreferredSize().height));
        this.plusButton.setMinimumSize(new Dimension(this.lookupButton.getPreferredSize().width, this.codBox.getPreferredSize().height));
        if (ClientSettings.TEXT_ORIENTATION != null) {
            this.setComponentOrientation(ClientSettings.TEXT_ORIENTATION);
        }
        this.initListeners();
    }

    public final void addActionListener(ActionListener listener) {
        try {
            this.codBox.addActionListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void addFocusListener(FocusListener listener) {
        try {
            this.codBox.addFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    private final void addLookupListener(LookupController controller) {
        controller.addLookupListener(new LookupListener(){

            public void beforeLookupAction(ValueObject parentVO) {
            }

            public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                try {
                    Iterator list = parentChangedAttributes.iterator();
                    Object newValue = null;
                    while (list.hasNext()) {
                        String attrName = (String)list.next();
                        if (parentVO != null) {
                            String aux = attrName;
                            Object obj = parentVO;
                            while (aux.indexOf(".") != -1) {
                                obj = ClientUtils.getPropertyDescriptor(obj.getClass(), aux.substring(0, aux.indexOf("."))).getReadMethod().invoke(obj, new Object[0]);
                                aux = aux.substring(aux.indexOf(".") + 1);
                            }
                            newValue = ClientUtils.getPropertyDescriptor(obj.getClass(), aux).getReadMethod().invoke(obj, new Object[0]);
                        } else {
                            newValue = null;
                        }
                        ValueChangeEvent e = new ValueChangeEvent(this, attrName, null, newValue);
                        ValueChangeListener[] listeners = CodLookupControl.this.getValueChangeListeners();
                        int i = 0;
                        while (i < listeners.length) {
                            listeners[i].valueChanged(e);
                            ++i;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                catch (Error er) {
                    er.printStackTrace();
                }
            }

            public void codeValidated(boolean validated) {
                CodLookupControl.this.codBox.codeValidated(validated);
            }

            public void forceValidate() {
                CodLookupControl.this.codBox.forceValidate();
            }
        });
    }

    public final void addNotify() {
        super.addNotify();
        if (this.firstTime) {
            Form form;
            this.firstTime = false;
            if (!Beans.isDesignTime() && this.validationController != null && this.validationController.getForm() == null && (form = ClientUtils.getLinkedForm(this)) != null) {
                this.validationController.setForm(form);
            }
            if (!Beans.isDesignTime() && this.autoCompletitionWaitTime >= 0L && this.autoCompletitionListener == null && this.getAttributeName() != null) {
                this.autoCompletitionListener = new AutoCompletitionListener(this, new LookupAutoCompletitionDataLocator(this.validationController, this.getAttributeName()), this.autoCompletitionWaitTime);
                this.codBox.addKeyListener(this.autoCompletitionListener);
            }
            this.codBox.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == ClientSettings.LOOKUP_OPEN_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.LOOKUP_OPEN_KEY.getModifiers() && CodLookupControl.this.validationController != null) {
                        CodLookupControl.this.validationController.openLookupFrame(CodLookupControl.this.codBox, (LookupParent)CodLookupControl.this);
                    }
                    if (e.getKeyCode() == ClientSettings.LOOKUP_CONTROLLER_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.LOOKUP_CONTROLLER_KEY.getModifiers()) {
                        if (CodLookupControl.this.controllerClassName != null) {
                            try {
                                Class.forName(CodLookupControl.this.controllerClassName).newInstance();
                            }
                            catch (Throwable ex) {
                                ex.printStackTrace();
                            }
                        } else if (CodLookupControl.this.controllerMethodName != null) {
                            try {
                                MDIFrame.getClientFacade().getClass().getMethod(CodLookupControl.this.controllerMethodName, new Class[0]).invoke((Object)MDIFrame.getClientFacade(), new Object[0]);
                            }
                            catch (Throwable ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
    }

    public final long getAutoCompletitionWaitTime() {
        return this.autoCompletitionWaitTime;
    }

    public JComponent getBindingComponent() {
        return this.codBox;
    }

    public final CodBox getCodBox() {
        return this.codBox;
    }

    public final int getColumns() {
        return this.codBox.getColumns();
    }

    public final String getControllerClassName() {
        return this.controllerClassName;
    }

    public final String getControllerMethodName() {
        return this.controllerMethodName;
    }

    public Object getLookupCodeParentValue() {
        if (this.validationController.getForm() != null) {
            return this.validationController.getForm().getVOModel().getValue(this.getAttributeName());
        }
        return "";
    }

    public final LookupController getLookupController() {
        return this.validationController;
    }

    public final int getMaxCharacters() {
        return this.codBox.getMaxCharacters();
    }

    public final ComponentOrientation getTextOrientation() {
        try {
            return this.codBox.getComponentOrientation();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final Object getValue() {
        return this.codBox.getValue();
    }

    public ValueObject getValueObject() {
        return this.validationController.getForm() == null ? null : this.validationController.getForm().getVOModel().getValueObject();
    }

    public final boolean isAllowOnlyNumbers() {
        return this.codBox.isAllowOnlyNumbers();
    }

    public final boolean isCodBoxVisible() {
        return this.codBox.isVisible();
    }

    public boolean isEnableCodBox() {
        return this.enableCodBox;
    }

    public final boolean isEnabled() {
        try {
            return this.codBox.isEditable();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean isLookupButtonVisible() {
        if (this.lookupButton != null) {
            return this.lookupButton.isVisible();
        }
        return true;
    }

    public final void removeActionListener(ActionListener listener) {
        try {
            this.codBox.removeActionListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void removeFocusListener(FocusListener listener) {
        try {
            this.codBox.removeFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void setAllowOnlyNumbers(boolean allowOnlyNumbers) {
        this.codBox.setAllowOnlyNumbers(allowOnlyNumbers);
    }

    public final void setAutoCompletitionWaitTime(long autoCompletitionWaitTime) {
        this.autoCompletitionWaitTime = autoCompletitionWaitTime;
    }

    public final void setCodBoxVisible(boolean codBoxVisible) {
        this.codBox.setVisible(codBoxVisible);
    }

    public final void setColumns(int columns) {
        this.codBox.setColumns(columns);
    }

    public final void setControllerClassName(String controllerClassName) {
        this.controllerClassName = controllerClassName;
        if (this.controllerMethodName != null) {
            this.add((Component)this.plusButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public final void setControllerMethodName(String controllerMethodName) {
        this.controllerMethodName = controllerMethodName;
        if (controllerMethodName != null) {
            this.add((Component)this.plusButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void setEnableCodBox(boolean enableCodBox) {
        this.enableCodBox = enableCodBox;
        if (!enableCodBox) {
            this.codBox.setEnabled(enableCodBox);
        }
    }

    public final void setEnabled(boolean enabled) {
        if (this.enableCodBox) {
            this.codBox.setEditable(enabled);
        } else {
            this.codBox.setEditable(false);
        }
        this.lookupButton.setEnabled(enabled);
        this.codBox.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
        this.lookupButton.setFocusable(enabled);
    }

    public final void setLookupButtonVisible(boolean lookupButtonVisible) {
        if (this.lookupButton != null) {
            this.lookupButton.setVisible(lookupButtonVisible);
        }
    }

    public final void setLookupController(LookupController controller) {
        this.validationController = controller;
        this.addLookupListener(controller);
        Form form = ClientUtils.getLinkedForm(this);
        if (form != null) {
            controller.setForm(form);
        }
    }

    public final void setMaxCharacters(int maxCharacters) {
        this.codBox.setMaxCharacters(maxCharacters);
        StringBuffer s = new StringBuffer(this.getMaxCharacters());
        int i = 0;
        while (i < this.getMaxCharacters()) {
            s.append("0");
            ++i;
        }
        this.setMinimumSize(new Dimension(this.getFontMetrics(this.getFont()).stringWidth(s.toString()) + this.lookupButton.getPreferredSize().width, this.getPreferredSize().height));
    }

    public final void setTextOrientation(ComponentOrientation o) {
        this.codBox.setComponentOrientation(o);
    }

    public void setValue(String attributeName, Object value) {
        if (this.validationController.getForm() != null) {
            this.validationController.getForm().getVOModel().setValue(attributeName, value);
        }
    }

    public final void setValue(Object code) {
        this.codBox.setValue(code);
    }

    public final void validateCode(String code) throws RestoreFocusOnInvalidCodeException {
        if (this.autoCompletitionWaitTime >= 0L && this.autoCompletitionListener != null && this.autoCompletitionListener.isWindowVisible()) {
            return;
        }
        if (this.validationController != null) {
            this.validationController.validateCode(this.codBox, code, this);
        }
    }
}

