/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.domains.java.DomainPair;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.SearchControl;
import org.openswing.swing.util.client.SearchWindowManager;

public class ComboBoxControl
extends BaseInputControl
implements InputControl,
SearchControl {
    private JComboBox combo = new JComboBox();
    private Domain domain = null;
    private String domainId = null;
    private Color enabledBackColor;
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private boolean nullAsDefaultValue = false;
    private boolean translateItemDescriptions = true;

    static {
        UIManager.put("ComboBox.disabledForeground", UIManager.get("ComboBox.foreground"));
        UIManager.put("ComboBox.disabledBackground", UIManager.get("TextField.inactiveBackground"));
        UIManager.put("ComboBox.selectionForeground", Color.black);
        UIManager.put("ComboBox.selectionBackground", ClientSettings.BACKGROUND_SEL_COLOR);
    }

    public ComboBoxControl() {
        this.enabledBackColor = this.combo.getBackground();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.combo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setOpaque(false);
        this.combo.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                block3: {
                    block2: {
                        if (e.getKeyCode() == 3) break block2;
                        if (e.getKeyCode() == 8) break block2;
                        if (e.getKeyCode() != 127) break block3;
                    }
                    ComboBoxControl.this.combo.setSelectedIndex(-1);
                }
            }
        });
        this.combo.setKeySelectionManager(new JComboBox.KeySelectionManager(){

            public int selectionForKey(char aKey, ComboBoxModel aModel) {
                return -1;
            }
        });
        new SearchWindowManager(this);
        if (ClientSettings.TEXT_ORIENTATION != null) {
            this.setComponentOrientation(ClientSettings.TEXT_ORIENTATION);
        }
        this.initListeners();
    }

    public final void addActionListener(ActionListener l) {
        try {
            this.combo.addActionListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void addFocusListener(FocusListener l) {
        try {
            this.combo.addFocusListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void addItemListener(ItemListener alistener) {
        try {
            this.combo.addItemListener(alistener);
        }
        catch (Exception ex) {
        }
    }

    public final boolean disableListener() {
        return false;
    }

    public JComponent getBindingComponent() {
        return this.combo;
    }

    public final JComboBox getComboBox() {
        return this.combo;
    }

    public final JComponent getComponent() {
        return this.combo;
    }

    public final Domain getDomain() {
        return this.domain;
    }

    public final String getDomainId() {
        return this.domainId;
    }

    public final int getRowCount() {
        return this.combo.getItemCount();
    }

    public final int getSelectedIndex() {
        return this.combo.getSelectedIndex();
    }

    public final ComponentOrientation getTextOrientation() {
        try {
            return this.combo.getComponentOrientation();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final Object getValue() {
        if (this.domain == null) {
            return null;
        }
        DomainPair[] pairs = this.domain.getDomainPairList();
        int i = 0;
        while (i < pairs.length) {
            if (this.combo.getSelectedItem() == null) {
                return null;
            }
            if (this.translateItemDescriptions ? this.combo.getSelectedItem().equals(ClientSettings.getInstance().getResources().getResource(pairs[i].getDescription())) : this.combo.getSelectedItem().equals(pairs[i].getDescription())) {
                return pairs[i].getCode();
            }
            ++i;
        }
        return null;
    }

    public final String getValueAt(int index) {
        return this.combo.getItemAt(index) == null ? "" : this.combo.getItemAt(index).toString();
    }

    public final boolean isEnabled() {
        try {
            return this.combo.isEnabled();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean isNullAsDefaultValue() {
        return this.nullAsDefaultValue;
    }

    public final boolean isReadOnly() {
        return this.isEnabled();
    }

    public final boolean isTranslateItemDescriptions() {
        return this.translateItemDescriptions;
    }

    public final void removeActionListener(ActionListener l) {
        try {
            this.combo.removeActionListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void removeFocusListener(FocusListener l) {
        try {
            this.combo.removeFocusListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void removeItemListener(ItemListener alistener) {
        try {
            this.combo.removeItemListener(alistener);
        }
        catch (Exception ex) {
        }
    }

    public final int search(String textToSeach) {
        return -1;
    }

    public final void setDomain(Domain domain) {
        this.domain = domain;
        this.model.removeAllElements();
        if (domain != null) {
            DomainPair[] pairs = domain.getDomainPairList();
            int i = 0;
            while (i < pairs.length) {
                if (this.translateItemDescriptions) {
                    this.model.addElement(ClientSettings.getInstance().getResources().getResource(pairs[i].getDescription()));
                } else {
                    this.model.addElement(pairs[i].getDescription());
                }
                ++i;
            }
            this.combo.setModel(this.model);
            this.combo.revalidate();
            this.combo.setSelectedIndex(-1);
        }
    }

    public final void setDomainId(String domainId) {
        this.domainId = domainId;
        if (Beans.isDesignTime()) {
            return;
        }
        Domain domain = ClientSettings.getInstance().getDomain(domainId);
        this.setDomain(domain);
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
        this.combo.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
        if (!enabled) {
            this.combo.setBackground((Color)UIManager.get("TextField.inactiveBackground"));
        } else {
            this.combo.setBackground(this.enabledBackColor);
        }
    }

    public final void setNullAsDefaultValue(boolean nullAsDefaultValue) {
        this.nullAsDefaultValue = nullAsDefaultValue;
    }

    public final void setSelectedIndex(int index) {
        this.combo.setSelectedIndex(index);
    }

    public final void setTextOrientation(ComponentOrientation o) {
        this.combo.setComponentOrientation(o);
    }

    public final void setTranslateItemDescriptions(boolean translateItemDescriptions) {
        this.translateItemDescriptions = translateItemDescriptions;
    }

    public final void setValue(Object code) {
        if (code == null) {
            this.combo.setSelectedIndex(-1);
        }
        if (this.domain == null) {
            return;
        }
        DomainPair pair = this.domain.getDomainPair(code);
        if (pair != null) {
            if (this.translateItemDescriptions) {
                this.combo.setSelectedItem(ClientSettings.getInstance().getResources().getResource(pair.getDescription()));
            } else {
                this.combo.setSelectedItem(pair.getDescription());
            }
        }
    }
}

