/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.openswing.swing.client.CopyButton;
import org.openswing.swing.client.DataController;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.FilterButton;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.util.client.ClientSettings;

public class GenericButton
extends JButton {
    public String attributeName = null;
    private int buttonBehavior;
    protected List dataControllerList = new ArrayList(3);
    private boolean executeAsThread = false;

    public GenericButton(ImageIcon imageIcon) {
        this();
        if (this.buttonBehavior == 0) {
            super.setIcon(imageIcon);
            this.setPreferredSize(new Dimension(32, 32));
        } else {
            boolean defaultButton = true;
            if (this instanceof InsertButton) {
                this.setText("Insert");
            } else if (this instanceof EditButton) {
                this.setText("Edit");
            } else if (this instanceof CopyButton) {
                this.setText("Copy");
            } else if (this instanceof DeleteButton) {
                this.setText("Delete");
            } else if (this instanceof ReloadButton) {
                this.setText("Reload");
            } else if (this instanceof SaveButton) {
                this.setText("Save");
            } else if (this instanceof FilterButton) {
                this.setText("Filter");
            } else if (this instanceof ExportButton) {
                this.setText("Export");
            } else {
                defaultButton = false;
            }
            int w = this.getFontMetrics(this.getFont()).stringWidth(this.getText());
            if (defaultButton) {
                w = Math.max(w, this.getFontMetrics(this.getFont()).stringWidth(ClientSettings.getInstance().getResources().getResource("Insert")));
                w = Math.max(w, this.getFontMetrics(this.getFont()).stringWidth(ClientSettings.getInstance().getResources().getResource("Edit")));
                w = Math.max(w, this.getFontMetrics(this.getFont()).stringWidth(ClientSettings.getInstance().getResources().getResource("Copy")));
                w = Math.max(w, this.getFontMetrics(this.getFont()).stringWidth(ClientSettings.getInstance().getResources().getResource("Delete")));
                w = Math.max(w, this.getFontMetrics(this.getFont()).stringWidth(ClientSettings.getInstance().getResources().getResource("Save")));
                w = Math.max(w, this.getFontMetrics(this.getFont()).stringWidth(ClientSettings.getInstance().getResources().getResource("Reload")));
                w = Math.max(w, this.getFontMetrics(this.getFont()).stringWidth(ClientSettings.getInstance().getResources().getResource("Export")));
                w = Math.max(w, this.getFontMetrics(this.getFont()).stringWidth(ClientSettings.getInstance().getResources().getResource("Filter")));
            }
            w += this.getMargin().left + this.getMargin().right + 5;
            if (this.buttonBehavior == 1) {
                this.setPreferredSize(new Dimension(w, 32));
            } else {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                super.setIcon(imageIcon);
                this.setPreferredSize(new Dimension(w, this.getFontMetrics(this.getFont()).getHeight() + this.getMargin().top + this.getMargin().bottom + 32));
            }
        }
    }

    public GenericButton() {
        this.buttonBehavior = ClientSettings.BUTTON_BEHAVIOR;
        super.addActionListener(new ActionListener(){

            static /* synthetic */ GenericButton access$100(1 x0) {
                return x0.GenericButton.this;
            }

            public void actionPerformed(ActionEvent e) {
                if (!GenericButton.this.executeAsThread) {
                    GenericButton.this.execute();
                } else {
                    new Thread(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            1.access$100(this.this$1).execute();
                        }
                    }.start();
                }
            }
        });
        this.setFocusable(false);
    }

    public final void addDataController(DataController dataController) {
        if (dataController != null) {
            this.dataControllerList.add(dataController);
        }
    }

    public final boolean containsDataController(DataController dataController) {
        int i = 0;
        while (i < this.dataControllerList.size()) {
            if (this.dataControllerList.get(i).equals(dataController)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void execute() {
        try {
            int i = 0;
            while (i < this.dataControllerList.size()) {
                this.executeOperation((DataController)this.dataControllerList.get(i));
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void executeOperation(DataController controller) throws Exception {
        throw new Exception("The method must be overridden in the subclass");
    }

    public final String getAttributeName() {
        return this.attributeName;
    }

    public final int getButtonBehavior() {
        return this.buttonBehavior;
    }

    public final boolean getOldValue() {
        DataController dataController = null;
        int i = 0;
        if (i < this.dataControllerList.size()) {
            dataController = (DataController)this.dataControllerList.get(i);
            return dataController.getCurrentValue(this);
        }
        return false;
    }

    public final boolean isExecuteAsThread() {
        return this.executeAsThread;
    }

    public final void removeAllDataControllers() {
        this.dataControllerList.clear();
    }

    public final void removeDataController(DataController dataController) {
        if (dataController != null) {
            this.dataControllerList.remove(dataController);
        }
    }

    public final void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public final void setButtonBehavior(int buttonBehavior) {
        this.buttonBehavior = buttonBehavior;
    }

    public final void setEnabled(boolean enabled) {
        String functionId = null;
        DataController dataController = null;
        int i = 0;
        while (i < this.dataControllerList.size()) {
            dataController = (DataController)this.dataControllerList.get(i);
            if (dataController.isButtonDisabled(this)) {
                super.setEnabled(false);
                return;
            }
            functionId = dataController.getFunctionId();
            boolean buttonAuthorized = true;
            if (this instanceof InsertButton || this instanceof CopyButton) {
                buttonAuthorized = ClientSettings.getInstance().getButtonsAuthorizations().isInsertEnabled(functionId);
            } else if (this instanceof EditButton) {
                buttonAuthorized = ClientSettings.getInstance().getButtonsAuthorizations().isEditEnabled(functionId);
            } else if (this instanceof DeleteButton) {
                buttonAuthorized = ClientSettings.getInstance().getButtonsAuthorizations().isDeleteEnabled(functionId);
            }
            if (!buttonAuthorized && enabled) {
                enabled = false;
                break;
            }
            dataController.setCurrentValue(this, enabled);
            ++i;
        }
        super.setEnabled(enabled);
    }

    public final void setExecuteAsThread(boolean executeAsThread) {
        this.executeAsThread = executeAsThread;
    }

    public void setText(String t) {
        if (this.buttonBehavior != 0) {
            super.setText(ClientSettings.getInstance().getResources().getResource(t));
        }
    }
}

