/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.ImagePanel;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.util.client.ClientSettings;

public class ImageControl
extends BaseInputControl
implements InputControl {
    private boolean autoResize = true;
    private FileFilter fileFilter;
    GridBagLayout gridBagLayout1;
    private int imageHeight = 0;
    private ImagePanel imagePanel = new ImagePanel();
    private int imageWidth = 0;
    private ArrayList listeners;
    private JButton selButton = new JButton(){

        public void paint(Graphics g) {
            super.paint(g);
            int width = g.getFontMetrics().stringWidth("...");
            if (this.isEnabled()) {
                g.setColor(UIManager.getColor("Button.foreground"));
            } else {
                g.setColor(UIManager.getColor("Button.disabledForeground"));
            }
            g.drawString("...", (this.getWidth() - width + 1) / 2, this.getHeight() / 2 + 4);
        }
    };
    private boolean showButton = true;
    public static boolean showPreview = ClientSettings.SHOW_PREVIEW_OF_IMAGE;

    public ImageControl() {
        this.fileFilter = new FileFilter(){

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".gif") || f.getName().toLowerCase().endsWith(".jpg") || f.isDirectory();
            }

            public String getDescription() {
                return "JPEG/GIF image (*.jpg; *.gif)";
            }
        };
        this.listeners = new ArrayList();
        this.gridBagLayout1 = new GridBagLayout();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initListeners();
    }

    public final void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    private void forceImageDimensions() {
        this.imagePanel.setMinimumSize(new Dimension(this.imageWidth, this.imageHeight));
        this.imagePanel.setMaximumSize(new Dimension(this.imageWidth, this.imageHeight));
        this.imagePanel.setPreferredSize(new Dimension(this.imageWidth, this.imageHeight));
    }

    public final JComponent getBindingComponent() {
        return this.selButton;
    }

    public final FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public final byte[] getImage() {
        return this.imagePanel.getImage();
    }

    public final int getImageHeight() {
        return this.imageHeight;
    }

    public final int getImageWidth() {
        return this.imageWidth;
    }

    public final int getScrollBarsPolicy() {
        return this.imagePanel.getScrollBarsPolicy();
    }

    public final Object getValue() {
        return this.getImage();
    }

    public final boolean isAutoResize() {
        return this.autoResize;
    }

    public final boolean isEnabled() {
        try {
            return this.selButton.isEnabled();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean isShowButton() {
        return this.showButton;
    }

    public final boolean isShowPreview() {
        return showPreview;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.imagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.selButton.setPreferredSize(new Dimension(21, 20));
        this.selButton.setMinimumSize(new Dimension(21, 20));
        this.selButton.setMaximumSize(new Dimension(21, 20));
        this.selButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser f = new JFileChooser();
                f.setDialogTitle(ClientSettings.getInstance().getResources().getResource("image selection"));
                Container c = ImageControl.this.getParent();
                while (c != null && !(c instanceof JFrame) && !(c instanceof JInternalFrame)) {
                    c = c.getParent();
                }
                if (c == null) {
                    c = MDIFrame.getInstance();
                }
                f.setFileSelectionMode(0);
                if (showPreview) {
                    PreviewImage ip = new PreviewImage();
                    f.setAccessory(ip);
                    ip.setPreferredSize(new Dimension(100, 100));
                    ip.setBorder(BorderFactory.createEtchedBorder());
                    f.addPropertyChangeListener(new PropertyChangeListener(this, ip){
                        private final /* synthetic */ 3 this$1;
                        private final /* synthetic */ PreviewImage val$ip;
                        {
                            this.this$1 = this$1;
                            this.val$ip = val$ip;
                        }

                        public void propertyChange(PropertyChangeEvent evt) {
                            try {
                                if (evt.getPropertyName().equals("SelectedFileChangedProperty")) {
                                    this.val$ip.setImage((File)evt.getNewValue());
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                }
                if (ImageControl.this.fileFilter != null) {
                    f.setFileFilter(ImageControl.this.fileFilter);
                }
                int res = f.showOpenDialog(c);
                if (res == 0) {
                    try {
                        ImageControl.this.imagePanel.setImageAsStream(new FileInputStream(f.getSelectedFile()));
                        int i = 0;
                        while (i < ImageControl.this.listeners.size()) {
                            ((ActionListener)ImageControl.this.listeners.get(i)).actionPerformed(new ActionEvent(ImageControl.this, e.getID(), f.getSelectedFile().getAbsolutePath()));
                            ++i;
                        }
                    }
                    catch (Exception ex) {
                        Logger.error("org.openswing.swing.client.ImageControl", "actionPerformed", ex.getMessage(), ex);
                        OptionPane.showMessageDialog(c, "Error", ex.getMessage(), 0);
                    }
                }
            }
        });
        this.add((Component)this.selButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    public final void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public final void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
        if (!autoResize && this.imageWidth > 0 && this.imageHeight > 0) {
            this.forceImageDimensions();
        }
    }

    public void setEnabled(boolean enabled) {
        this.selButton.setEnabled(enabled);
    }

    public final void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public final void setImage(byte[] image) {
        this.imagePanel.setImage(image);
    }

    public final void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
        if (!this.autoResize && imageHeight > 0 && imageHeight > 0) {
            this.forceImageDimensions();
        }
    }

    public final void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
        if (!this.autoResize && imageWidth > 0 && imageWidth > 0) {
            this.forceImageDimensions();
        }
    }

    public final void setScrollBarsPolicy(int policy) {
        this.imagePanel.setScrollBarsPolicy(policy);
    }

    public final void setShowButton(boolean showButton) {
        this.showButton = showButton;
        if (showButton) {
            this.remove(this.selButton);
            this.add((Component)this.selButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        } else {
            this.remove(this.selButton);
        }
        this.revalidate();
        this.repaint();
    }

    public final void setShowPreview(boolean showPreview) {
        ImageControl.showPreview = showPreview;
    }

    public final void setValue(Object value) {
        try {
            this.setImage((byte[])value);
        }
        catch (Exception ex) {
            this.setImage(null);
            Logger.error(this.getClass().getName(), "setValue", ex.getMessage(), ex);
        }
    }

    class PreviewImage
    extends JLabel {
        public PreviewImage() {
            this.setPreferredSize(new Dimension(100, 100));
            this.setBorder(BorderFactory.createEtchedBorder());
        }

        public void setImage(File f) {
            ImageIcon icon = new ImageIcon(f.getPath());
            if (icon.getIconWidth() > this.getWidth()) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(this.getWidth(), -1, 1));
            }
            this.setIcon(icon);
            this.repaint();
        }
    }
}

