/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseListener;
import java.awt.image.PixelGrabber;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class ImagePanel
extends JPanel {
    public static final int SCROLLBAR_ALWAYS = 22;
    public static final int SCROLLBAR_AS_NEEDED = 20;
    public static final int SCROLLBAR_NEVER = 21;
    private BorderLayout borderLayout1;
    private byte[] image = null;
    private String imageName = null;
    private InnerImagePanel imagePanel = new InnerImagePanel();
    private JScrollPane sp;
    private String toolTipText = null;

    public ImagePanel() {
        this.borderLayout1 = new BorderLayout();
        this.sp = new JScrollPane(this.imagePanel);
        try {
            this.imagePanel.setOpaque(false);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addMouseListener(MouseListener listener) {
        this.imagePanel.addMouseListener(listener);
    }

    public final byte[] getImage() {
        if (this.image == null && this.imagePanel.getImage() != null) {
            PixelGrabber pg = new PixelGrabber(this.imagePanel.getImage(), 0, 0, this.imagePanel.getImage().getWidth(this.imagePanel), this.imagePanel.getImage().getHeight(this.imagePanel), true);
            this.image = (byte[])pg.getPixels();
        }
        return this.image;
    }

    public final int getImageHeight() {
        return this.imagePanel.getHeight();
    }

    public final String getImageName() {
        return this.imageName;
    }

    public final int getImageWidth() {
        return this.imagePanel.getWidth();
    }

    public final int getScrollBarsPolicy() {
        return this.sp.getVerticalScrollBarPolicy();
    }

    public final String getToolTipText() {
        return this.toolTipText;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.sp, "Center");
        this.sp.getViewport().add(this.imagePanel);
        this.sp.getViewport().setOpaque(false);
        this.sp.setOpaque(false);
    }

    public void removeMouseListener(MouseListener listener) {
        this.imagePanel.removeMouseListener(listener);
    }

    public final void setImage(Image image) {
        if (image != null) {
            this.imagePanel.setImage(image);
        } else {
            this.imagePanel.setImage(null);
        }
    }

    public final void setImage(byte[] image) {
        if (image != null) {
            this.imagePanel.setImage(new ImageIcon(image).getImage());
        } else {
            this.imagePanel.setImage(null);
        }
        this.image = image;
    }

    public final void setImageAsStream(InputStream in) throws IOException {
        byte[] aux = new byte[1024];
        byte[] aux2 = new byte[]{};
        byte[] image = new byte[]{};
        int len = 0;
        while ((len = in.read(aux)) > 0) {
            aux2 = new byte[image.length + len];
            System.arraycopy(image, 0, aux2, 0, image.length);
            System.arraycopy(aux, 0, aux2, image.length, len);
            image = aux2;
        }
        in.close();
        this.imagePanel.setImage(new ImageIcon(image).getImage());
        this.image = image;
    }

    public final void setImageName(String imageName) {
        if (imageName != null) {
            Image img = ClientUtils.getImage(imageName);
            this.imagePanel.setImage(img);
        } else {
            this.imagePanel.setImage(null);
        }
        this.imageName = imageName;
    }

    public final void setScrollBarsPolicy(int policy) {
        if (policy == 21) {
            this.sp.setVerticalScrollBarPolicy(21);
            this.sp.setHorizontalScrollBarPolicy(31);
            this.sp.setBorder(BorderFactory.createEmptyBorder());
        } else if (policy == 20) {
            this.sp.setVerticalScrollBarPolicy(20);
            this.sp.setHorizontalScrollBarPolicy(30);
        } else if (policy == 22) {
            this.sp.setVerticalScrollBarPolicy(22);
            this.sp.setHorizontalScrollBarPolicy(32);
        }
    }

    public final void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        if (!Beans.isDesignTime()) {
            this.imagePanel.setToolTipText(ClientSettings.getInstance().getResources().getResource(toolTipText));
        }
    }

    class InnerImagePanel
    extends JPanel {
        private Image image = null;

        InnerImagePanel() {
        }

        private Image getImage() {
            return this.image;
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (Beans.isDesignTime()) {
                return;
            }
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this.image.getWidth(this), this.image.getHeight(this), this);
            }
        }

        public void setImage(Image image) {
            this.image = image;
            if (image != null) {
                this.setSize(image.getWidth(this), image.getHeight(this));
                this.setMinimumSize(new Dimension(image.getWidth(this), image.getHeight(this)));
                this.setPreferredSize(new Dimension(image.getWidth(this), image.getHeight(this)));
            }
            this.revalidate();
            this.repaint();
        }
    }
}

