/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.items.client.ItemRenderer;
import org.openswing.swing.items.client.ItemsDataLocator;
import org.openswing.swing.items.client.ItemsMapper;
import org.openswing.swing.items.client.ItemsParent;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.DateColumn;
import org.openswing.swing.table.columns.client.DecimalColumn;
import org.openswing.swing.table.columns.client.IntegerColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;
import org.openswing.swing.util.client.SearchControl;
import org.openswing.swing.util.client.SearchWindowManager;

public class ListVOControl
extends BaseInputControl
implements InputControl,
ItemsParent,
SearchControl {
    private int allColumnPreferredWidth = 100;
    private boolean allColumnVisible = false;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;
    private Column[] colProperties;
    private String foreignKeyAttributeName;
    private Form form = null;
    private Hashtable getters;
    private ItemsDataLocator itemsDataLocator = null;
    private boolean itemsLoaded = false;
    private ItemsMapper itemsMapper;
    private ValueObject itemsVO = null;
    private JList list = new JList();
    private DefaultListModel model;
    private boolean nullAsDefaultValue = false;

    public ListVOControl() {
        this.itemsMapper = new ItemsMapper();
        this.colProperties = new Column[0];
        this.model = new DefaultListModel();
        this.getters = new Hashtable();
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setOpaque(false);
        this.list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                block3: {
                    block2: {
                        if (e.getKeyCode() == 3) break block2;
                        if (e.getKeyCode() == 8) break block2;
                        if (e.getKeyCode() != 127) break block3;
                    }
                    ListVOControl.this.list.setSelectedIndex(-1);
                }
            }
        });
        this.list.setSelectionForeground((Color)UIManager.get("TextField.foreground"));
        this.initListeners();
        this.getBindingComponent().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (ClientSettings.VIEW_BACKGROUND_SEL_COLOR && ListVOControl.this.isEnabled()) {
                    ListVOControl.this.getBindingComponent().setBackground((Color)UIManager.get("TextField.background"));
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        new SearchWindowManager(this);
        if (ClientSettings.TEXT_ORIENTATION != null) {
            this.setComponentOrientation(ClientSettings.TEXT_ORIENTATION);
        }
    }

    public final void addFocusListener(FocusListener l) {
        try {
            this.list.addFocusListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void addList2ParentLink(String parentAttributeName) {
        this.itemsMapper.addItem2ParentLink("", parentAttributeName);
    }

    public final void addList2ParentLink(String comboAttributeName, String parentAttributeName) {
        this.itemsMapper.addItem2ParentLink(comboAttributeName, parentAttributeName);
    }

    public final void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public final void addNotify() {
        super.addNotify();
        if (!this.itemsLoaded) {
            Response res;
            this.itemsLoaded = true;
            if (this.itemsDataLocator != null && this.itemsVO != null && !(res = this.itemsDataLocator.loadData(this.itemsVO.getClass())).isError()) {
                List items = ((VOListResponse)res).getRows();
                int i = 0;
                while (i < items.size()) {
                    this.model.addElement(items.get(i));
                    ++i;
                }
                this.list.setModel(this.model);
                this.list.revalidate();
                this.list.repaint();
                this.list.setSelectedIndex(-1);
            }
            ItemRenderer rend = new ItemRenderer();
            rend.init(this.getters, this.colProperties, 1, 0, 0, 0);
            this.list.setCellRenderer(rend);
            this.list.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting() && (ListVOControl.this.form == null || ListVOControl.this.form.getMode() != 0) && ListVOControl.this.list.getSelectionMode() == 0) {
                        ListVOControl.this.itemsVO = (ValueObject)ListVOControl.this.model.get(e.getFirstIndex());
                        ListVOControl.this.updateParentModel(ListVOControl.this);
                    }
                }
            });
            this.form = ClientUtils.getLinkedForm(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final boolean disableListener() {
        return false;
    }

    public final int getAllColumnPreferredWidth() {
        return this.allColumnPreferredWidth;
    }

    public JComponent getBindingComponent() {
        return this.list;
    }

    public final JComponent getComponent() {
        return this.list;
    }

    private String getFKAttributeName() {
        return this.foreignKeyAttributeName == null || this.foreignKeyAttributeName.equals("") ? this.getAttributeName() : this.foreignKeyAttributeName;
    }

    public final int getFixedCellHeight() {
        return this.list.getFixedCellHeight();
    }

    public final int getFixedCellWidth() {
        return this.list.getFixedCellWidth();
    }

    public final String getForeignKeyAttributeName() {
        return this.foreignKeyAttributeName;
    }

    public final int getLayoutOrientation() {
        return this.list.getLayoutOrientation();
    }

    public final ItemsDataLocator getListDataLocator() {
        return this.itemsDataLocator;
    }

    public final int getRowCount() {
        return this.list.getModel().getSize();
    }

    public final int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public final Color getSelectionBackground() {
        return this.list.getSelectionBackground();
    }

    public Color getSelectionForeground() {
        return this.list.getSelectionForeground();
    }

    public final int getSelectionMode() {
        return this.list.getSelectionMode();
    }

    public final ComponentOrientation getTextOrientation() {
        try {
            return this.list.getComponentOrientation();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final Object getValue() {
        if (this.list.getSelectionMode() == 0) {
            if (this.getFKAttributeName() == null) {
                return null;
            }
            if (this.list.getSelectedIndex() == -1) {
                return null;
            }
            try {
                return ((Method)this.getters.get(this.getFKAttributeName())).invoke(this.model.getElementAt(this.list.getSelectedIndex()), new Object[0]);
            }
            catch (Throwable ex) {
                return null;
            }
        }
        if (this.form != null) {
            if (this.list.getSelectedIndex() == -1) {
                return new ArrayList();
            }
            ArrayList vos = new ArrayList();
            int[] values = this.list.getSelectedIndices();
            int j = 0;
            while (j < values.length) {
                vos.add(this.model.getElementAt(values[j]));
                ++j;
            }
            return vos;
        }
        if (this.getFKAttributeName() == null || this.list.getSelectedIndex() == -1) {
            return new ArrayList();
        }
        if (this.getFKAttributeName() != null && this.getters.get(this.getFKAttributeName()) == null) {
            Logger.error(this.getClass().getName(), "setValue", "There is not an attribute named '" + this.getFKAttributeName() + "' in the selected value object of type '" + this.itemsVO.getClass() + "'", null);
            return new ArrayList();
        }
        ArrayList<Object> codes = new ArrayList<Object>();
        int[] values = this.list.getSelectedIndices();
        int j = 0;
        while (j < values.length) {
            try {
                codes.add(((Method)this.getters.get(this.getFKAttributeName())).invoke(this.model.getElementAt(values[j]), new Object[0]));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            ++j;
        }
        return codes;
    }

    public final String getValueAt(int index) {
        return this.list.getModel().getElementAt(index) == null ? "" : this.list.getModel().getElementAt(index).toString();
    }

    public final boolean getValueIsAdjusting() {
        return this.list.getValueIsAdjusting();
    }

    public ValueObject getValueObject() {
        return this.form == null ? null : this.form.getVOModel().getValueObject();
    }

    public final int getVisibleRowCount() {
        return this.list.getVisibleRowCount();
    }

    private void initItemsVO(String itemsValueObjectClassName) {
        try {
            this.itemsVO = (ValueObject)Class.forName(itemsValueObjectClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            Method[] methods = this.itemsVO.getClass().getMethods();
            int count = 0;
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getName().startsWith("get") && methods[i].getParameterTypes().length == 0 && (methods[i].getReturnType().equals(class$java$lang$String == null ? ListVOControl.class$("java.lang.String") : class$java$lang$String) || methods[i].getReturnType().equals(class$java$math$BigDecimal == null ? ListVOControl.class$("java.math.BigDecimal") : class$java$math$BigDecimal) || methods[i].getReturnType().equals(class$java$util$Date == null ? ListVOControl.class$("java.util.Date") : class$java$util$Date) || methods[i].getReturnType().equals(class$java$sql$Date == null ? ListVOControl.class$("java.sql.Date") : class$java$sql$Date) || methods[i].getReturnType().equals(class$java$sql$Timestamp == null ? ListVOControl.class$("java.sql.Timestamp") : class$java$sql$Timestamp) || methods[i].getReturnType().equals(class$java$lang$Integer == null ? ListVOControl.class$("java.lang.Integer") : class$java$lang$Integer) || methods[i].getReturnType().equals(class$java$lang$Long == null ? ListVOControl.class$("java.lang.Long") : class$java$lang$Long) || methods[i].getReturnType().equals(class$java$lang$Double == null ? ListVOControl.class$("java.lang.Double") : class$java$lang$Double) || methods[i].getReturnType().equals(class$java$lang$Float == null ? ListVOControl.class$("java.lang.Float") : class$java$lang$Float) || methods[i].getReturnType().equals(class$java$lang$Short == null ? ListVOControl.class$("java.lang.Short") : class$java$lang$Short) || methods[i].getReturnType().equals(Integer.TYPE) || methods[i].getReturnType().equals(Long.TYPE) || methods[i].getReturnType().equals(Double.TYPE) || methods[i].getReturnType().equals(Float.TYPE) || methods[i].getReturnType().equals(Short.TYPE) || methods[i].getReturnType().equals(class$java$lang$Boolean == null ? ListVOControl.class$("java.lang.Boolean") : class$java$lang$Boolean))) {
                    ++count;
                }
                ++i;
            }
            String[] attributeNames = new String[count];
            this.colProperties = new Column[count];
            count = 0;
            Class<?> colType = null;
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().startsWith("get") && methods[i2].getParameterTypes().length == 0 && (methods[i2].getReturnType().equals(class$java$lang$String == null ? ListVOControl.class$("java.lang.String") : class$java$lang$String) || methods[i2].getReturnType().equals(class$java$math$BigDecimal == null ? ListVOControl.class$("java.math.BigDecimal") : class$java$math$BigDecimal) || methods[i2].getReturnType().equals(class$java$util$Date == null ? ListVOControl.class$("java.util.Date") : class$java$util$Date) || methods[i2].getReturnType().equals(class$java$sql$Date == null ? ListVOControl.class$("java.sql.Date") : class$java$sql$Date) || methods[i2].getReturnType().equals(class$java$sql$Timestamp == null ? ListVOControl.class$("java.sql.Timestamp") : class$java$sql$Timestamp) || methods[i2].getReturnType().equals(class$java$lang$Integer == null ? ListVOControl.class$("java.lang.Integer") : class$java$lang$Integer) || methods[i2].getReturnType().equals(class$java$lang$Long == null ? ListVOControl.class$("java.lang.Long") : class$java$lang$Long) || methods[i2].getReturnType().equals(class$java$lang$Double == null ? ListVOControl.class$("java.lang.Double") : class$java$lang$Double) || methods[i2].getReturnType().equals(class$java$lang$Float == null ? ListVOControl.class$("java.lang.Float") : class$java$lang$Float) || methods[i2].getReturnType().equals(class$java$lang$Short == null ? ListVOControl.class$("java.lang.Short") : class$java$lang$Short) || methods[i2].getReturnType().equals(Integer.TYPE) || methods[i2].getReturnType().equals(Long.TYPE) || methods[i2].getReturnType().equals(Double.TYPE) || methods[i2].getReturnType().equals(Float.TYPE) || methods[i2].getReturnType().equals(Short.TYPE) || methods[i2].getReturnType().equals(class$java$lang$Boolean == null ? ListVOControl.class$("java.lang.Boolean") : class$java$lang$Boolean))) {
                    attributeNames[count] = methods[i2].getName().substring(3);
                    if (attributeNames[count].length() > 1) {
                        attributeNames[count] = attributeNames[count].substring(0, 1).toLowerCase() + attributeNames[count].substring(1);
                    }
                    if ((colType = methods[i2].getReturnType()).equals(class$java$lang$String == null ? ListVOControl.class$("java.lang.String") : class$java$lang$String)) {
                        this.colProperties[count] = new TextColumn();
                    } else if (colType.equals(class$java$lang$Integer == null ? ListVOControl.class$("java.lang.Integer") : class$java$lang$Integer) || colType.equals(class$java$lang$Long == null ? ListVOControl.class$("java.lang.Long") : class$java$lang$Long) || colType.equals(class$java$lang$Short == null ? ListVOControl.class$("java.lang.Short") : class$java$lang$Short) || colType.equals(Integer.TYPE) || colType.equals(Long.TYPE) || colType.equals(Short.TYPE)) {
                        this.colProperties[count] = new IntegerColumn();
                    } else if (colType.equals(class$java$math$BigDecimal == null ? ListVOControl.class$("java.math.BigDecimal") : class$java$math$BigDecimal) || colType.equals(class$java$lang$Double == null ? ListVOControl.class$("java.lang.Double") : class$java$lang$Double) || colType.equals(class$java$lang$Float == null ? ListVOControl.class$("java.lang.Float") : class$java$lang$Float) || colType.equals(Double.TYPE) || colType.equals(Float.TYPE)) {
                        this.colProperties[count] = new DecimalColumn();
                    } else if (colType.equals(class$java$lang$Boolean == null ? ListVOControl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                        this.colProperties[count] = new CheckBoxColumn();
                    } else if (colType.equals(class$java$util$Date == null ? ListVOControl.class$("java.util.Date") : class$java$util$Date)) {
                        this.colProperties[count] = new DateColumn();
                    } else if (colType.equals(class$java$sql$Date == null ? ListVOControl.class$("java.sql.Date") : class$java$sql$Date)) {
                        this.colProperties[count] = new DateColumn();
                    } else if (colType.equals(class$java$sql$Timestamp == null ? ListVOControl.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                        this.colProperties[count] = new DateColumn();
                    }
                    this.colProperties[count].setColumnName(attributeNames[count]);
                    if (this.colProperties[count].getHeaderColumnName().equals("columnname")) {
                        this.colProperties[count].setHeaderColumnName(String.valueOf(attributeNames[count].charAt(0)).toUpperCase() + attributeNames[count].substring(1));
                    }
                    this.colProperties[count].setColumnVisible(this.allColumnVisible);
                    this.colProperties[count].setPreferredWidth(this.allColumnPreferredWidth);
                    this.getters.put(this.colProperties[count].getColumnName(), methods[i2]);
                    ++count;
                }
                ++i2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.itemsVO = null;
        }
        catch (Error er) {
            er.printStackTrace();
            this.itemsVO = null;
        }
    }

    public final boolean isAllColumnVisible() {
        return this.allColumnVisible;
    }

    public final boolean isEnabled() {
        try {
            return this.list.isEnabled();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean isNullAsDefaultValue() {
        return this.nullAsDefaultValue;
    }

    public final boolean isReadOnly() {
        return this.isEnabled();
    }

    public final void reloadItems() {
        Response res;
        if (this.itemsDataLocator != null && this.itemsVO != null && !(res = this.itemsDataLocator.loadData(this.itemsVO.getClass())).isError()) {
            this.model.clear();
            List items = ((VOListResponse)res).getRows();
            int i = 0;
            while (i < items.size()) {
                this.model.addElement(items.get(i));
                ++i;
            }
            this.list.setModel(this.model);
            this.list.revalidate();
            this.list.repaint();
            this.list.setSelectedIndex(-1);
        }
    }

    public final void removeFocusListener(FocusListener l) {
        try {
            this.list.removeFocusListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void removeListSelectionListener(ListSelectionListener listener) {
        this.list.removeListSelectionListener(listener);
    }

    public final int search(String textToSeach) {
        return -1;
    }

    public final void setAllColumnPreferredWidth(int preferredWidth) {
        this.allColumnPreferredWidth = preferredWidth;
        int i = 0;
        while (i < this.colProperties.length) {
            this.colProperties[i].setPreferredWidth(preferredWidth);
            ++i;
        }
    }

    public final void setAllColumnVisible(boolean visible) {
        this.allColumnVisible = visible;
        int i = 0;
        while (i < this.colProperties.length) {
            this.colProperties[i].setColumnVisible(visible);
            this.colProperties[i].setColumnSelectable(visible);
            ++i;
        }
    }

    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
        this.list.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
        if (enabled) {
            this.list.setBackground((Color)UIManager.get("TextField.background"));
            this.list.setSelectionBackground(ClientSettings.BACKGROUND_SEL_COLOR);
        } else {
            this.list.setBackground((Color)UIManager.get("TextField.inactiveBackground"));
            try {
                this.list.setSelectionBackground(new Color(this.list.getBackground().getRed() - 10, this.list.getBackground().getGreen() - 10, this.list.getBackground().getBlue() - 10));
            }
            catch (Exception ex) {
                this.list.setSelectionBackground(Color.lightGray);
            }
        }
    }

    public final void setFixedCellHeight(int height) {
        this.list.setFixedCellHeight(height);
    }

    public final void setFixedCellWidth(int width) {
        this.list.setFixedCellWidth(width);
    }

    public final void setForeignKeyAttributeName(String foreignKeyAttributeName) {
        this.foreignKeyAttributeName = foreignKeyAttributeName;
    }

    public final void setLayoutOrientation(int layoutOrientation) {
        this.list.setLayoutOrientation(layoutOrientation);
    }

    public final void setListDataLocator(ItemsDataLocator comboDataLocator) {
        this.itemsDataLocator = comboDataLocator;
    }

    public final void setListValueObjectClassName(String comboValueObjectClassName) {
        this.initItemsVO(comboValueObjectClassName);
    }

    public final void setNullAsDefaultValue(boolean nullAsDefaultValue) {
        this.nullAsDefaultValue = nullAsDefaultValue;
    }

    public final void setPreferredWidthColumn(String itemsAttributeName, int preferredWidth) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(itemsAttributeName)) {
                this.colProperties[i].setPreferredWidth(preferredWidth);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setPreferredWidthColumn", "The attribute '" + (itemsAttributeName == null ? "null" : "'" + itemsAttributeName + "'") + "' does not exist.", null);
    }

    public final void setSelectedIndex(int index) {
        this.list.setSelectedIndex(index);
        try {
            this.list.scrollRectToVisible(this.list.getCellBounds(index, index));
        }
        catch (Exception ex) {
        }
    }

    public final void setSelectedIndices(int[] indices) {
        this.list.setSelectedIndices(indices);
        try {
            this.list.scrollRectToVisible(this.list.getCellBounds(indices[0], indices[0]));
        }
        catch (Exception ex) {
        }
    }

    public void setSelectionBackground(Color selectionBackground) {
        this.list.setSelectionBackground(selectionBackground);
    }

    public final void setSelectionForeground(Color selectionForeground) {
        this.list.setSelectionForeground(selectionForeground);
    }

    public final void setSelectionMode(int selectionMode) {
        this.list.setSelectionMode(selectionMode);
    }

    public final void setTextOrientation(ComponentOrientation o) {
        this.list.setComponentOrientation(o);
    }

    public void setValue(String attributeName, Object value) {
        if (this.form != null) {
            this.form.getVOModel().setValue(attributeName, value);
        }
    }

    public final void setValue(Object code) {
        if (this.list.getSelectionMode() == 0) {
            if (code == null) {
                this.list.setSelectedIndex(-1);
            }
            if (this.getFKAttributeName() == null) {
                return;
            }
            Object obj = null;
            try {
                int i = 0;
                while (i < this.model.getSize()) {
                    obj = ((Method)this.getters.get(this.getFKAttributeName())).invoke(this.model.getElementAt(i), new Object[0]);
                    if (code.equals(obj)) {
                        this.list.setSelectedIndex(i);
                        try {
                            this.list.scrollRectToVisible(this.list.getCellBounds(i, i));
                            this.list.repaint();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        return;
                    }
                    ++i;
                }
            }
            finally {
                this.list.setSelectedIndex(-1);
            }
        }
        if (this.form != null) {
            if (code == null || code instanceof List && ((List)code).size() == 0) {
                this.list.getSelectionModel().clearSelection();
                return;
            }
            if (code instanceof List) {
                List codes = (List)code;
                this.list.getSelectionModel().clearSelection();
                Object obj = null;
                int j = 0;
                while (j < codes.size()) {
                    try {
                        int i = 0;
                        while (i < this.model.getSize()) {
                            obj = this.model.getElementAt(i);
                            if (this.voequals(codes.get(j), obj)) {
                                this.list.getSelectionModel().addSelectionInterval(i, i);
                                try {
                                    this.list.scrollRectToVisible(this.list.getCellBounds(i, i));
                                    this.list.repaint();
                                }
                                catch (Exception ex) {}
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                    ++j;
                }
            } else {
                Logger.error(this.getClass().getName(), "setValue", "You must specify a java.util.List argument type", null);
            }
        } else {
            if (code == null || code instanceof List && ((List)code).size() == 0) {
                this.list.getSelectionModel().clearSelection();
                return;
            }
            if (this.getFKAttributeName() == null) {
                return;
            }
            if (code instanceof List) {
                List codes = (List)code;
                this.list.getSelectionModel().clearSelection();
                Object obj = null;
                int j = 0;
                while (j < codes.size()) {
                    try {
                        int i = 0;
                        while (i < this.model.getSize()) {
                            obj = ((Method)this.getters.get(this.getFKAttributeName())).invoke(this.model.getElementAt(i), new Object[0]);
                            if (codes.get(j).equals(obj)) {
                                this.list.getSelectionModel().addSelectionInterval(i, i);
                                try {
                                    this.list.scrollRectToVisible(this.list.getCellBounds(i, i));
                                    this.list.repaint();
                                }
                                catch (Exception ex) {}
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                    ++j;
                }
            } else {
                Logger.error(this.getClass().getName(), "setValue", "You must specify a java.util.List argument type", null);
            }
        }
    }

    public final void setValueIsAdjusting(boolean b) {
        this.list.setValueIsAdjusting(b);
    }

    public final void setVisibleColumn(String comboAttributeName, boolean visible) {
        try {
            int visibleIndex = -1;
            int index = -1;
            int i = 0;
            while (i < this.colProperties.length) {
                if (this.colProperties[i].isVisible()) {
                    visibleIndex = i;
                }
                if (this.colProperties[i].getColumnName().equals(comboAttributeName)) {
                    this.colProperties[i].setColumnVisible(visible);
                    this.colProperties[i].setColumnSelectable(visible);
                    index = i;
                    break;
                }
                ++i;
            }
            if (visible) {
                if (visibleIndex == -1) {
                    visibleIndex = 0;
                } else if (visibleIndex - 1 < this.colProperties.length) {
                    ++visibleIndex;
                }
                if (index > -1 && index != visibleIndex) {
                    Column infoTemp = this.colProperties[index];
                    this.colProperties[index] = this.colProperties[visibleIndex];
                    this.colProperties[visibleIndex] = infoTemp;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void setVisibleRowCount(int visibleRowCount) {
        this.list.setVisibleRowCount(visibleRowCount);
    }

    private void updateParentModel(ItemsParent itemsParent) {
        if (this.itemsVO != null && this.itemsMapper != null) {
            try {
                Enumeration itemsAttributes = this.itemsMapper.getItemsChangedAttributes();
                String attrName = null;
                while (itemsAttributes.hasMoreElements()) {
                    String itemsAttributeName = (String)itemsAttributes.nextElement();
                    if (itemsAttributeName.length() == 0) {
                        if (!this.itemsMapper.setParentAttribute(itemsParent, itemsAttributeName, this.itemsVO.getClass(), this.itemsVO)) {
                            Logger.error(this.getClass().getName(), "updateParentModel", "Error while setting items container value object.", null);
                            continue;
                        }
                        if (this.form == null || (attrName = this.itemsMapper.getParentAttributeName(itemsAttributeName)) == null || this.form == null) continue;
                        this.form.pull(attrName);
                        continue;
                    }
                    String itemsMethodName = "get" + String.valueOf(Character.toUpperCase(itemsAttributeName.charAt(0))) + itemsAttributeName.substring(1);
                    Method itemsMethod = this.itemsVO.getClass().getMethod(itemsMethodName, new Class[0]);
                    if (!this.itemsMapper.setParentAttribute(itemsParent, itemsAttributeName, itemsMethod.getReturnType(), itemsMethod.invoke((Object)this.itemsVO, new Object[0]))) {
                        Logger.error(this.getClass().getName(), "updateParentModel", "Error while setting items container value object.", null);
                        continue;
                    }
                    if (this.form == null || (attrName = this.itemsMapper.getParentAttributeName(itemsAttributeName)) == null || this.form == null) continue;
                    this.form.pull(attrName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            catch (Error er) {
                er.printStackTrace();
            }
        } else {
            Logger.error(this.getClass().getName(), "updateParentModel", "You must set 'itemsMapper' property", null);
        }
    }

    private boolean voequals(Object vo1, Object vo2) {
        if (!vo1.getClass().equals(vo2.getClass())) {
            return false;
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(vo1.getClass());
            MethodDescriptor[] m = info.getMethodDescriptors();
            int i = 0;
            while (i < m.length) {
                if (m[i].getMethod().getName().startsWith("get") && m[i].getMethod().getParameterTypes().length == 0 || m[i].getMethod().getName().startsWith("is") && m[i].getMethod().getParameterTypes().length == 0) {
                    Object o1 = m[i].getMethod().invoke(vo1, new Object[0]);
                    Object o2 = m[i].getMethod().invoke(vo2, new Object[0]);
                    if (o1 == null && o2 != null || o1 != null && o2 == null) {
                        return false;
                    }
                    if (o1 != null && o2 != null && !o1.equals(o2)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

