/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.Beans;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.text.DefaultCaret;
import org.openswing.swing.util.client.ClientSettings;

public class MultiLineLabelControl
extends JTextArea {
    private String label = null;
    private String toolTipText = null;

    public MultiLineLabelControl() {
        this.setUI();
        if (ClientSettings.TEXT_ORIENTATION != null) {
            this.setComponentOrientation(ClientSettings.TEXT_ORIENTATION);
        }
    }

    public final Font getFont() {
        return super.getFont();
    }

    public final String getLabel() {
        return this.label;
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public final ComponentOrientation getTextOrientation() {
        try {
            return this.getComponentOrientation();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final String getToolTipText() {
        return this.toolTipText;
    }

    public final void setEnabled(boolean enabled) {
    }

    public final void setFont(Font font) {
        super.setFont(font);
    }

    public final void setLabel(String label) {
        this.setText(label);
    }

    public final void setText(String label) {
        this.label = label;
        super.setText(ClientSettings.getInstance().getResources().getResource(label));
    }

    public final void setTextOrientation(ComponentOrientation o) {
        this.setComponentOrientation(o);
    }

    public final void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        if (!Beans.isDesignTime()) {
            super.setToolTipText(ClientSettings.getInstance().getResources().getResource(toolTipText));
        }
    }

    private void setUI() {
        LookAndFeel.installBorder(this, "Label.border");
        LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
        this.setCaret(new DefaultCaret(){

            protected void adjustVisibility(Rectangle nloc) {
            }
        });
        this.setRequestFocusEnabled(false);
        this.setEditable(false);
        this.setOpaque(false);
        this.setWrapStyleWord(true);
        this.setLineWrap(true);
        this.setFocusable(false);
    }

    public final void updateUI() {
        super.updateUI();
        this.setUI();
    }
}

