/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Component;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.DataController;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.ImageControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.NumericControl;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.properties.client.PropertyCellEditor;
import org.openswing.swing.properties.client.PropertyCellRenderer;
import org.openswing.swing.properties.client.PropertyGridController;
import org.openswing.swing.properties.client.PropertyGridModel;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class PropertyGridControl
extends JScrollPane
implements DataController {
    static /* synthetic */ Class array$B;
    private HashSet bindedButtons;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;
    private PropertyGridController controller;
    private HashMap currentValueButtons;
    private EditButton editButton = null;
    private JTable grid;
    private InsertButton insertButton = null;
    private PropertyGridModel model = new PropertyGridModel();
    private ReloadButton reloadButton = null;
    private SaveButton saveButton = null;

    public PropertyGridControl() {
        this.grid = new JTable(this.model);
        this.controller = new PropertyGridController();
        this.currentValueButtons = new HashMap();
        this.bindedButtons = new HashSet();
        try {
            this.jbInit();
            this.grid.getColumnModel().removeColumn(this.grid.getColumnModel().getColumn(2));
            this.grid.getColumnModel().removeColumn(this.grid.getColumnModel().getColumn(2));
            this.grid.getColumnModel().getColumn(1).setCellEditor(new PropertyCellEditor());
            this.grid.getColumnModel().getColumn(1).setCellRenderer(new PropertyCellRenderer());
            this.grid.setSelectionMode(0);
            this.grid.setAutoResizeMode(0);
            this.grid.setRowHeight(ClientSettings.CELL_HEIGHT);
            this.grid.setSelectionMode(0);
            this.grid.setSurrendersFocusOnKeystroke(true);
            this.grid.setBackground(ClientSettings.GRID_CELL_BACKGROUND);
            this.grid.setForeground(ClientSettings.GRID_CELL_FOREGROUND);
            this.grid.setSelectionBackground(ClientSettings.GRID_SELECTION_BACKGROUND);
            this.grid.setSelectionForeground(ClientSettings.GRID_SELECTION_FOREGROUND);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void addProperties(ValueObject valueObject) {
        try {
            PropertyDescriptor[] props = Introspector.getBeanInfo(valueObject.getClass()).getPropertyDescriptors();
            BaseInputControl inputControl = null;
            int i = 0;
            while (i < props.length) {
                inputControl = null;
                if (props[i].getPropertyType().equals(class$java$util$Date == null ? PropertyGridControl.class$("java.util.Date") : class$java$util$Date) || props[i].getPropertyType().equals(class$java$sql$Date == null ? PropertyGridControl.class$("java.sql.Date") : class$java$sql$Date) || props[i].getPropertyType().equals(class$java$sql$Timestamp == null ? PropertyGridControl.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                    inputControl = new DateControl();
                } else if (props[i].getPropertyType().equals(class$java$lang$Integer == null ? PropertyGridControl.class$("java.lang.Integer") : class$java$lang$Integer) || props[i].getPropertyType().equals(class$java$lang$Short == null ? PropertyGridControl.class$("java.lang.Short") : class$java$lang$Short) || props[i].getPropertyType().equals(class$java$lang$Long == null ? PropertyGridControl.class$("java.lang.Long") : class$java$lang$Long) || props[i].getPropertyType().equals(Integer.TYPE) || props[i].getPropertyType().equals(Short.TYPE) || props[i].getPropertyType().equals(Long.TYPE)) {
                    inputControl = new NumericControl();
                    ((NumericControl)inputControl).setDecimals(0);
                } else if (props[i].getPropertyType().equals(class$java$lang$Float == null ? PropertyGridControl.class$("java.lang.Float") : class$java$lang$Float) || props[i].getPropertyType().equals(class$java$lang$Double == null ? PropertyGridControl.class$("java.lang.Double") : class$java$lang$Double) || props[i].getPropertyType().equals(Float.TYPE) || props[i].getPropertyType().equals(Double.TYPE) || props[i].getPropertyType().equals(class$java$math$BigDecimal == null ? PropertyGridControl.class$("java.math.BigDecimal") : class$java$math$BigDecimal)) {
                    inputControl = new NumericControl();
                    ((NumericControl)inputControl).setDecimals(5);
                } else if (props[i].getPropertyType().equals(array$B == null ? PropertyGridControl.class$("[B") : array$B)) {
                    inputControl = new ImageControl();
                } else if (props[i].getPropertyType().equals(class$java$lang$String == null ? PropertyGridControl.class$("java.lang.String") : class$java$lang$String)) {
                    inputControl = new TextControl();
                }
                if (inputControl != null) {
                    inputControl.setAttributeName(props[i].getName());
                    this.model.addRow(new Object[]{ClientSettings.getInstance().getResources().getResource(props[i].getName()), props[i].getReadMethod().invoke((Object)valueObject, new Object[0]), inputControl, props[i].getReadMethod().invoke((Object)valueObject, new Object[0]), null});
                }
                ++i;
            }
        }
        catch (Exception ex) {
            Logger.error(this.getClass().getName(), "addProperties", ex.getMessage(), ex);
        }
    }

    public final boolean addProperty(String propertyDescription, InputControl inputControl, Object defaultValue, Object userObject) {
        this.model.addRow(new Object[]{propertyDescription, null, inputControl, defaultValue, userObject});
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final void clearData() {
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        this.grid.revalidate();
        this.grid.repaint();
    }

    public void copy() {
    }

    public void delete() {
    }

    public void edit() {
        if (this.getMode() == 0) {
            this.setMode(2);
            if (this.getInsertButton() != null) {
                this.getInsertButton().setEnabled(false);
            }
            if (this.getEditButton() != null) {
                this.getEditButton().setEnabled(false);
            }
            if (this.getReloadButton() != null) {
                this.getReloadButton().setEnabled(true);
            }
            if (this.getSaveButton() != null) {
                this.getSaveButton().setEnabled(true);
            }
            if (this.grid.getSelectedRow() == -1) {
                this.grid.setRowSelectionInterval(0, 0);
            }
            this.grid.setColumnSelectionInterval(0, 0);
            this.grid.requestFocus();
            boolean col = false;
            this.grid.editCellAt(this.grid.getSelectedRow(), this.grid.getSelectedColumn());
        } else {
            Logger.error(this.getClass().getName(), "edit", "Setting grid to edit mode is not allowed: grid must be in read only mode.", null);
        }
    }

    public void export() {
    }

    public void filterSort() {
    }

    public final int findRow(String attributeName) {
        int rowIndex = this.model.findRow(attributeName);
        if (rowIndex == -1) {
            Logger.error(this.getClass().getName(), "findRow", "The specified attribute '" + attributeName + "' does not exist.", null);
        }
        return rowIndex;
    }

    public final String getAttributeName(int rowIndex) {
        return this.model.getAttributeName(rowIndex);
    }

    public final HashSet getBindedButtons() {
        return this.bindedButtons;
    }

    public final PropertyGridController getController() {
        return this.controller;
    }

    public final boolean getCurrentValue(GenericButton button) {
        Boolean oldValue = (Boolean)this.currentValueButtons.get(button);
        if (oldValue == null) {
            return true;
        }
        return oldValue;
    }

    public EditButton getEditButton() {
        return this.editButton;
    }

    public String getFunctionId() {
        return "";
    }

    public final InputControl getInputControl(int rowIndex) {
        return this.model.getInputControl(rowIndex);
    }

    public final InputControl getInputControl(String attributeName) {
        int rowIndex = this.findRow(attributeName);
        if (rowIndex == -1) {
            return null;
        }
        return this.getInputControl(rowIndex);
    }

    public InsertButton getInsertButton() {
        return this.insertButton;
    }

    public final int getMode() {
        return this.model.getMode();
    }

    public final Object getOldPropertyValue(int rowIndex) {
        return this.model.getOldPropertyValue(rowIndex);
    }

    public final Object getOldPropertyValue(String attributeName) {
        int rowIndex = this.findRow(attributeName);
        if (rowIndex == -1) {
            return null;
        }
        return this.getOldPropertyValue(rowIndex);
    }

    public final void getProperties(ValueObject valueObject) {
        try {
            PropertyDescriptor[] props = Introspector.getBeanInfo(valueObject.getClass()).getPropertyDescriptors();
            int rowIndex = -1;
            Object obj = null;
            int i = 0;
            while (i < props.length) {
                rowIndex = this.model.findRow(props[i].getName());
                if (rowIndex != -1) {
                    obj = this.getPropertyValue(rowIndex);
                    try {
                        if (obj != null && !obj.getClass().equals(props[i].getPropertyType())) {
                            if ((class$java$util$Date == null ? PropertyGridControl.class$("java.util.Date") : class$java$util$Date).isAssignableFrom(obj.getClass())) {
                                if (props[i].getPropertyType().equals(class$java$sql$Date == null ? PropertyGridControl.class$("java.sql.Date") : class$java$sql$Date)) {
                                    obj = new Date(((java.util.Date)obj).getTime());
                                } else if (props[i].getPropertyType().equals(class$java$sql$Timestamp == null ? PropertyGridControl.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                                    obj = new Timestamp(((java.util.Date)obj).getTime());
                                }
                            } else if ((class$java$lang$Number == null ? PropertyGridControl.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(obj.getClass())) {
                                if (props[i].getPropertyType().equals(class$java$lang$Integer == null ? PropertyGridControl.class$("java.lang.Integer") : class$java$lang$Integer) || props[i].getPropertyType().equals(Integer.TYPE)) {
                                    obj = new Integer(((Number)obj).intValue());
                                } else if (props[i].getPropertyType().equals(class$java$lang$Long == null ? PropertyGridControl.class$("java.lang.Long") : class$java$lang$Long) || props[i].getPropertyType().equals(Long.TYPE)) {
                                    obj = new Long(((Number)obj).longValue());
                                } else if (props[i].getPropertyType().equals(class$java$lang$Short == null ? PropertyGridControl.class$("java.lang.Short") : class$java$lang$Short) || props[i].getPropertyType().equals(Short.TYPE)) {
                                    obj = new Short(((Number)obj).shortValue());
                                } else if (props[i].getPropertyType().equals(class$java$lang$Float == null ? PropertyGridControl.class$("java.lang.Float") : class$java$lang$Float) || props[i].getPropertyType().equals(Float.TYPE)) {
                                    obj = new Float(((Number)obj).floatValue());
                                } else if (props[i].getPropertyType().equals(class$java$lang$Double == null ? PropertyGridControl.class$("java.lang.Double") : class$java$lang$Double) || props[i].getPropertyType().equals(Double.TYPE)) {
                                    obj = new Double(((Number)obj).doubleValue());
                                } else if (props[i].getPropertyType().equals(class$java$math$BigDecimal == null ? PropertyGridControl.class$("java.math.BigDecimal") : class$java$math$BigDecimal)) {
                                    obj = new BigDecimal(((Number)obj).doubleValue());
                                }
                            }
                        }
                        props[i].getWriteMethod().invoke((Object)valueObject, obj);
                    }
                    catch (IllegalArgumentException ex1) {
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            Logger.error(this.getClass().getName(), "getProperties", ex.getMessage(), ex);
        }
    }

    public final int getPropertyNameWidth(int width) {
        return this.grid.getColumnModel().getColumn(0).getPreferredWidth();
    }

    public final Object getPropertyValue(int rowIndex) {
        return this.model.getPropertyValue(rowIndex);
    }

    public final Object getPropertyValue(String attributeName) {
        int rowIndex = this.findRow(attributeName);
        if (rowIndex == -1) {
            return null;
        }
        return this.getPropertyValue(rowIndex);
    }

    public final int getPropertyValueWidth() {
        return this.grid.getColumnModel().getColumn(1).getPreferredWidth();
    }

    public ReloadButton getReloadButton() {
        return this.reloadButton;
    }

    public SaveButton getSaveButton() {
        return this.saveButton;
    }

    public final Object getUserObject(int rowIndex) {
        return this.model.getUserObject(rowIndex);
    }

    public final Object getUserObject(String attributeName) {
        int rowIndex = this.findRow(attributeName);
        if (rowIndex == -1) {
            return null;
        }
        return this.getUserObject(rowIndex);
    }

    public void importData() {
    }

    public void insert() {
        if (this.getMode() == 0) {
            this.setMode(1);
            if (this.getInsertButton() != null) {
                this.getInsertButton().setEnabled(false);
            }
            if (this.getEditButton() != null) {
                this.getEditButton().setEnabled(false);
            }
            if (this.getReloadButton() != null) {
                this.getReloadButton().setEnabled(true);
            }
            if (this.getSaveButton() != null) {
                this.getSaveButton().setEnabled(true);
            }
            this.grid.setRowSelectionInterval(0, 0);
            this.grid.setColumnSelectionInterval(0, 0);
            this.grid.editCellAt(this.grid.getSelectedRow(), this.grid.getSelectedColumn());
        } else {
            Logger.error(this.getClass().getName(), "insert", "Setting grid to insert mode is not allowed: grid must be in read only mode.", null);
        }
    }

    public boolean isButtonDisabled(GenericButton button) {
        return false;
    }

    private void jbInit() throws Exception {
        this.getViewport().add((Component)this.grid, null);
    }

    public void reload() {
        int row = this.grid.getEditingRow();
        int col = this.grid.getEditingColumn();
        if (row >= 0 && col >= 0) {
            this.grid.getCellEditor(row, col).stopCellEditing();
        }
        if (this.getMode() != 0) {
            if (JOptionPane.showConfirmDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Cancel changes and reload data?"), ClientSettings.getInstance().getResources().getResource("Attention"), 0) == 0) {
                this.setMode(0);
                this.controller.loadData(this);
                this.grid.repaint();
                if (this.getInsertButton() != null) {
                    this.getInsertButton().setEnabled(true);
                }
                if (this.getEditButton() != null) {
                    this.getEditButton().setEnabled(true);
                }
                if (this.getReloadButton() != null) {
                    this.getReloadButton().setEnabled(true);
                }
                if (this.getSaveButton() != null) {
                    this.getSaveButton().setEnabled(false);
                }
                this.grid.setRowSelectionInterval(0, 0);
                this.grid.setColumnSelectionInterval(0, 0);
            }
        } else if (this.getMode() == 0) {
            this.setMode(0);
            this.controller.loadData(this);
            this.grid.repaint();
            if (this.getInsertButton() != null) {
                this.getInsertButton().setEnabled(true);
            }
            if (this.getEditButton() != null) {
                this.getEditButton().setEnabled(true);
            }
            if (this.getReloadButton() != null) {
                this.getReloadButton().setEnabled(true);
            }
            if (this.getSaveButton() != null) {
                this.getSaveButton().setEnabled(false);
            }
            this.grid.setRowSelectionInterval(0, 0);
            this.grid.setColumnSelectionInterval(0, 0);
        }
    }

    public final boolean save() {
        boolean response;
        block17: {
            response = false;
            if (this.getMode() != 0) {
                try {
                    if (!this.validateRows()) {
                        return false;
                    }
                }
                catch (Exception ex) {
                    Logger.error(this.getClass().getName(), "save", "Error on grid validation.", ex);
                }
                try {
                    int previousMode = this.getMode();
                    if (this.getMode() == 1) {
                        response = this.controller.insertRecords(this, this.model.getChangedRowNumbers());
                    } else if (this.getMode() == 2) {
                        response = this.controller.updateRecords(this, this.model.getChangedRowNumbers());
                    }
                    if (response) {
                        try {
                            int row = this.grid.getEditingRow();
                            int col = this.grid.getEditingColumn();
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                        this.model.setMode(0);
                        if (this.getReloadButton() != null) {
                            this.getReloadButton().setEnabled(true);
                        }
                        if (this.getSaveButton() != null) {
                            this.getSaveButton().setEnabled(false);
                        }
                        if (this.getEditButton() != null) {
                            this.getEditButton().setEnabled(true);
                        }
                        if (this.getInsertButton() != null) {
                            this.getInsertButton().setEnabled(true);
                        }
                        break block17;
                    }
                    JOptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while saving"), ClientSettings.getInstance().getResources().getResource("Saving Error"), 0);
                }
                catch (Exception ex) {
                    Logger.error(this.getClass().getName(), "save", "Error while saving.", ex);
                    JOptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while saving") + ":\n" + ex.getMessage(), ClientSettings.getInstance().getResources().getResource("Saving Error"), 0);
                }
            } else {
                Logger.error(this.getClass().getName(), "save", "Saving data is not allowed in read only mode.", null);
            }
        }
        return response;
    }

    public final void setController(PropertyGridController controller) {
        this.controller = controller;
    }

    public final void setCurrentValue(GenericButton button, boolean currentValue) {
        this.currentValueButtons.put(button, new Boolean(currentValue));
    }

    public void setEditButton(EditButton editButton) {
        if (this.editButton != null) {
            this.editButton.removeDataController(this);
        }
        this.editButton = editButton;
        if (editButton != null) {
            editButton.addDataController(this);
        }
        this.bindedButtons.add(editButton);
    }

    public void setInsertButton(InsertButton insertButton) {
        if (this.insertButton != null) {
            this.insertButton.removeDataController(this);
        }
        this.insertButton = insertButton;
        if (insertButton != null) {
            insertButton.addDataController(this);
        }
        this.bindedButtons.add(insertButton);
    }

    public final void setMode(int mode) {
        this.model.setMode(mode);
        this.grid.repaint();
    }

    public final void setProperties(ValueObject valueObject) {
        try {
            PropertyDescriptor[] props = Introspector.getBeanInfo(valueObject.getClass()).getPropertyDescriptors();
            int rowIndex = -1;
            int i = 0;
            while (i < props.length) {
                rowIndex = this.model.findRow(props[i].getName());
                if (rowIndex != -1) {
                    this.setPropertyValue(rowIndex, props[i].getReadMethod().invoke((Object)valueObject, new Object[0]));
                }
                ++i;
            }
        }
        catch (Exception ex) {
            Logger.error(this.getClass().getName(), "setProperties", ex.getMessage(), ex);
        }
    }

    public final void setPropertyNameWidth(int width) {
        this.grid.getColumnModel().getColumn(0).setPreferredWidth(width);
    }

    public final void setPropertyValue(int rowIndex, Object value) {
        this.model.setPropertyValue(rowIndex, value);
    }

    public final boolean setPropertyValue(String attributeName, Object value) {
        int rowIndex = this.findRow(attributeName);
        if (rowIndex == -1) {
            return false;
        }
        this.setPropertyValue(rowIndex, value);
        return true;
    }

    public final void setPropertyValueWidth(int width) {
        this.grid.getColumnModel().getColumn(1).setPreferredWidth(width);
    }

    public void setReloadButton(ReloadButton reloadButton) {
        if (this.reloadButton != null) {
            this.reloadButton.removeDataController(this);
        }
        this.reloadButton = reloadButton;
        if (reloadButton != null) {
            reloadButton.addDataController(this);
        }
        this.bindedButtons.add(reloadButton);
    }

    public void setSaveButton(SaveButton saveButton) {
        if (this.saveButton != null) {
            this.saveButton.removeDataController(this);
        }
        this.saveButton = saveButton;
        if (saveButton != null) {
            saveButton.addDataController(this);
            saveButton.setEnabled(false);
            this.bindedButtons.add(saveButton);
        }
    }

    public final boolean validateRows() {
        try {
            if (this.getMode() != 0) {
                int row = this.grid.getEditingRow();
                int col = this.grid.getEditingColumn();
                if (row >= 0 && col >= 0 && !this.grid.getCellEditor(row, col).stopCellEditing()) {
                    return false;
                }
                int[] rows = new int[]{};
                if (this.getMode() == 2) {
                    rows = this.model.getChangedRowNumbers();
                }
                int i = 0;
                while (i < rows.length) {
                    if (this.model.isRequired(i) && this.model.getValueAt(i, 1) == null) {
                        JOptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("A mandatory column is empty."), ClientSettings.getInstance().getResources().getResource("Value not valid"), 0);
                        this.grid.editCellAt(i, 1);
                        this.grid.requestFocus();
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return true;
        }
        catch (Throwable ex) {
            Logger.error(this.getClass().getName(), "validateRows", "Error on validating columns.", ex);
            return false;
        }
    }
}

