/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.client.OpenSwingTextField;
import org.openswing.swing.util.client.ClientSettings;

public class TextControl
extends BaseInputControl
implements InputControl {
    private int maxCharacters = 255;
    private boolean rpadding = false;
    protected JTextField textBox = this.getTextBox();
    private boolean trimText = false;
    private boolean upperCase = false;

    public TextControl(int columns) {
        this.textBox.setColumns(columns);
        this.textBox.setDisabledTextColor(UIManager.getColor("TextField.foreground"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.textBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        StringBuffer s = new StringBuffer(this.textBox.getColumns());
        int i = 0;
        while (i < this.textBox.getColumns()) {
            s.append("0");
            ++i;
        }
        this.setMinimumSize(new Dimension(this.textBox.getFontMetrics(this.textBox.getFont()).stringWidth(s.toString()), this.textBox.getPreferredSize().height));
        if (ClientSettings.TEXT_ORIENTATION != null) {
            this.setComponentOrientation(ClientSettings.TEXT_ORIENTATION);
        }
        this.addFocusListener();
        this.addKeyListener();
        this.initListeners();
    }

    public TextControl() {
        this(10);
    }

    public final void addActionListener(ActionListener listener) {
        try {
            this.textBox.addActionListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void addFocusListener(FocusListener listener) {
        try {
            this.textBox.addFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    private void addFocusListener() {
        this.textBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (TextControl.this.textBox.isEnabled() && TextControl.this.textBox.isEditable()) {
                    TextControl.this.setText(TextControl.this.textBox.getText());
                }
            }
        });
    }

    public final void addKeyListener(KeyListener listener) {
        try {
            this.textBox.addKeyListener(listener);
        }
        catch (Exception ex) {
        }
    }

    private void addKeyListener() {
        this.textBox.addKeyListener(new KeyAdapter(){
            private boolean consumeEvent = false;
            private boolean skip = false;

            public void keyPressed(KeyEvent e) {
                this.skip = false;
                this.consumeEvent = false;
                if (TextControl.this.upperCase && Character.isLetter(e.getKeyChar()) && !String.valueOf(e.getKeyChar()).toUpperCase().equals(String.valueOf(e.getKeyChar()))) {
                    TextControl.this.processKeyEvent(new KeyEvent((Component)e.getSource(), 400, e.getWhen(), e.getModifiers(), 0, String.valueOf(e.getKeyChar()).toUpperCase().charAt(0)));
                    this.consumeEvent = true;
                    e.consume();
                    return;
                }
                if (e.getKeyCode() == 8) {
                    this.skip = true;
                }
            }

            public final void keyReleased(KeyEvent e) {
                if (this.consumeEvent) {
                    e.consume();
                    return;
                }
                if (TextControl.this.textBox.getText() != null && TextControl.this.textBox.getText().length() > TextControl.this.maxCharacters) {
                    TextControl.this.setText(TextControl.this.textBox.getText().substring(0, TextControl.this.maxCharacters));
                } else if (TextControl.this.upperCase && TextControl.this.textBox.getText() != null && !TextControl.this.textBox.getText().equals(TextControl.this.textBox.getText().toUpperCase())) {
                    TextControl.this.setText(TextControl.this.textBox.getText().toUpperCase());
                }
            }

            public final void keyTyped(KeyEvent e) {
                if (this.consumeEvent) {
                    e.consume();
                    return;
                }
                if (this.skip) {
                    return;
                }
                if (TextControl.this.textBox.getText() != null && TextControl.this.textBox.getText().length() >= TextControl.this.maxCharacters) {
                    e.consume();
                }
            }
        });
    }

    public final JComponent getBindingComponent() {
        return this.textBox;
    }

    public final int getColumns() {
        return this.textBox.getColumns();
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public final String getText() {
        return this.textBox.getText();
    }

    protected JTextField getTextBox() {
        return new PlainTextField();
    }

    public final ComponentOrientation getTextOrientation() {
        try {
            return this.textBox.getComponentOrientation();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final Object getValue() {
        return this.textBox.getText();
    }

    public final boolean isEnabled() {
        try {
            return this.textBox.isEditable();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isRpadding() {
        return this.rpadding;
    }

    public boolean isTrimText() {
        return this.trimText;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void processKeyEvent(KeyEvent e) {
        try {
            ((OpenSwingTextField)((Object)this.textBox)).processKeyEvent(e);
        }
        catch (Throwable ex) {
        }
    }

    public final void removeActionListener(ActionListener listener) {
        try {
            this.textBox.removeActionListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void removeFocusListener(FocusListener listener) {
        try {
            this.textBox.removeFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void removeKeyListener(KeyListener listener) {
        try {
            this.textBox.removeKeyListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void select(int selectionStart, int selectionEnd) {
        this.textBox.select(selectionStart, selectionEnd);
    }

    public final void setColumns(int columns) {
        this.textBox.setColumns(columns);
        StringBuffer s = new StringBuffer(this.textBox.getColumns());
        int i = 0;
        while (i < this.textBox.getColumns()) {
            s.append("0");
            ++i;
        }
        this.setMinimumSize(new Dimension(this.textBox.getFontMetrics(this.textBox.getFont()).stringWidth(s.toString()), this.textBox.getPreferredSize().height));
    }

    public final void setEnabled(boolean enabled) {
        try {
            if (!enabled) {
                this.textBox.setForeground(UIManager.getColor("TextField.foreground"));
                this.textBox.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.textBox.setEditable(enabled);
        this.textBox.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public void setRpadding(boolean rpadding) {
        this.rpadding = rpadding;
    }

    public final void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (this.upperCase) {
            text = text.toUpperCase();
        }
        if (this.trimText) {
            text = text.trim();
        }
        if (this.rpadding) {
            StringBuffer auxtext = new StringBuffer(text);
            int i = text.length();
            while (i < this.maxCharacters) {
                auxtext.append(" ");
                ++i;
            }
            text = auxtext.toString();
        }
        if (text.length() > this.maxCharacters) {
            text = text.substring(0, this.maxCharacters);
        }
        this.textBox.setText(text);
    }

    public final void setTextOrientation(ComponentOrientation o) {
        this.textBox.setComponentOrientation(o);
    }

    public void setTrimText(boolean trimText) {
        this.trimText = trimText;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    public final void setValue(Object value) {
        this.setText((String)value);
    }

    class PlainTextField
    extends JTextField
    implements OpenSwingTextField {
        PlainTextField() {
        }

        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }
    }
}

