/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.customvo.client;

import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.customvo.client.CustomGridControlController;
import org.openswing.swing.customvo.java.CustomFieldVO;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.ComboColumn;
import org.openswing.swing.table.columns.client.DateColumn;
import org.openswing.swing.table.columns.client.DateTimeColumn;
import org.openswing.swing.table.columns.client.DecimalColumn;
import org.openswing.swing.table.columns.client.IntegerColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.columns.client.TimeColumn;

public final class CustomGridControl
extends GridControl {
    public CustomGridControl(CustomGridControlController controller) {
        try {
            this.setController(controller);
            this.setGridDataLocator(controller);
            this.setValueObjectClassName("org.openswing.swing.customvo.java.CustomValueObject");
            this.init(controller.getCustomFields());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(ArrayList customFields) throws Exception {
        TextColumn colText = null;
        DecimalColumn colDec = null;
        IntegerColumn colInt = null;
        ComboColumn colCombo = null;
        Column col = null;
        CustomFieldVO vo = null;
        int i = 0;
        while (i < customFields.size()) {
            int j;
            Domain domain;
            String[] values;
            vo = (CustomFieldVO)customFields.get(i);
            if (vo.getAttributeType() == 2) {
                col = new DateColumn();
            }
            if (vo.getAttributeType() == 3) {
                col = new DateTimeColumn();
            }
            if (vo.getAttributeType() == 4) {
                col = new TimeColumn();
            }
            if (vo.getAttributeType() == 1) {
                if (vo.getConstraintValues() != null && vo.getConstraintValues().length() > 0) {
                    values = vo.getConstraintValues().split(",");
                    domain = new Domain("DOMAIN_" + vo.getAttributeName());
                    j = 0;
                    while (j < values.length) {
                        domain.addDomainPair(new BigDecimal(values[j]), values[j]);
                        ++j;
                    }
                    colCombo.setDomain(domain);
                    col = colCombo;
                } else if (vo.getDecimals() == 0) {
                    colInt = new IntegerColumn();
                    colInt.setMaxValue((int)Math.pow(10.0, vo.getIntegers()));
                    col = colInt;
                } else {
                    colDec = new DecimalColumn();
                    colDec.setMaxValue((int)Math.pow(10.0, vo.getIntegers()));
                    colDec.setDecimals(vo.getDecimals());
                    col = colDec;
                }
            } else if (vo.getAttributeType() == 0) {
                if (vo.getConstraintValues() != null && vo.getConstraintValues().length() > 0) {
                    values = vo.getConstraintValues().split(",");
                    domain = new Domain("DOMAIN_" + vo.getAttributeName());
                    j = 0;
                    while (j < values.length) {
                        domain.addDomainPair(values[j], values[j]);
                        ++j;
                    }
                    colCombo.setDomain(domain);
                    col = colCombo;
                } else {
                    colText = new TextColumn();
                    colText.setMaxCharacters(vo.getMaxChars());
                    col = colText;
                }
            } else if (vo.getAttributeType() == 5) {
                if (vo.getConstraintValues() != null && vo.getConstraintValues().length() > 0) {
                    values = vo.getConstraintValues().split(",");
                    domain = new Domain("DOMAIN_" + vo.getAttributeName());
                    j = 0;
                    while (j < values.length) {
                        domain.addDomainPair(values[j], values[j]);
                        ++j;
                    }
                    colCombo.setDomain(domain);
                    col = colCombo;
                } else {
                    colText = new TextColumn();
                    colText.setMaxCharacters(vo.getMaxChars());
                    colText.setRpadding(true);
                    col = colText;
                }
            }
            col.setColumnName(vo.getAttributeName());
            col.setColumnFilterable(vo.isFilterable());
            col.setColumnRequired(vo.isRequired());
            col.setColumnSelectable(vo.isVisible());
            col.setColumnVisible(vo.isVisible());
            col.setColumnSortable(vo.isSortable());
            col.setEditableOnEdit(vo.isEditableOnEdit());
            col.setEditableOnInsert(vo.isEditableOnInsert());
            col.setHeaderColumnName(vo.getDescription());
            col.setPreferredWidth(vo.getColumnWidth());
            col.setSortingOrder(vo.getSortOrder());
            col.setSortVersus(vo.getSortVersus());
            this.getColumnContainer().add((Component)col, null);
            ++i;
        }
    }
}

