/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.export.java;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.openswing.swing.export.java.ComponentExportOptions;
import org.openswing.swing.export.java.ExportOptions;
import org.openswing.swing.export.java.GridExportCallbacks;
import org.openswing.swing.export.java.GridExportOptions;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;

public class ExportToCSV {
    private void appendRow(ExportOptions exportOptions, StringBuffer sb, Object vo, GridExportOptions opt, Hashtable gettersMethods, SimpleDateFormat sdf, SimpleDateFormat sdatf, SimpleDateFormat stf, String sep, int rownum, int tableType) throws Throwable {
        String aName = null;
        Method getter = null;
        Class<?> clazz = null;
        Object obj = null;
        int i = 0;
        while (i < opt.getExportColumns().size()) {
            clazz = vo.getClass();
            obj = vo;
            aName = opt.getExportAttrColumns().get(i).toString();
            while (aName.indexOf(".") != -1) {
                try {
                    getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                }
                catch (NoSuchMethodException ex2) {
                    getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                }
                aName = aName.substring(aName.indexOf(".") + 1);
                clazz = getter.getReturnType();
                obj = getter.invoke(obj, new Object[0]);
                if (obj == null) break;
            }
            try {
                getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            if (obj != null) {
                obj = getter.invoke(obj, new Object[0]);
            }
            if (obj != null) {
                if (obj instanceof Boolean) {
                    sb.append((Boolean)obj);
                } else if (obj.getClass().equals(Boolean.TYPE)) {
                    sb.append((Boolean)obj);
                } else if (obj instanceof java.sql.Date || obj instanceof Date || obj instanceof Timestamp) {
                    int type = (Integer)opt.getColumnsType().get(opt.getExportAttrColumns().get(i));
                    if (type == 1) {
                        sb.append(sdf.format((Date)obj));
                    } else if (type == 2) {
                        sb.append(sdatf.format((Date)obj));
                    } else if (type == 3) {
                        sb.append(stf.format((Date)obj));
                    }
                } else {
                    sb.append(this.encodeText(obj.toString(), sep));
                }
            }
            if (i < opt.getExportColumns().size() - 1) {
                sb.append(sep);
            }
            ++i;
        }
        sb.append("\n");
        if (opt.getCallbacks() != null) {
            if (tableType == 0) {
                this.processComponent(sb, exportOptions, opt.getCallbacks().getComponentPerRowInHeader((ValueObject)vo, rownum));
            } else if (tableType == 1) {
                ComponentExportOptions compOpts = opt.getCallbacks().getComponentPerRow((ValueObject)vo, rownum);
                if (compOpts != null) {
                    this.processComponent(sb, exportOptions, compOpts);
                }
            } else if (tableType == 2) {
                this.processComponent(sb, exportOptions, opt.getCallbacks().getComponentPerRowInFooter((ValueObject)vo, rownum));
            }
        }
    }

    private String encodeText(String text, String sep) {
        if (text.indexOf("\"") != -1) {
            StringBuffer sb = new StringBuffer("");
            int i = 0;
            while (i < text.length()) {
                sb.append(text.charAt(i));
                if (text.charAt(i) == '\"') {
                    sb.append("\"");
                }
                ++i;
            }
            text = sb.toString();
        }
        if (text.indexOf(sep) != -1 || text.indexOf("\n") != -1 || text.indexOf("\"") != -1) {
            text = "\"" + text + "\"";
        }
        return text;
    }

    public byte[] getDocument(ExportOptions opt) throws Throwable {
        StringBuffer sb = new StringBuffer("");
        Object obj = null;
        int i = 0;
        while (i < opt.getComponentsExportOptions().size()) {
            obj = opt.getComponentsExportOptions().get(i);
            this.processComponent(sb, opt, obj);
            ++i;
        }
        byte[] doc = sb.toString().getBytes();
        return doc;
    }

    private void prepareGenericComponent(StringBuffer sb, ExportOptions exportOptions, ComponentExportOptions opt) throws Throwable {
        String sep;
        Object[] row = null;
        Object obj = null;
        SimpleDateFormat sdatf = new SimpleDateFormat(exportOptions.getDateTimeFormat());
        String string = sep = exportOptions.getExportType().endsWith("CSV (,)") ? "," : ";";
        if (opt.getCellsContent() != null) {
            int i = 0;
            while (i < opt.getCellsContent().length) {
                row = opt.getCellsContent()[i];
                int j = 0;
                while (j < row.length) {
                    obj = row[j];
                    if (obj != null) {
                        if (obj instanceof Boolean) {
                            sb.append((Boolean)obj);
                        } else if (obj.getClass().equals(Boolean.TYPE)) {
                            sb.append((Boolean)obj);
                        } else if (obj instanceof java.sql.Date || obj instanceof Date || obj instanceof Timestamp) {
                            sb.append(sdatf.format((Date)obj));
                        } else {
                            sb.append(this.encodeText(obj.toString(), sep));
                        }
                    }
                    if (j < row.length - 1) {
                        sb.append(sep);
                    }
                    ++j;
                }
                sb.append("\n");
                ++i;
            }
        }
    }

    private void prepareGrid(StringBuffer sb, ExportOptions exportOptions, GridExportOptions opt) throws Throwable {
        int j;
        String[] filters;
        String sep;
        String methodName = null;
        String attributeName = null;
        Hashtable<String, Method> gettersMethods = new Hashtable<String, Method>();
        Method[] voMethods = opt.getValueObjectType().getMethods();
        int i = 0;
        while (i < voMethods.length) {
            methodName = voMethods[i].getName();
            if (methodName.startsWith("get")) {
                attributeName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                if (opt.getExportAttrColumns().contains(attributeName)) {
                    gettersMethods.put(attributeName, voMethods[i]);
                }
            }
            ++i;
        }
        Response response = null;
        int start = 0;
        int rownum = 0;
        Object value = null;
        Object vo = null;
        String string = sep = exportOptions.getExportType().endsWith("CSV (,)") ? "," : ";";
        if (opt.getTitle() != null && !opt.getTitle().equals("")) {
            sb.append(opt.getTitle()).append("\n\n");
        }
        if ((filters = opt.getFilteringConditions()) != null) {
            int i2 = 0;
            while (i2 < filters.length) {
                sb.append(filters[i2]).append("\n");
                ++i2;
            }
            sb.append("\n");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(exportOptions.getDateFormat());
        SimpleDateFormat sdatf = new SimpleDateFormat(exportOptions.getDateTimeFormat());
        SimpleDateFormat stf = new SimpleDateFormat(exportOptions.getTimeFormat());
        int j2 = 0;
        while (j2 < opt.getTopRows().size()) {
            vo = opt.getTopRows().get(j2);
            this.appendRow(exportOptions, sb, vo, opt, gettersMethods, sdf, sdatf, stf, sep, j2, 0);
            ++j2;
        }
        do {
            if ((response = opt.getGridDataLocator().loadData(1, start, opt.getFilteredColumns(), opt.getCurrentSortedColumns(), opt.getCurrentSortedVersusColumns(), opt.getValueObjectType(), opt.getOtherGridParams())).isError()) {
                throw new Exception(response.getErrorMessage());
            }
            j = 0;
            while (j < ((VOListResponse)response).getRows().size()) {
                vo = ((VOListResponse)response).getRows().get(j);
                this.appendRow(exportOptions, sb, vo, opt, gettersMethods, sdf, sdatf, stf, sep, rownum, 1);
                ++rownum;
                ++j;
            }
            start += ((VOListResponse)response).getRows().size();
        } while (((VOListResponse)response).isMoreRows() && rownum < opt.getMaxRows());
        j = 0;
        while (j < opt.getBottomRows().size()) {
            vo = opt.getBottomRows().get(j);
            this.appendRow(exportOptions, sb, vo, opt, gettersMethods, sdf, sdatf, stf, sep, j, 2);
            ++j;
        }
    }

    private void processComponent(StringBuffer sb, ExportOptions exportOptions, Object obj) throws Throwable {
        if (obj != null) {
            GridExportCallbacks callbacks = null;
            if (obj instanceof GridExportOptions) {
                callbacks = ((GridExportOptions)obj).getCallbacks();
                if (callbacks != null) {
                    this.processComponent(sb, exportOptions, callbacks.getHeaderComponent());
                }
                this.prepareGrid(sb, exportOptions, (GridExportOptions)obj);
                if (callbacks != null) {
                    this.processComponent(sb, exportOptions, callbacks.getFooterComponent());
                }
            } else if (obj instanceof ComponentExportOptions) {
                this.prepareGenericComponent(sb, exportOptions, (ComponentExportOptions)obj);
            } else {
                return;
            }
            sb.append("\n");
        }
    }
}

