/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.export.java;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import org.openswing.swing.export.java.ComponentExportOptions;
import org.openswing.swing.export.java.ExportOptions;
import org.openswing.swing.export.java.GridExportCallbacks;
import org.openswing.swing.export.java.GridExportOptions;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;

public class ExportToPDF {
    private void appendRow(Document document, ExportOptions exportOptions, PdfPTable table, Object vo, GridExportOptions opt, Hashtable gettersMethods, SimpleDateFormat sdf, SimpleDateFormat sdatf, SimpleDateFormat stf, int row, int tableType) throws Throwable {
        String aName = null;
        Method getter = null;
        Class<?> clazz = null;
        Object obj = null;
        int i = 0;
        while (i < opt.getExportColumns().size()) {
            clazz = vo.getClass();
            obj = vo;
            aName = opt.getExportAttrColumns().get(i).toString();
            while (aName.indexOf(".") != -1) {
                try {
                    getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                }
                catch (NoSuchMethodException ex2) {
                    getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                }
                aName = aName.substring(aName.indexOf(".") + 1);
                clazz = getter.getReturnType();
                obj = getter.invoke(obj, new Object[0]);
                if (obj == null) break;
            }
            try {
                getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            if (obj != null) {
                obj = getter.invoke(obj, new Object[0]);
            }
            if (obj != null) {
                if (obj instanceof Date || obj instanceof java.util.Date || obj instanceof Timestamp) {
                    int type = (Integer)opt.getColumnsType().get(opt.getExportAttrColumns().get(i));
                    if (type == 1) {
                        table.getDefaultCell().setHorizontalAlignment(1);
                        table.addCell(new Phrase(sdf.format((java.util.Date)obj), exportOptions.getExportToPDFAdapter().getRowFont(aName)));
                    } else if (type == 2) {
                        table.getDefaultCell().setHorizontalAlignment(1);
                        table.addCell(new Phrase(sdatf.format((java.util.Date)obj), exportOptions.getExportToPDFAdapter().getRowFont(aName)));
                    } else if (type == 3) {
                        table.getDefaultCell().setHorizontalAlignment(1);
                        table.addCell(new Phrase(stf.format((java.util.Date)obj), exportOptions.getExportToPDFAdapter().getRowFont(aName)));
                    }
                } else {
                    table.getDefaultCell().setHorizontalAlignment(0);
                    table.addCell(new Phrase(obj.toString(), exportOptions.getExportToPDFAdapter().getRowFont(aName)));
                }
            } else {
                table.getDefaultCell().setHorizontalAlignment(0);
                table.addCell(new Phrase("", exportOptions.getExportToPDFAdapter().getRowFont(aName)));
            }
            ++i;
        }
        if (opt.getCallbacks() != null) {
            if (tableType == 0) {
                this.processComponent(table, opt.getExportColumns().size(), document, exportOptions, opt.getCallbacks().getComponentPerRowInHeader((ValueObject)vo, row));
            } else if (tableType == 1) {
                this.processComponent(table, opt.getExportColumns().size(), document, exportOptions, opt.getCallbacks().getComponentPerRow((ValueObject)vo, row));
            } else if (tableType == 2) {
                this.processComponent(table, opt.getExportColumns().size(), document, exportOptions, opt.getCallbacks().getComponentPerRowInFooter((ValueObject)vo, row));
            }
        }
    }

    public byte[] getDocument(ExportOptions opt) throws Throwable {
        Document document = new Document(new Rectangle(PageSize.A4.width(), PageSize.A4.height()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfWriter w = PdfWriter.getInstance((Document)document, (OutputStream)baos);
        document.open();
        Object obj = null;
        int i = 0;
        while (i < opt.getComponentsExportOptions().size()) {
            obj = opt.getComponentsExportOptions().get(i);
            this.processComponent(null, 0, document, opt, obj);
            ++i;
        }
        document.close();
        return baos.toByteArray();
    }

    private void prepareGenericComponent(PdfPTable parentTable, int parentTableCols, Document document, ExportOptions exportOptions, ComponentExportOptions opt) throws Throwable {
        if (opt.getCellsContent() == null || opt.getCellsContent().length == 0) {
            return;
        }
        int cols = opt.getCellsContent()[0].length;
        Object[] row = null;
        Object obj = null;
        SimpleDateFormat sdatf = new SimpleDateFormat(exportOptions.getDateTimeFormat());
        int[] headerwidths = new int[cols];
        int i = 0;
        while (i < headerwidths.length) {
            headerwidths[i] = (int)PageSize.A4.width() / cols;
            ++i;
        }
        PdfPTable table = new PdfPTable(cols);
        table.setWidths(headerwidths);
        table.setWidthPercentage(90.0f);
        table.getDefaultCell().setBorderWidth(2.0f);
        table.getDefaultCell().setBorderColor(Color.black);
        table.getDefaultCell().setGrayFill(exportOptions.getExportToPDFAdapter().getHeaderGrayFill());
        table.getDefaultCell().setPadding(3.0f);
        table.getDefaultCell().setHorizontalAlignment(1);
        table.getDefaultCell().setVerticalAlignment(5);
        table.setHeaderRows(0);
        table.getDefaultCell().setBorderWidth(0.0f);
        table.getDefaultCell().setHorizontalAlignment(0);
        table.getDefaultCell().setVerticalAlignment(4);
        int i2 = 0;
        while (i2 < opt.getCellsContent().length) {
            row = opt.getCellsContent()[i2];
            int j = 0;
            while (j < row.length) {
                obj = row[j];
                if (obj != null) {
                    if (obj instanceof Date || obj instanceof java.util.Date || obj instanceof Timestamp) {
                        table.getDefaultCell().setHorizontalAlignment(1);
                        table.addCell(new Phrase(sdatf.format((java.util.Date)obj), exportOptions.getExportToPDFAdapter().getGenericComponentFont(i2, j, obj)));
                    } else {
                        table.getDefaultCell().setHorizontalAlignment(0);
                        table.addCell(new Phrase(obj.toString(), exportOptions.getExportToPDFAdapter().getGenericComponentFont(i2, j, obj)));
                    }
                } else {
                    table.getDefaultCell().setHorizontalAlignment(0);
                    table.addCell(new Phrase("", exportOptions.getExportToPDFAdapter().getGenericComponentFont(i2, j, null)));
                }
                ++j;
            }
            ++i2;
        }
        if (parentTable != null) {
            PdfPCell cell = new PdfPCell(table);
            cell.setColspan(parentTableCols);
            parentTable.addCell(cell);
        } else {
            document.add((Element)table);
        }
    }

    private void prepareGrid(PdfPTable parentTable, int parentTableCols, Document document, ExportOptions exportOptions, GridExportOptions opt) throws Throwable {
        String[] filters;
        String methodName = null;
        String attributeName = null;
        Hashtable<String, Method> gettersMethods = new Hashtable<String, Method>();
        Method[] voMethods = opt.getValueObjectType().getMethods();
        int i = 0;
        while (i < voMethods.length) {
            methodName = voMethods[i].getName();
            if (methodName.startsWith("get")) {
                attributeName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                if (opt.getExportAttrColumns().contains(attributeName)) {
                    gettersMethods.put(attributeName, voMethods[i]);
                }
            }
            ++i;
        }
        Response response = null;
        int start = 0;
        int rownum = 0;
        Object value = null;
        Object vo = null;
        SimpleDateFormat sdf = new SimpleDateFormat(exportOptions.getDateFormat());
        SimpleDateFormat sdatf = new SimpleDateFormat(exportOptions.getDateTimeFormat());
        SimpleDateFormat stf = new SimpleDateFormat(exportOptions.getTimeFormat());
        int[] headerwidths = new int[opt.getExportColumns().size()];
        int total = 0;
        int i2 = 0;
        while (i2 < opt.getExportColumns().size()) {
            headerwidths[i2] = Math.max(opt.getExportColumns().get(i2).toString().length() * 10, (Integer)opt.getColumnsWidth().get(opt.getExportAttrColumns().get(i2)));
            total += headerwidths[i2];
            ++i2;
        }
        Paragraph line = null;
        if (opt.getTitle() != null && !opt.getTitle().equals("")) {
            line = new Paragraph(opt.getTitle(), exportOptions.getExportToPDFAdapter().getFontTitle());
            line.setAlignment(1);
            document.add((Element)line);
            document.add((Element)new Paragraph("\n"));
        }
        if ((filters = opt.getFilteringConditions()) != null) {
            int i3 = 0;
            while (i3 < filters.length) {
                line = new Paragraph(filters[i3]);
                document.add((Element)line);
                ++i3;
            }
            document.add((Element)new Paragraph("\n"));
        }
        PdfPTable table = new PdfPTable(opt.getExportColumns().size());
        table.setWidths(headerwidths);
        table.setWidthPercentage(90.0f);
        table.getDefaultCell().setBorderWidth(2.0f);
        table.getDefaultCell().setBorderColor(Color.black);
        table.getDefaultCell().setGrayFill(exportOptions.getExportToPDFAdapter().getHeaderGrayFill());
        table.getDefaultCell().setPadding(3.0f);
        table.getDefaultCell().setHorizontalAlignment(1);
        table.getDefaultCell().setVerticalAlignment(5);
        int i4 = 0;
        while (i4 < opt.getExportColumns().size()) {
            table.addCell(new Phrase(opt.getExportColumns().get(i4).toString(), exportOptions.getExportToPDFAdapter().getHeaderFont(opt.getExportAttrColumns().get(i4).toString())));
            ++i4;
        }
        table.setHeaderRows(1);
        table.getDefaultCell().setBorderWidth(1.0f);
        table.getDefaultCell().setHorizontalAlignment(0);
        table.getDefaultCell().setVerticalAlignment(4);
        int j = 0;
        while (j < opt.getTopRows().size()) {
            table.getDefaultCell().setGrayFill(exportOptions.getExportToPDFAdapter().getTopRowsGrayFill(j));
            vo = opt.getTopRows().get(j);
            this.appendRow(document, exportOptions, table, vo, opt, gettersMethods, sdf, sdatf, stf, j, 0);
            ++j;
        }
        do {
            if ((response = opt.getGridDataLocator().loadData(1, start, opt.getFilteredColumns(), opt.getCurrentSortedColumns(), opt.getCurrentSortedVersusColumns(), opt.getValueObjectType(), opt.getOtherGridParams())).isError()) {
                throw new Exception(response.getErrorMessage());
            }
            boolean even = false;
            int j2 = 0;
            while (j2 < ((VOListResponse)response).getRows().size()) {
                if (even) {
                    table.getDefaultCell().setGrayFill(exportOptions.getExportToPDFAdapter().getEvenRowsGrayFill());
                    even = false;
                } else {
                    table.getDefaultCell().setGrayFill(exportOptions.getExportToPDFAdapter().getOddRowsGrayFill());
                    even = true;
                }
                vo = ((VOListResponse)response).getRows().get(j2);
                this.appendRow(document, exportOptions, table, vo, opt, gettersMethods, sdf, sdatf, stf, rownum, 1);
                ++rownum;
                ++j2;
            }
            start += ((VOListResponse)response).getRows().size();
        } while (((VOListResponse)response).isMoreRows() && rownum < opt.getMaxRows());
        int j3 = 0;
        while (j3 < opt.getBottomRows().size()) {
            table.getDefaultCell().setGrayFill(exportOptions.getExportToPDFAdapter().getBottomRowsGrayFill(j3));
            vo = opt.getBottomRows().get(j3);
            this.appendRow(document, exportOptions, table, vo, opt, gettersMethods, sdf, sdatf, stf, j3, 2);
            ++j3;
        }
        if (parentTable != null) {
            PdfPCell cell = new PdfPCell(table);
            cell.setColspan(parentTableCols);
            parentTable.addCell(cell);
        } else {
            document.add((Element)table);
        }
    }

    private void processComponent(PdfPTable table, int parentTableCols, Document document, ExportOptions opt, Object obj) throws Throwable {
        if (obj != null) {
            GridExportCallbacks callbacks = null;
            if (obj instanceof GridExportOptions) {
                callbacks = ((GridExportOptions)obj).getCallbacks();
                if (callbacks != null) {
                    this.processComponent(table, parentTableCols, document, opt, callbacks.getHeaderComponent());
                }
                this.prepareGrid(table, parentTableCols, document, opt, (GridExportOptions)obj);
                if (callbacks != null) {
                    this.processComponent(table, parentTableCols, document, opt, callbacks.getFooterComponent());
                }
            } else if (obj instanceof ComponentExportOptions) {
                this.prepareGenericComponent(table, parentTableCols, document, opt, (ComponentExportOptions)obj);
            } else {
                return;
            }
            if (table != null) {
                PdfPCell cell = new PdfPCell((Phrase)new Paragraph("\n"));
                cell.setColspan(parentTableCols);
                table.addCell(cell);
            } else {
                document.add((Element)new Paragraph("\n"));
            }
        }
    }
}

