/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.items.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.DateColumn;
import org.openswing.swing.util.client.ClientSettings;

public class ItemRenderer
extends JPanel
implements ListCellRenderer,
Serializable {
    private int bottomMargin = 0;
    private Column[] colProperties = null;
    private Hashtable getters = new Hashtable();
    private int leftMargin = 0;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private int rightMargin = 0;
    private SimpleDateFormat sdf = null;
    private int topMargin = 0;
    private Object vo = null;

    public ItemRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.sdf = new SimpleDateFormat(ClientSettings.getInstance().getResources().getDateMask(1));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        this.vo = value;
        this.repaint();
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension size = new JLabel(" ").getPreferredSize();
        if (this.colProperties != null) {
            int width = 0;
            int i = 0;
            while (i < this.colProperties.length) {
                if (this.colProperties[i].isColumnVisible()) {
                    width += this.colProperties[i].getPreferredWidth() + 6;
                }
                ++i;
            }
            size = new Dimension(width, (int)size.getHeight());
        }
        return size;
    }

    public void init(Hashtable getters, Column[] colProperties, int leftMargin, int rightMargin, int topMargin, int bottomMargin) {
        this.getters = getters;
        this.colProperties = colProperties;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.vo != null && this.getters != null && this.colProperties != null) {
            int x = 0;
            Object val = null;
            String valS = null;
            Color col = g.getColor();
            Color col2 = Color.gray;
            int i = 0;
            while (i < this.colProperties.length) {
                if (this.colProperties[i].isColumnVisible()) {
                    try {
                        val = ((Method)this.getters.get(this.colProperties[i].getColumnName())).invoke(this.vo, new Object[0]);
                        valS = val != null ? (this.colProperties[i] instanceof DateColumn ? this.sdf.format((Date)val) : val.toString()) : null;
                        if (x != 0) {
                            g.setColor(col2);
                            g.drawLine(x - 3, 0, x - 3, this.getHeight());
                        }
                        if (valS != null) {
                            g.setColor(col);
                            int hOffset = Math.max(0, (this.getHeight() + 1 - g.getFontMetrics().getHeight()) / 2);
                            g.drawString(valS, x + this.leftMargin, this.getHeight() + this.topMargin - g.getFontMetrics().getDescent() - hOffset);
                        }
                        x += this.colProperties[i].getPreferredWidth() + 6;
                    }
                    catch (Exception ex) {
                    }
                }
                ++i;
            }
            g.setColor(col);
        }
    }

    public static class UIResource
    extends ItemRenderer
    implements javax.swing.plaf.UIResource {
    }
}

