/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.mdi.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.openswing.swing.mdi.client.AboutDialog_gcButton_actionAdapter;
import org.openswing.swing.mdi.client.AboutDialog_imageButton_actionAdapter;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class AboutDialog
extends JDialog {
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2;
    JButton gcButton;
    JPanel gcPanel;
    GridBagLayout gridBagLayout1;
    JButton imageButton;
    JPanel infoPanel;
    JLabel memLabel;
    JScrollPane scrollPane;
    JTabbedPane tabbedPane = new JTabbedPane();
    JEditorPane text;

    public AboutDialog(MDIFrame frame, String aboutText, String aboutImageName) {
        super(frame, ClientSettings.getInstance().getResources().getResource("about") + " " + frame.getTitle(), true);
        this.imageButton = new JButton();
        this.infoPanel = new JPanel();
        this.borderLayout2 = new BorderLayout();
        this.scrollPane = new JScrollPane();
        this.gcPanel = new JPanel();
        this.gcButton = new JButton();
        this.text = new JEditorPane();
        this.gridBagLayout1 = new GridBagLayout();
        this.memLabel = new JLabel();
        try {
            this.jbInit();
            Image aboutImage = null;
            if (aboutImageName != null) {
                aboutImage = ClientUtils.getImage(aboutImageName);
            }
            if (aboutImage != null) {
                this.imageButton.setIcon(new ImageIcon(aboutImage));
                this.setSize(aboutImage.getWidth(this) + 10, aboutImage.getHeight(this) + 30);
            } else {
                this.getContentPane().remove(this.tabbedPane);
                this.getContentPane().add((Component)this.infoPanel, "Center");
                this.setSize(400, 300);
            }
            this.setMem();
            if (aboutText.toLowerCase().trim().startsWith("<html>")) {
                this.text.setContentType("text/html");
                this.text.addHyperlinkListener(new Hyperactive());
            }
            this.text.setText(aboutText);
            ClientUtils.centerDialog(frame, this);
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void gcButton_actionPerformed(ActionEvent e) {
        System.gc();
        this.setMem();
    }

    void imageButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.infoPanel.setLayout(this.borderLayout2);
        this.gcButton.setMnemonic(ClientSettings.getInstance().getResources().getResource("forcegcmnemonic").charAt(0));
        this.gcButton.setText(ClientSettings.getInstance().getResources().getResource("Force GC"));
        this.gcButton.addActionListener(new AboutDialog_gcButton_actionAdapter(this));
        this.text.setOpaque(false);
        this.text.setEditable(false);
        this.gcPanel.setLayout(this.gridBagLayout1);
        this.imageButton.addActionListener(new AboutDialog_imageButton_actionAdapter(this));
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.tabbedPane.add((Component)this.imageButton, ClientSettings.getInstance().getResources().getResource("imageButton"));
        this.tabbedPane.add((Component)this.infoPanel, ClientSettings.getInstance().getResources().getResource("infoPanel"));
        this.infoPanel.add((Component)this.scrollPane, "Center");
        this.infoPanel.add((Component)this.gcPanel, "South");
        this.gcPanel.add((Component)this.gcButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.gcPanel.add((Component)this.memLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.scrollPane.getViewport().add((Component)this.text, null);
    }

    private void setMem() {
        long total = Runtime.getRuntime().totalMemory();
        this.memLabel.setText(ClientSettings.getInstance().getResources().getResource("Java Heap") + ":     " + (total - Runtime.getRuntime().freeMemory()) / 1024L / 1024L + "MB " + ClientSettings.getInstance().getResources().getResource("used") + ",     " + total / 1024L / 1024L + "MB " + ClientSettings.getInstance().getResources().getResource("allocated"));
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        ClientUtils.displayURL(e.getURL().toExternalForm());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

