/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.mdi.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openswing.swing.internationalization.java.Language;
import org.openswing.swing.mdi.client.ChangeLanguageDialog_cancelButton_actionAdapter;
import org.openswing.swing.mdi.client.ChangeLanguageDialog_changeButton_actionAdapter;
import org.openswing.swing.mdi.client.MDIController;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class ChangeLanguageDialog
extends JDialog {
    BorderLayout borderLayout2;
    JButton cancelButton;
    JButton changeButton;
    private MDIController controller = null;
    private MDIFrame frame = null;
    GridBagLayout gridBagLayout1;
    JList langList;
    JPanel mainPanel = new JPanel();
    JScrollPane scrollPane;

    public ChangeLanguageDialog(MDIFrame frame, MDIController controller) {
        super(frame, ClientSettings.getInstance().getResources().getResource("change language"), true);
        this.borderLayout2 = new BorderLayout();
        this.gridBagLayout1 = new GridBagLayout();
        this.scrollPane = new JScrollPane();
        this.changeButton = new JButton();
        this.cancelButton = new JButton();
        this.langList = new JList();
        this.frame = frame;
        this.controller = controller;
        try {
            this.jbInit();
            this.init(controller.getLanguages());
            this.setSize(300, 200);
            ClientUtils.centerDialog(frame, this);
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void changeButton_actionPerformed(ActionEvent e) {
        if (this.langList.getSelectedIndex() == -1) {
            return;
        }
        Language lang = (Language)this.langList.getModel().getElementAt(this.langList.getSelectedIndex());
        ClientSettings.getInstance().setLanguage(lang.getLanguageId());
        this.setVisible(false);
        this.frame.setVisible(false);
        this.frame.dispose();
        try {
            if (ClientUtils.getServerURL() != null) {
                ClientUtils.getData("changeLanguage", lang.getLanguageId());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        new MDIFrame(this.controller);
    }

    private void init(ArrayList languages) {
        DefaultListModel model = new DefaultListModel();
        int i = 0;
        while (i < languages.size()) {
            model.addElement(languages.get(i));
            ++i;
        }
        this.langList.setModel(model);
        this.langList.revalidate();
        this.langList.setSelectedIndex(0);
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.getContentPane().setLayout(this.borderLayout2);
        this.changeButton.setMnemonic(ClientSettings.getInstance().getResources().getResource("changemnemonic").charAt(0));
        this.changeButton.setText(ClientSettings.getInstance().getResources().getResource("change language"));
        this.changeButton.addActionListener(new ChangeLanguageDialog_changeButton_actionAdapter(this));
        this.cancelButton.setMnemonic(ClientSettings.getInstance().getResources().getResource("cancelmnemonic").charAt(0));
        this.cancelButton.setText(ClientSettings.getInstance().getResources().getResource("cancel"));
        this.cancelButton.addActionListener(new ChangeLanguageDialog_cancelButton_actionAdapter(this));
        this.langList.setSelectionMode(0);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 15), 0, 0));
        this.mainPanel.add((Component)this.changeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(30, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.scrollPane.getViewport().add((Component)this.langList, null);
    }
}

