/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.mdi.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.EventListener;
import java.util.Properties;
import javax.swing.DesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.filechooser.FileFilter;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIController;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class DesktopPane
extends JDesktopPane
implements InternalFrameListener {
    private Image background = null;
    private String backgroundFileName = null;
    static /* synthetic */ Class class$javax$swing$event$InternalFrameListener;
    protected Component layeringComp;
    private boolean modal;
    protected JPanel modalPane = new JPanel();

    public DesktopPane() {
        this.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
        this.setOpaque(true);
        this.setBackground(Color.lightGray);
        this.addMouseListener(new MouseAdapter(){

            static /* synthetic */ DesktopPane access$000(1 x0) {
                return x0.DesktopPane.this;
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem selBack = new JMenuItem(ClientSettings.getInstance().getResources().getResource("change background"));
                    popup.add(selBack);
                    selBack.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void actionPerformed(ActionEvent e) {
                            DesktopPane.access$100(1.access$000(this.this$1));
                        }
                    });
                    JMenuItem clearBack = new JMenuItem(ClientSettings.getInstance().getResources().getResource("reset background"));
                    popup.add(clearBack);
                    clearBack.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void actionPerformed(ActionEvent e) {
                            DesktopPane.access$200(1.access$000(this.this$1));
                        }
                    });
                    popup.show(DesktopPane.this, e.getY(), e.getY());
                }
            }
        });
        this.initModalPane();
    }

    static /* synthetic */ void access$100(DesktopPane x0) {
        x0.selectBackground();
    }

    static /* synthetic */ void access$200(DesktopPane x0) {
        x0.resetBackground();
    }

    public final void add(InternalFrame frame, boolean maximum) {
        try {
            super.add(frame);
            int w = this.getVisibleRect().width;
            int h = this.getVisibleRect().height;
            if (w == 0) {
                w = this.getSize().width;
            }
            if (h == 0) {
                h = this.getSize().width;
            }
            if (maximum) {
                frame.setSize(new Dimension(w, h));
                frame.setLocation(0, 0);
            }
            if (!frame.isMaximum()) {
                frame.setLocation(Math.max(w - frame.getWidth(), 0) / 2, Math.max(h - frame.getHeight(), 0) / 2);
            }
            if (!frame.isVisible()) {
                frame.setVisible(true);
            }
            if (!frame.isSelected()) {
                frame.setSelected(true);
            }
            frame.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosed(InternalFrameEvent e) {
                    if (DesktopPane.this.getSelectedFrame() == null && DesktopPane.this.getAllFrames().length > 0) {
                        JInternalFrame frame = DesktopPane.this.getAllFrames()[0];
                        try {
                            frame.toFront();
                            frame.setSelected(true);
                        }
                        catch (PropertyVetoException ex) {
                        }
                    }
                }
            });
            if (ClientSettings.SHOW_SCROLLBARS_IN_MDI) {
                Container c = this;
                while (c != null && !(c instanceof JScrollPane)) {
                    c = c.getParent();
                }
                if (c != null) {
                    final JScrollPane scrollPane = (JScrollPane)c;
                    frame.addComponentListener(new ComponentAdapter(){

                        static /* synthetic */ JScrollPane access$300(7 x0) {
                            return x0.scrollPane;
                        }

                        public void componentMoved(ComponentEvent e) {
                            if (e.getComponent().getLocation().x + e.getComponent().getSize().width > DesktopPane.this.getWidth() || e.getComponent().getLocation().y + e.getComponent().getSize().height > DesktopPane.this.getHeight()) {
                                int locx = e.getComponent().getLocation().x;
                                int locy = e.getComponent().getLocation().y;
                                int x = Math.max(e.getComponent().getLocation().x + e.getComponent().getSize().width, DesktopPane.this.getWidth());
                                int y = Math.max(e.getComponent().getLocation().y + e.getComponent().getSize().height, DesktopPane.this.getHeight());
                                DesktopPane.this.setPreferredSize(new Dimension(x, y));
                                DesktopPane.this.setSize(new Dimension(x, y));
                                scrollPane.getViewport().setViewSize(new Dimension(x, y));
                                scrollPane.getViewport().setSize(new Dimension(x, y));
                                SwingUtilities.invokeLater(new Runnable(this, locx, locy){
                                    private final /* synthetic */ 7 this$1;
                                    private final /* synthetic */ int val$locx;
                                    private final /* synthetic */ int val$locy;
                                    {
                                        this.this$1 = this$1;
                                        this.val$locx = val$locx;
                                        this.val$locy = val$locy;
                                    }

                                    public void run() {
                                        7.access$300(this.this$1).getHorizontalScrollBar().setValue(this.val$locx);
                                        7.access$300(this.this$1).getVerticalScrollBar().setValue(this.val$locy);
                                    }
                                });
                            }
                        }
                    });
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected final void addImpl(Component comp, Object constraints, int index) {
        DesktopManager manager = null;
        if (comp instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)comp;
            EventListener[] listeners = frame.getListeners(class$javax$swing$event$InternalFrameListener == null ? (class$javax$swing$event$InternalFrameListener = DesktopPane.class$("javax.swing.event.InternalFrameListener")) : class$javax$swing$event$InternalFrameListener);
            int i = 0;
            i = 0;
            while (i < listeners.length) {
                if (listeners[i] == this) break;
                ++i;
            }
            if (i >= listeners.length) {
                frame.addInternalFrameListener(this);
            }
            if (comp.getParent() == this) {
                return;
            }
            if (this.layeringComp != comp) {
                manager = this.getDesktopManager();
            }
        }
        super.addImpl(comp, constraints, index);
        if (manager != null) {
            manager.openFrame((JInternalFrame)comp);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public void init(MDIController client) {
        if (!this.loadUserProfile(client) && ClientSettings.BACKGROUND != null) {
            this.background = ClientUtils.getImage(ClientSettings.BACKGROUND);
        }
    }

    private void initModalPane() {
        this.modalPane.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.modalPane.setOpaque(false);
        this.modalPane.setVisible(true);
        this.modalPane.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                Toolkit.getDefaultToolkit().beep();
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public final void internalFrameActivated(InternalFrameEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$javax$swing$event$InternalFrameListener == null ? (class$javax$swing$event$InternalFrameListener = DesktopPane.class$("javax.swing.event.InternalFrameListener")) : class$javax$swing$event$InternalFrameListener);
        int i = 0;
        while (i < listeners.length) {
            InternalFrameListener listener = (InternalFrameListener)listeners[i];
            listener.internalFrameActivated(e);
            ++i;
        }
    }

    public final void internalFrameClosed(InternalFrameEvent e) {
        if (this.modal) {
            this.setModal(false);
        }
        EventListener[] listeners = this.listenerList.getListeners(class$javax$swing$event$InternalFrameListener == null ? (class$javax$swing$event$InternalFrameListener = DesktopPane.class$("javax.swing.event.InternalFrameListener")) : class$javax$swing$event$InternalFrameListener);
        int i = 0;
        while (i < listeners.length) {
            InternalFrameListener listener = (InternalFrameListener)listeners[i];
            listener.internalFrameClosed(e);
            ++i;
        }
    }

    public final void internalFrameClosing(InternalFrameEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$javax$swing$event$InternalFrameListener == null ? (class$javax$swing$event$InternalFrameListener = DesktopPane.class$("javax.swing.event.InternalFrameListener")) : class$javax$swing$event$InternalFrameListener);
        int i = 0;
        while (i < listeners.length) {
            InternalFrameListener listener = (InternalFrameListener)listeners[i];
            listener.internalFrameClosing(e);
            ++i;
        }
    }

    public final void internalFrameDeactivated(InternalFrameEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$javax$swing$event$InternalFrameListener == null ? (class$javax$swing$event$InternalFrameListener = DesktopPane.class$("javax.swing.event.InternalFrameListener")) : class$javax$swing$event$InternalFrameListener);
        int i = 0;
        while (i < listeners.length) {
            InternalFrameListener listener = (InternalFrameListener)listeners[i];
            listener.internalFrameDeactivated(e);
            ++i;
        }
    }

    public final void internalFrameDeiconified(InternalFrameEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$javax$swing$event$InternalFrameListener == null ? (class$javax$swing$event$InternalFrameListener = DesktopPane.class$("javax.swing.event.InternalFrameListener")) : class$javax$swing$event$InternalFrameListener);
        int i = 0;
        while (i < listeners.length) {
            InternalFrameListener listener = (InternalFrameListener)listeners[i];
            listener.internalFrameDeiconified(e);
            ++i;
        }
    }

    public final void internalFrameIconified(InternalFrameEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$javax$swing$event$InternalFrameListener == null ? (class$javax$swing$event$InternalFrameListener = DesktopPane.class$("javax.swing.event.InternalFrameListener")) : class$javax$swing$event$InternalFrameListener);
        int i = 0;
        while (i < listeners.length) {
            InternalFrameListener listener = (InternalFrameListener)listeners[i];
            listener.internalFrameIconified(e);
            ++i;
        }
    }

    public final void internalFrameOpened(InternalFrameEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$javax$swing$event$InternalFrameListener == null ? (class$javax$swing$event$InternalFrameListener = DesktopPane.class$("javax.swing.event.InternalFrameListener")) : class$javax$swing$event$InternalFrameListener);
        int i = 0;
        while (i < listeners.length) {
            InternalFrameListener listener = (InternalFrameListener)listeners[i];
            listener.internalFrameOpened(e);
            ++i;
        }
    }

    public final boolean isModal() {
        return this.modal;
    }

    private boolean loadUserProfile(MDIController client) {
        File confFile;
        String file = System.getProperty("user.home").replace('\\', '/');
        if (!file.endsWith("/")) {
            file = file + "/";
        }
        if (!(confFile = new File(file = file + "profiles/" + client.getMDIFrameTitle() + ".cfg")).exists()) {
            return false;
        }
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(confFile));
            this.backgroundFileName = p.getProperty("backgroundFileName");
            if (this.backgroundFileName != null && !this.backgroundFileName.equals("")) {
                return this.setBackgroundImageFromFile();
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public final void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.background != null) {
            if (ClientSettings.BACK_IMAGE_DISPOSITION == 1) {
                int imgWidth = this.background.getWidth(this);
                int imgHeight = this.background.getHeight(this);
                int i = this.getWidth();
                while (i > 0) {
                    int j = 0;
                    while (j < this.getHeight()) {
                        g.drawImage(this.background, i - imgWidth, j, this);
                        j += imgHeight;
                    }
                    i -= imgWidth;
                }
            } else if (ClientSettings.BACK_IMAGE_DISPOSITION == 0) {
                int imgWidth = this.background.getWidth(this);
                int imgHeight = this.background.getHeight(this);
                int x = (this.getWidth() - imgWidth) / 2;
                int y = (this.getHeight() - imgHeight) / 2;
                g.drawImage(this.background, x, y, this);
            } else if (ClientSettings.BACK_IMAGE_DISPOSITION == 2) {
                g.drawImage(this.background, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        }
        if (ClientSettings.BACKGROUND_PAINTER != null) {
            ClientSettings.BACKGROUND_PAINTER.paint(this, g);
        }
    }

    private void resetBackground() {
        this.backgroundFileName = null;
        this.background = ClientUtils.getImage(ClientSettings.BACKGROUND);
        this.repaint();
        this.saveUserProfile();
    }

    private void saveUserProfile() {
        try {
            Properties p = new Properties();
            if (this.backgroundFileName == null) {
                this.backgroundFileName = "";
            }
            p.setProperty("backgroundFileName", this.backgroundFileName);
            String file = System.getProperty("user.home").replace('\\', '/');
            if (!file.endsWith("/")) {
                file = file + "/";
            }
            file = file + "profiles/" + MDIFrame.getInstance().getTitle() + ".cfg";
            p.store(new FileOutputStream(new File(file)), "User Properties");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void selectBackground() {
        JFileChooser f = new JFileChooser();
        f.setDialogTitle(ClientSettings.getInstance().getResources().getResource("image selection"));
        f.setFileSelectionMode(0);
        f.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".gif") || f.getName().toLowerCase().endsWith(".jpg");
            }

            public String getDescription() {
                return "Image Files (*.gif;*.jpg)";
            }
        });
        int res = f.showOpenDialog(MDIFrame.getInstance());
        if (res == 0) {
            this.backgroundFileName = f.getSelectedFile().getAbsolutePath();
            this.setBackgroundImageFromFile();
            this.saveUserProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setBackgroundImageFromFile() {
        boolean bl;
        BufferedInputStream in = null;
        try {
            try {
                File file = new File(this.backgroundFileName);
                in = new BufferedInputStream(new FileInputStream(file));
                byte[] bytes = new byte[(int)file.length()];
                in.read(bytes);
                this.background = new ImageIcon(bytes).getImage();
                this.repaint();
                bl = true;
                Object var6_7 = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                boolean bl2 = false;
                Object var6_8 = null;
                try {
                    if (in == null) return bl2;
                    in.close();
                    return bl2;
                }
                catch (Exception ex1) {
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {}
            catch (Exception ex1) {
                throw throwable;
            }
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        try {}
        catch (Exception ex1) {
            return bl;
        }
        if (in == null) return bl;
        in.close();
        return bl;
    }

    public final void setLayer(Component c, int layer, int position) {
        if (this.layeringComp != c) {
            this.layeringComp = c;
            super.setLayer(c, layer, position);
            this.layeringComp = null;
        }
    }

    public final void setModal(JInternalFrame modalDialog, boolean modal) {
        this.modal = modal;
        if (this.modal) {
            this.add(this.modalPane);
            this.setLayer(this.modalPane, JLayeredPane.PALETTE_LAYER);
            JInternalFrame[] frames = this.getAllFrames();
            int defaultLayer = JLayeredPane.DEFAULT_LAYER;
            int i = 0;
            while (i < frames.length) {
                if (frames[i].getLayer() != defaultLayer) {
                    this.setLayer(frames[i], defaultLayer);
                }
                ++i;
            }
            this.setLayer(modalDialog, JLayeredPane.MODAL_LAYER);
            modalDialog.moveToFront();
        } else {
            this.remove(this.modalPane);
            JInternalFrame[] frames = this.getAllFrames();
            int defaultLayer = JLayeredPane.DEFAULT_LAYER;
            int i = 0;
            while (i < frames.length) {
                if (frames[i].getLayer() != defaultLayer) {
                    this.setLayer(frames[i], defaultLayer);
                }
                ++i;
            }
        }
    }

    public final void setModal(boolean modal) {
        if (this.modal != modal) {
            this.setModal(this.getSelectedFrame(), modal);
        }
    }
}

